/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.wrapper.BrtmWrapperFactory;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class ResponseDecorationUtils {
    private static final Module BRTM_MODULE = new Module("BrowserAgent");

    public static void createCookiesAndHeader(IAgent agent, IModuleFeedbackChannel feedback, HttpServletResponse resp) {
        Object shouldAddResponseDecoration = BTThreadLocalAdministrator.getInstance().get("shouldAddResponseCookie");
        if (shouldAddResponseDecoration == null || shouldAddResponseDecoration instanceof Boolean && !((Boolean)shouldAddResponseDecoration).booleanValue()) {
            return;
        }
        String url = (String)BTThreadLocalAdministrator.getInstance().get("BRTM_REQ_URI");
        String value = ResponseDecorationUtils.getBTCorrelationValue(agent, feedback, resp, url);
        ResponseDecorationUtils.createCookie(value, agent, feedback, resp, url);
        ResponseDecorationUtils.createHeader(value, agent, feedback, resp, url);
    }

    private static void createHeader(String value, IAgent agent, IModuleFeedbackChannel feedback, HttpServletResponse resp, String url) {
        Object created = BTThreadLocalAdministrator.getInstance().get("createdHeader");
        if (created instanceof Boolean && ((Boolean)created).booleanValue()) {
            return;
        }
        if (value.length() > 0) {
            String origin = BTThreadLocalAdministrator.getInstance().getString("Origin");
            if (origin != null && !resp.containsHeader("Access-Control-Allow-Origin")) {
                resp.addHeader("Access-Control-Allow-Origin", origin);
            }
            resp.addHeader("x-apm-ba-response-bt", value);
            resp.addHeader("Access-Control-Expose-Headers", "x-apm-ba-response-bt");
            BTThreadLocalAdministrator.getInstance().insert("createdHeader", (Object)Boolean.TRUE);
            if (feedback.isTraceEnabled()) {
                feedback.trace("...createHeader ..header ... = " + value + ", url = " + url);
            }
        }
    }

    private static void createCookie(String value, IAgent agent, IModuleFeedbackChannel feedback, HttpServletResponse resp, String url) {
        String created = BTThreadLocalAdministrator.getInstance().getString("createdCookie");
        if (created != null || !BrtmWrapperFactory.enableCookie()) {
            return;
        }
        ResponseDecorationUtils.setPageCookie(resp, value, url, feedback);
    }

    private static String getBTCorrelationValue(IAgent agent, IModuleFeedbackChannel feedback, HttpServletResponse resp, String url) {
        String value = BTThreadLocalAdministrator.getInstance().getString("btCorrelationValue");
        if (value == null) {
            block13: {
                String encrypted_UTF8_Msg;
                Object params;
                Object btDefineObj;
                StringBuilder decorationData = new StringBuilder();
                long time = 0L;
                Object startTimeObj = BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-tt-starttime");
                if (startTimeObj != null) {
                    time = (Long)startTimeObj;
                    if (BrtmWrapperFactory.enableCookie()) {
                        Cookie serverTimeCookie = ResponseDecorationUtils.createSingleCookie("x-apm-brtm-servertime", String.valueOf(time), "/", -1L);
                        resp.addCookie(serverTimeCookie);
                    }
                    decorationData.append("servertime=").append(time).append(",");
                }
                IBizTrx btDefine = (btDefineObj = BTThreadLocalAdministrator.getInstance().get("BusinessTrxData")) instanceof IBizTrx ? (IBizTrx)btDefineObj : null;
                Boolean ttSent = ResponseDecorationUtils.getFiltersStatus(agent);
                if (btDefine != null) {
                    decorationData.append("bs=").append(btDefine.getBizProcessName()).append(",bt=").append(btDefine.getBizTrxName()).append(",btc=").append(btDefine.getBizTrxComponentName()).append(",");
                }
                if (BTThreadLocalAdministrator.getInstance().isCorguidEnabled() || ttSent.booleanValue()) {
                    String guidKey;
                    SharedCrossProcessData cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
                    if (cache == null || cache.getCorrelationID() == null) {
                        CorrelationId correlationId = new CorrelationId();
                    }
                    if ((guidKey = cache.getCorrelationID()) != null) {
                        decorationData.append("CorBrowsGUID").append("=").append(guidKey).append(",");
                    }
                    if (time > 0L) {
                        decorationData.append("startTime=").append(time).append(",");
                        if (BTThreadLocalAdministrator.getInstance().get("endTime") != null) {
                            time = (Long)BTThreadLocalAdministrator.getInstance().get("endTime");
                        }
                        decorationData.append("endTime=").append(time).append(",");
                    }
                }
                if ((params = BTThreadLocalAdministrator.getInstance().get("agentInfo")) != null && params instanceof Map && (encrypted_UTF8_Msg = ResponseDecorationUtils.toEncryptedAgentInfo((Map)params, feedback)) != null && encrypted_UTF8_Msg.length() > 0) {
                    decorationData.append(encrypted_UTF8_Msg).append(",");
                }
                if ((value = decorationData.toString()).length() > 0) {
                    value = value.substring(0, value.length() - 1);
                    try {
                        value = URLEncoder.encode(value, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!feedback.isDebugEnabled()) break block13;
                        feedback.debug(BRTM_MODULE, "Browser Agent UnsupportedEncodingException:" + e.toString());
                    }
                }
            }
            BTThreadLocalAdministrator.getInstance().insert("btCorrelationValue", (Object)value);
        }
        return value;
    }

    public static void setPageCookie(HttpServletResponse resp, String cookieValue, String url, IModuleFeedbackChannel feedback) {
        Object isAJAXCall = BTThreadLocalAdministrator.getInstance().get("isAjaxCall");
        if (isAJAXCall instanceof Boolean && ((Boolean)isAJAXCall).booleanValue()) {
            BTThreadLocalAdministrator.getInstance().insert("createdCookie", (Object)"");
            return;
        }
        if (ResponseDecorationUtils.addCookieByContentType(resp, url, feedback)) {
            String lastPartUrl;
            block6: {
                lastPartUrl = ResponseDecorationUtils.getLastPartOfURL(url);
                if (lastPartUrl.length() > 0) {
                    try {
                        lastPartUrl = URLEncoder.encode(lastPartUrl, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!feedback.isDebugEnabled()) break block6;
                        feedback.debug(BRTM_MODULE, "Browser Agent URL UnsupportedEncodingException:" + e.toString());
                    }
                }
            }
            String name = "x-apm-brtm-response-bt-page-" + lastPartUrl;
            long gaptime = ResponseDecorationUtils.getGapTime(url, feedback);
            Cookie c = ResponseDecorationUtils.createSingleCookie(name, cookieValue, "/", gaptime);
            resp.addCookie(c);
            BTThreadLocalAdministrator.getInstance().insert("createdCookie", (Object)name);
            if (feedback.isTraceEnabled()) {
                feedback.trace("...createCookie .." + name + " ... = " + cookieValue + ", url = " + url);
            }
        }
    }

    private static boolean addCookieByContentType(HttpServletResponse resp, String url, IModuleFeedbackChannel feedback) {
        String[] cookieContentTypeArray = BTThreadLocalAdministrator.getInstance().getCookieContentTypeArray();
        if (cookieContentTypeArray == null || cookieContentTypeArray.length == 0) {
            if (feedback.isTraceEnabled()) {
                feedback.trace("...addCookieByContentType .. false.., url = " + url);
            }
            return true;
        }
        String respContentType = resp.getContentType();
        if (respContentType != null) {
            respContentType = respContentType.toLowerCase();
            for (String cookieContentType : cookieContentTypeArray) {
                if ((cookieContentType = cookieContentType.trim().toLowerCase()) == null || cookieContentType.length() <= 0 || !cookieContentType.contains(respContentType) && !respContentType.contains(cookieContentType)) continue;
                if (feedback.isTraceEnabled()) {
                    feedback.trace("...addCookieByContentType .. true.., url = " + url);
                }
                return true;
            }
        }
        if (feedback.isTraceEnabled()) {
            feedback.trace("...addCookieByContentType .. false.., url = " + url);
        }
        return false;
    }

    public static boolean getFiltersStatus(IAgent agent) {
        if (agent.IAgent_getComponentTracer().getHeadFilteringStatus()) {
            return true;
        }
        boolean checkHeadPresence = BTThreadLocalAdministrator.getInstance().shouldCheckForHeadFilterPresence();
        boolean checkTailPresence = BTThreadLocalAdministrator.getInstance().shouldCheckForTailFilterPresence();
        if (checkHeadPresence && checkTailPresence) {
            return FilterController.getDynamicFilterPresence();
        }
        if (checkHeadPresence) {
            return FilterController.getTransientHeadFilterPresence();
        }
        if (checkTailPresence) {
            return FilterController.getTailFilterPresence();
        }
        return false;
    }

    public static String toEncryptedAgentInfo(Map<String, String> params, IModuleFeedbackChannel feedback) {
        StringBuilder result = new StringBuilder();
        boolean firstItem = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value = entry.getValue();
            if (value == null || value.length() <= 0) continue;
            if (!firstItem) {
                result.append(',');
            } else {
                firstItem = false;
            }
            result.append(entry.getKey());
            result.append('=');
            result.append(value);
        }
        return result.toString();
    }

    private static long getGapTime(String url, IModuleFeedbackChannel feedback) {
        long gaptime = 0L;
        String gaptimeObj = BTThreadLocalAdministrator.getInstance().getString("x-apm-brtm-gaptime");
        if (gaptimeObj != null) {
            try {
                gaptime = Long.parseLong(gaptimeObj);
            }
            catch (NumberFormatException e) {
                gaptime = 0L;
            }
            if (gaptime < 0L) {
                gaptime = 0L;
            } else if (gaptime + 120L >= Integer.MAX_VALUE) {
                gaptime = -1L;
            }
        }
        if (feedback.isTraceEnabled()) {
            feedback.trace("...insertBRTMCookie ..client-server gaptime... = " + gaptime + ", url = " + url);
        }
        return gaptime;
    }

    private static Cookie createSingleCookie(String name, String value, String path, long gapTime) {
        BTThreadLocalAdministrator.getInstance();
        int expirationTime = BTThreadLocalAdministrator.getResponseCookieExpirationTime();
        Cookie c = new Cookie(name, value);
        c.setPath(path);
        if (gapTime != -1L) {
            c.setMaxAge((int)((long)expirationTime + gapTime));
        }
        return c;
    }

    private static String getLastPartOfURL(String url) {
        int lastSlashIndex;
        String last = "";
        if (url != null && url.length() > 0 && (last = url.substring((lastSlashIndex = url.lastIndexOf("/")) + 1)).length() == 0) {
            int secondLastSlashIndex = url.substring(0, lastSlashIndex).lastIndexOf("/");
            if (secondLastSlashIndex > -1) {
                last = url.substring(secondLastSlashIndex + 1);
            } else if ("/".equals(url)) {
                last = "/";
            }
        }
        return last;
    }
}

