/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.remotejmx;

import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.JmxAtcVertexInfo;
import com.ca.apm.agent.jmxclient.api.JmxConnectionInfo;
import com.ca.apm.agent.jmxclient.api.JmxMetricInfo;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.api.SSLSettings;
import com.ca.apm.agent.remotejmx.Configuration;
import com.ca.apm.agent.remotejmx.Properties;
import com.ca.apm.agent.remotejmx.RemoteJmxService;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.properties.IndexedProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class CommonUtils {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();

    public static Set<JmxNodeInfo> fetchConnectionDetails(List<String> serverKeys) {
        return CommonUtils.fetchConnectionDetails(Configuration.getIndexedProperties(), serverKeys);
    }

    public static Set<JmxNodeInfo> fetchConnectionDetails(IndexedProperties props, List<String> serverKeys) {
        LinkedHashSet<JmxNodeInfo> jmxNodes = new LinkedHashSet<JmxNodeInfo>(serverKeys.size());
        SSLSettings sslSettings = new SSLSettings();
        String ts = props.getProperty("introscope.agent.remotejmx.ssl.trustStore", "");
        if (Utils.isNonEmpty(ts)) {
            sslSettings.setTrustStore(new File(ts).isAbsolute() ? ts : Configuration.getSecurityDirPath() + File.separator + ts);
        }
        sslSettings.setTrustStorePassword(props.getProperty("introscope.agent.remotejmx.ssl.trustStorePassword"));
        String ks = props.getProperty("introscope.agent.remotejmx.ssl.keyStore", "");
        if (Utils.isNonEmpty(ks)) {
            sslSettings.setKeyStore(new File(ks).isAbsolute() ? ks : Configuration.getSecurityDirPath() + File.separator + ks);
        }
        sslSettings.setKeyStorePassword(props.getProperty("introscope.agent.remotejmx.ssl.keyStorePassword"));
        for (String serverKey : serverKeys) {
            String urls = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.jmxurl", serverKey);
            String hostPortTuples = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.hostport", "localhost:0000", serverKey);
            String autoDetect = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.autoDetect", serverKey);
            ArrayList<JmxConnectionInfo> connInfos = new ArrayList<JmxConnectionInfo>();
            if (Utils.isNonEmpty(urls)) {
                for (String url : urls.split(",")) {
                    connInfos.add(JmxConnectionInfo.newInstanceFromUrl(url.trim()));
                }
            } else if (Utils.isNonEmpty(hostPortTuples)) {
                for (String hostPortTuple : hostPortTuples.split(",")) {
                    String[] hostPort = hostPortTuple.trim().split(":");
                    connInfos.add(hostPort.length == 2 ? JmxConnectionInfo.newInstance(Utils.getValidHostName(hostPort[0]), Integer.valueOf(hostPort[1])) : JmxConnectionInfo.newInstance(Utils.getValidHostName(hostPort[0])));
                }
            }
            if (connInfos.isEmpty()) {
                LOGGER.logError(String.format("Could not find valid jmx url or host&port settings for jmx server with key '%s'", serverKey));
                continue;
            }
            for (JmxConnectionInfo connInfo : connInfos) {
                String configSpringbootThreads;
                String configSyncInterval;
                String pollingInterval;
                connInfo.setSslEnabled(Boolean.parseBoolean(CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.ssl.enabled", Properties.JMX_SSL_ENABLED_PROPERTY_DEFAULT_VALUE, serverKey)));
                connInfo.setRegistrySecure(Boolean.parseBoolean(CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.registry.ssl.enabled", Properties.JMX_RMI_REGISTRY_SSL_PROPERTY_DEFAULT_VALUE, serverKey)));
                connInfo.setSslSettings(sslSettings);
                connInfo.setAuthUserName(CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.authentication.username", serverKey));
                connInfo.setAuthPassword(CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.authentication.password", serverKey));
                String serverNameProperty = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.name", "JMX System", serverKey);
                String serverName = Utils.formatNodeName(serverNameProperty, serverKey, "unknown", connInfo.getHost(), connInfo.getPort());
                String metricRootNameProperty = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.metricRootName", "JMX|{name} on {host}_{port}", serverKey);
                String metricRootName = "";
                metricRootName = connInfo.getPort() == 0 ? "JMX" : Utils.formatNodeName(metricRootNameProperty, serverKey, serverName, connInfo.getHost(), connInfo.getPort());
                String vertexNameProperty = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.atcVertexName", "{name} on {host}_{port}", serverKey);
                String vertexName = Utils.formatNodeName(vertexNameProperty, serverKey, serverName, connInfo.getHost(), connInfo.getPort());
                JmxAtcVertexInfo vertexInfo = new JmxAtcVertexInfo(vertexName);
                String whiteList = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.mbeanPatternsWhiteList", Properties.JMX_METRICS_MBEAN_WHITELIST_PROPERTY_DEFAULT_VALUE, serverKey);
                String blackList = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.mbeanPatternsBlackList", "", serverKey);
                String forceDiscovery = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.force.discovery", Properties.JMX_METRICS_MBEAN_FORCE_DISCOVERY_DEFAULT_VALUE, serverKey);
                JmxMetricInfo metricInfo = new JmxMetricInfo(metricRootName, whiteList, blackList, forceDiscovery);
                String[] configModulePaths = CommonUtils.getModulePaths(CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.config.modules", "jvm,memory", serverKey), Configuration.getConfigDirPath() + File.separator + "modules");
                metricInfo.setConfigModulePaths(configModulePaths);
                String autoConfig = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.autoConfig.enabled", Properties.JMX_METRICS_AUTO_CONFIG_PROPERTY_DEFAULT_VALUE, serverKey);
                metricInfo.setAutoConfigEnabled(Boolean.parseBoolean(autoConfig));
                String dumpDirPath = CommonUtils.getAbsolutePath(CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.configExampleDumpDir", serverKey));
                if (Utils.isNonEmpty(dumpDirPath)) {
                    metricInfo.setConfigDumpDirPath(dumpDirPath);
                }
                if (Utils.isNonEmpty(pollingInterval = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.polling.interval.seconds", serverKey))) {
                    metricInfo.setPollingInterval(Long.valueOf(pollingInterval));
                }
                if (Utils.isNonEmpty(configSyncInterval = CommonUtils.fetchPropertyForServer(props, "introscope.agent.remotejmx.system.$key.configSync.interval.seconds", serverKey))) {
                    metricInfo.setConfigSyncInterval(Long.valueOf(configSyncInterval));
                }
                if (Utils.isNonEmpty(configSpringbootThreads = CommonUtils.fetchPropertyForServer(props, "introscope.agent.jmx.springboot.threads", serverKey))) {
                    String[] threadsList = configSpringbootThreads.split(",");
                    metricInfo.setConfigThreads(Arrays.asList(threadsList));
                }
                JmxNodeInfo nodeInfo = new JmxNodeInfo(serverName, connInfo, metricInfo, vertexInfo);
                jmxNodes.add(nodeInfo);
            }
        }
        return jmxNodes;
    }

    private static String[] getModulePaths(String list) {
        return CommonUtils.getModulePaths(list, Configuration.getConfigDirPath());
    }

    private static String[] getModulePaths(String pathList, String defaultParentDir) {
        String[] newPaths = new String[]{};
        if (pathList != null) {
            String[] paths = pathList.split(",");
            LinkedHashSet<String> uniquePaths = new LinkedHashSet<String>();
            for (int i = 0; i < paths.length; ++i) {
                String p = CommonUtils.getAbsolutePath(paths[i].trim(), defaultParentDir);
                if (p == null) continue;
                if (new File(p).exists()) {
                    uniquePaths.add(p);
                    continue;
                }
                uniquePaths.add(paths[i].trim());
            }
            return uniquePaths.toArray(newPaths);
        }
        return newPaths;
    }

    private static String getAbsolutePath(String path) {
        return CommonUtils.getAbsolutePath(path, Configuration.getConfigDirPath());
    }

    private static String getAbsolutePath(String path, String defaultParentDir) {
        if (Utils.isNonEmpty(path)) {
            return new File(path).isAbsolute() ? path : defaultParentDir + File.separator + path;
        }
        return null;
    }

    private static String fetchPropertyForServer(IndexedProperties props, String property, String defaultValue, String serverKey) {
        String value = props.getProperty(Utils.formatServerProperty(property, serverKey), defaultValue);
        return value;
    }

    private static String fetchPropertyForServer(IndexedProperties props, String property, String serverKey) {
        return props.getProperty(Utils.formatServerProperty(property, serverKey));
    }

    private static Observer createObserver(String serverKey) {
        final String key = Utils.formatServerProperty("introscope.agent.remotejmx.system.$key.hostport", serverKey);
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Set currentPorts = (Set)arg;
                StringBuffer sb = new StringBuffer();
                Iterator iter = currentPorts.iterator();
                if (iter.hasNext()) {
                    sb.append(String.format("%s:%d", "localhost", iter.next()));
                    while (iter.hasNext()) {
                        sb.append(String.format(",%s:%d", "localhost", iter.next()));
                    }
                }
                Configuration.getIndexedProperties().put((Object)key, (Object)sb.toString());
                LOGGER.logDebugMessage("Automatic JMX Server Detection Observer - Updating property:" + key + "=" + sb);
                String v = Configuration.getIndexedProperties().getProperty("introscope.agent.remotejmx.system.keys", "s1");
                RemoteJmxService.getInstance().updateJmxNodes(Utils.convert(v));
            }
        };
    }
}

