/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.remotejmx;

import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.remotejmx.Properties;
import com.ca.apm.agent.remotejmx.RemoteJmxService;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.StringListConfigurationProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Configuration {
    private static final Module MODULE = new Module("RemoteJMX");
    private static volatile Logger.ILoggingHandler logger = new Logger.NoOpLoggingHandler();
    private static volatile IAgent agent = null;
    private static ExtendedFile extHomeDir;
    private static final List<ConfigurationProperty> jmxSystemProperties;

    public static void init(RemoteJmxService jmxService, ExtendedFile extHomeDir) {
        Configuration.extHomeDir = extHomeDir;
        Configuration.registerJmxServerKeysProperty(jmxService);
    }

    private static void registerJmxServerKeysProperty(final RemoteJmxService jmxService) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        List<String> defaultValue = Utils.convert("s1");
        StringListConfigurationProperty property = new StringListConfigurationProperty("introscope.agent.remotejmx.system.keys", defaultValue, "", "", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public void set(Object value) {
                super.set(value);
                Configuration.unregisterSystemKeyProperties();
                List keys = (List)value;
                jmxService.updateJmxNodes(keys);
                Configuration.registerSystemKeyProperties(keys, jmxService);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void registerSystemKeyProperties(List<String> keys, RemoteJmxService jmxService) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        for (String key : keys) {
            ConfigurationProperty nameProp = Configuration.createConfigPropertyInstance(Utils.formatServerProperty("introscope.agent.remotejmx.system.$key.name", key), "JMX System", jmxService);
            configManager.add(nameProp, true);
            jmxSystemProperties.add(nameProp);
            ConfigurationProperty hostProp = Configuration.createConfigPropertyInstance(Utils.formatServerProperty("introscope.agent.remotejmx.system.$key.hostport", key), "localhost:0000", jmxService);
            configManager.add(hostProp, true);
            jmxSystemProperties.add(hostProp);
            ConfigurationProperty autoDetectProp = Configuration.createConfigPropertyInstance(Utils.formatServerProperty("introscope.agent.remotejmx.system.$key.autoDetect", key), Properties.JMX_SYSTEM_AUTO_DETECTION_ENABLED_PROPERTY_DEFAULT_VALUE, jmxService);
            configManager.add(autoDetectProp, true);
            jmxSystemProperties.add(autoDetectProp);
            ConfigurationProperty whiteListProp = Configuration.createConfigPropertyInstance(Utils.formatServerProperty("introscope.agent.remotejmx.system.$key.mbeanPatternsWhiteList", key), Properties.JMX_METRICS_MBEAN_WHITELIST_PROPERTY_DEFAULT_VALUE, jmxService);
            configManager.add(whiteListProp, true);
            jmxSystemProperties.add(whiteListProp);
            ConfigurationProperty blackListProp = Configuration.createConfigPropertyInstance(Utils.formatServerProperty("introscope.agent.remotejmx.system.$key.mbeanPatternsBlackList", key), "", jmxService);
            configManager.add(blackListProp, true);
            jmxSystemProperties.add(blackListProp);
            ConfigurationProperty forceDiscoveryProp = Configuration.createConfigPropertyInstance(Utils.formatServerProperty("introscope.agent.remotejmx.system.$key.force.discovery", key), Properties.JMX_METRICS_MBEAN_FORCE_DISCOVERY_DEFAULT_VALUE, jmxService);
            configManager.add(forceDiscoveryProp, true);
            jmxSystemProperties.add(forceDiscoveryProp);
        }
    }

    private static ConfigurationProperty createConfigPropertyInstance(String prop, String defaultValue, final RemoteJmxService jmxService) {
        return new ConfigurationProperty(prop, defaultValue, "", "", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public void set(Object value) {
                if (!this.getValue().equals(value)) {
                    String v = agent.IAgent_getIndexedProperties().getProperty("introscope.agent.remotejmx.system.keys", "s1");
                    jmxService.updateJmxNodes(Utils.convert(v));
                }
            }
        };
    }

    private static void unregisterSystemKeyProperties() {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        for (ConfigurationProperty cp : jmxSystemProperties) {
            configManager.remove(cp);
        }
        jmxSystemProperties.clear();
    }

    public static int getMaxConnections() {
        return agent.IAgent_getIndexedProperties().getIntProperty("introscope.agent.remotejmx.connections.max", 10);
    }

    public static String getMBeanWhiteList() {
        return agent.IAgent_getIndexedProperties().getProperty("introscope.agent.remotejmx.system.$key.mbeanPatternsWhiteList", Properties.JMX_METRICS_MBEAN_WHITELIST_PROPERTY_DEFAULT_VALUE);
    }

    public static String getMBeanBlackList() {
        return agent.IAgent_getIndexedProperties().getProperty("introscope.agent.remotejmx.system.$key.mbeanPatternsBlackList", "");
    }

    public static String getConfigModulePaths() {
        return agent.IAgent_getIndexedProperties().getProperty("introscope.agent.remotejmx.system.$key.config.modules", "jvm,memory");
    }

    public static int getAutoDetectionInterval() {
        return agent.IAgent_getIndexedProperties().getIntProperty("introscope.agent.remotejmx.autoDetection.interval.seconds", 60);
    }

    public static Logger.ILoggingHandler getLogger() {
        return logger;
    }

    public static Module getModule() {
        return logger.getModule();
    }

    public static IAgent getAgent() {
        return agent;
    }

    public static IndexedProperties getIndexedProperties() {
        return agent.IAgent_getIndexedProperties();
    }

    public static File getExtHomeDir() {
        return extHomeDir.getFile();
    }

    static void setExtHomeDir(ExtendedFile dir) {
        extHomeDir = dir;
    }

    public static ExtendedFile getConfigDir() {
        return new ExtendedFile(Configuration.getExtHomeDir().getAbsolutePath(), "config");
    }

    public static String getConfigDirPath() {
        return Configuration.getConfigDir().getAbsolutePath();
    }

    public static String getSecurityDirPath() {
        return new File(Configuration.getConfigDirPath(), "security").getAbsolutePath();
    }

    static {
        jmxSystemProperties = new ArrayList<ConfigurationProperty>();
        try {
            agent = AgentShim.getAgent();
            logger = new Logger.LoggingHandler(MODULE, agent);
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError((String)"Error while getting Agent instance for ACC controller service configuration", (Throwable)e);
        }
    }
}

