/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.remotejmx;

import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.api.JmxPollingClientFactory;
import com.ca.apm.agent.jmxclient.api.SimpleJmxPollingClient;
import com.ca.apm.agent.remotejmx.CommonUtils;
import com.ca.apm.agent.remotejmx.Configuration;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.IDynamicService;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.io.ExtendedFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteJmxService
implements IDynamicService {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private IAgent fAgent = null;
    private volatile SimpleJmxPollingClient jmxClient;
    private static AtomicReference<RemoteJmxService> serviceRef = new AtomicReference();

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map parameters) {
        int fixPack;
        serviceRef.set(this);
        this.fAgent = agent;
        LOGGER.logInfoMessage("Starting Remote JMX Service");
        boolean jmxEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.remotejmx.enable", true);
        if (!jmxEnabled) {
            LOGGER.logWarningMessage("Remote JMX Service is disabled. introscope.agent.remotejmx.enable is set to false");
            return;
        }
        this.jmxClient = JmxPollingClientFactory.createSimpleClient();
        final ExtendedFile extensionDir = agent.IAgent_getExtensionAdministrator().getExtensionDirectoryFromServiceParameters(parameters);
        String delayInSeconds = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.remotejmx.delayInSeconds");
        if (delayInSeconds == null && (fixPack = this.findIbmFixPack()) >= 5 && fixPack <= 41) {
            LOGGER.logInfoMessage("Detected IBM fix pack: " + fixPack);
            delayInSeconds = "60";
        }
        if (delayInSeconds != null) {
            LOGGER.logInfoMessage("Remote JMX Service will be started in " + delayInSeconds + " seconds");
            this.fAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                public void ITimestampedRunnable_execute(long arg0) {
                    Configuration.init((RemoteJmxService)serviceRef.get(), extensionDir);
                    LOGGER.logInfoMessage("Remote JMX Service started successfully");
                }
            }, "JMX Delayed Starter", true, (long)(Integer.parseInt(delayInSeconds) * 1000), false, 1);
        } else {
            Configuration.init(this, extensionDir);
            LOGGER.logInfoMessage("Remote JMX Service started successfully");
        }
    }

    public void IAgentService_stopService(IAgent agent) {
        LOGGER.logInfoMessage("Stopping Remote JMX Service");
        if (this.jmxClient != null) {
            this.jmxClient.close();
        }
    }

    public IAgent getAgent() {
        return this.fAgent;
    }

    public SimpleJmxPollingClient getJmxClient() {
        return this.jmxClient;
    }

    public void updateJmxNodes(List<String> list) {
        Set<JmxNodeInfo> nodes = CommonUtils.fetchConnectionDetails(list);
        this.jmxClient.poll(nodes);
    }

    public static RemoteJmxService getInstance() {
        return serviceRef.get();
    }

    private int findIbmFixPack() {
        return this.findIbmFixPack(System.getProperty("java.vm.name", "none"), System.getProperty("java.runtime.version", "8.0.5.0"));
    }

    private int findIbmFixPack(String vmName, String runtime) {
        String ibmNameKey = "IBM J9";
        if (vmName.startsWith(ibmNameKey) || vmName.startsWith(ibmNameKey.toLowerCase())) {
            if (runtime.indexOf(45) != -1) {
                runtime = runtime.substring(0, runtime.indexOf(45));
            }
            if (runtime.startsWith("8.0.5.")) {
                return Integer.valueOf(runtime.substring(6).trim());
            }
        }
        return -1;
    }
}

