/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.zos;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ILongCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringConstantDataAccumulator;
import com.wily.powerpack.zos.LibraryLoader;
import com.wily.powerpack.zos.SystemInfo;
import com.wily.powerpack.zos.TimerDeltaCalculator;
import com.wily.util.heartbeat.ITimestampedRunnable;

public final class SystemInfoPoller
implements ITimestampedRunnable {
    private static final String PROCESS_NODE = "Process Overview";
    private static final String HEX_ASID_METRIC = "Process ASCB Id (Hex)";
    private IStringConstantDataAccumulator hexAsidMetric;
    private static final String JOB_NAME_METRIC = "Process Job Name";
    private IStringConstantDataAccumulator jobNameMetric;
    private static final String LSQA_PRIVATE_ABOVE_16MB_METRIC = "Process OS Memory Allocated above 16MB (kb) High water mark";
    private ILongFluctuatingCounterDataAccumulator lsqaPrivateAbove16MBMetric;
    private static final String LSQA_PRIVATE_BELOW_16MB_METRIC = "Process OS Memory Allocated below 16MB (kb) High water mark";
    private ILongFluctuatingCounterDataAccumulator lsqaPrivateBelow16MBMetric;
    private static final String SRB_PROCESSOR_TIME_METRIC = "Process SRB CPU Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator srbProcessorTimeMetric;
    private static final String SRB_PROCESSOR_TIME_DELTA_METRIC = "Process SRB CPU Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator srbProcessorTimeDeltaMetric;
    private static final String TCB_PROCESSOR_TIME_METRIC = "Process TCB CPU Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator tcbProcessorTimeMetric;
    private static final String TCB_PROCESSOR_TIME_DELTA_METRIC = "Process TCB CPU Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator tcbProcessorTimeDeltaMetric;
    private static final String TOTAL_PROCESSOR_TIME_METRIC = "Process Total CPU Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalProcessorTimeMetric;
    private static final String TOTAL_PROCESSOR_TIME_DELTA_METRIC = "Process Total CPU Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalProcessorTimeDeltaMetric;
    private static final String USER_PRIVATE_ABOVE_16MB_METRIC = "Process User Memory Allocated above 16MB (kb) High water mark";
    private ILongFluctuatingCounterDataAccumulator userPrivateAbove16MBMetric;
    private static final String USER_PRIVATE_BELOW_16MB_METRIC = "Process User Memory Allocated below 16MB (kb) High water mark";
    private ILongFluctuatingCounterDataAccumulator userPrivateBelow16MBMetric;
    private static final String TOTAL_ZAAP_TIME_METRIC = "Process zAAP Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalZaapTimeMetric;
    private static final String TOTAL_ZAAP_TIME_DELTA_METRIC = "Process zAAP Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalZaapTimeDeltaMetric;
    private static final String TOTAL_ZIIP_TIME_METRIC = "Process zIIP Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalZiipTimeMetric;
    private static final String TOTAL_ZIIP_TIME_DELTA_METRIC = "Process zIIP Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalZiipTimeDeltaMetric;
    private static final String SYSTEM_NODE = "System Overview";
    private static final String LPAR_NAME_METRIC = "LPAR Name";
    private IStringConstantDataAccumulator lparNameMetric;
    private static final String OS_NAME_METRIC = "Operating System";
    private IStringConstantDataAccumulator osNameMetric;
    private static final String OS_VERSION_METRIC = "Operating System Version Level";
    private IStringConstantDataAccumulator osVersionMetric;
    private static final String SYSID_METRIC = "Sys Id";
    private IStringConstantDataAccumulator sysidMetric;
    private static final String SYSPLEX_NAME_METRIC = "Sysplex Name";
    private IStringConstantDataAccumulator sysplexNameMetric;
    private static final String MIPS_METRIC = "System Approximate MIPs Capacity";
    private ILongFluctuatingCounterDataAccumulator mipsMetric;
    private static final String AVERAGE_CPU_USAGE_METRIC = "System Average CPU Utilization (%)";
    private ILongFluctuatingCounterDataAccumulator averageCpuUsageMetric;
    private static final String MSUS_METRIC = "System MSU Capacity";
    private ILongFluctuatingCounterDataAccumulator msusMetric;
    private static final String SYSTEM_NAME_METRIC = "System Name";
    private IStringConstantDataAccumulator systemNameMetric;
    private static final String CPUS_ONLINE_METRIC = "System Number of Active CPUs";
    private ILongFluctuatingCounterDataAccumulator cpusOnlineMetric;
    private static final String ZAAPS_ONLINE_METRIC = "System Number of Online zAAPs";
    private ILongFluctuatingCounterDataAccumulator zaapsOnlineMetric;
    private static final String ZIIPS_ONLINE_METRIC = "System Number of Online zIIPs";
    private ILongFluctuatingCounterDataAccumulator ziipsOnlineMetric;
    private static final String PAGING_RATE_METRIC = "System Paging Rate (pages/sec)";
    private ILongFluctuatingCounterDataAccumulator pagingRateMetric;
    private TimerDeltaCalculator calculator;

    public SystemInfoPoller(IAgent agent) {
        try {
            this.initializeMetrics(agent);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void initializeMetrics(IAgent agent) throws Exception {
        SystemInfo info = new SystemInfo();
        info.updateCurrentTaskInfo();
        this.calculator = new TimerDeltaCalculator();
        this.calculator.setFromInfo(info);
        DataAccumulatorFactory factory = agent.IAgent_getDataAccumulatorFactory();
        String mName = "Process Overview:Process ASCB Id (Hex)";
        this.hexAsidMetric = factory.safeGetStringConstantDataAccumulator(mName, info.getHexAsid());
        mName = "Process Overview:Process Job Name";
        this.jobNameMetric = factory.safeGetStringConstantDataAccumulator(mName, info.getJobName());
        mName = "Process Overview:Process OS Memory Allocated above 16MB (kb) High water mark";
        this.lsqaPrivateAbove16MBMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process OS Memory Allocated below 16MB (kb) High water mark";
        this.lsqaPrivateBelow16MBMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process SRB CPU Time Cumulative (usecs)";
        this.srbProcessorTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process SRB CPU Time Interval Delta (usecs)";
        this.srbProcessorTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process TCB CPU Time Cumulative (usecs)";
        this.tcbProcessorTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process TCB CPU Time Interval Delta (usecs)";
        this.tcbProcessorTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process Total CPU Time Cumulative (usecs)";
        this.totalProcessorTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process Total CPU Time Interval Delta (usecs)";
        this.totalProcessorTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process User Memory Allocated above 16MB (kb) High water mark";
        this.userPrivateAbove16MBMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process User Memory Allocated below 16MB (kb) High water mark";
        this.userPrivateBelow16MBMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process zAAP Time Cumulative (usecs)";
        this.totalZaapTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process zAAP Time Interval Delta (usecs)";
        this.totalZaapTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process zIIP Time Cumulative (usecs)";
        this.totalZiipTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "Process Overview:Process zIIP Time Interval Delta (usecs)";
        this.totalZiipTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "System Overview:LPAR Name";
        this.lparNameMetric = factory.safeGetStringConstantDataAccumulator(mName, info.getLparName());
        mName = "System Overview:Operating System";
        this.osNameMetric = factory.safeGetStringConstantDataAccumulator(mName, info.getOsName());
        mName = "System Overview:Operating System Version Level";
        this.osVersionMetric = factory.safeGetStringConstantDataAccumulator(mName, info.getOsVersion());
        mName = "System Overview:Sys Id";
        this.sysidMetric = factory.safeGetStringConstantDataAccumulator(mName, info.getSysid());
        mName = "System Overview:Sysplex Name";
        this.sysplexNameMetric = factory.safeGetStringConstantDataAccumulator(mName, info.getSysplexName());
        mName = "System Overview:System Approximate MIPs Capacity";
        this.mipsMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "System Overview:System Average CPU Utilization (%)";
        this.averageCpuUsageMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "System Overview:System MSU Capacity";
        this.msusMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "System Overview:System Name";
        this.systemNameMetric = factory.safeGetStringConstantDataAccumulator(mName, info.getSystemName());
        mName = "System Overview:System Number of Active CPUs";
        this.cpusOnlineMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "System Overview:System Number of Online zAAPs";
        this.zaapsOnlineMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "System Overview:System Number of Online zIIPs";
        this.ziipsOnlineMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
        mName = "System Overview:System Paging Rate (pages/sec)";
        this.pagingRateMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (!LibraryLoader.libraryLoaded()) {
            return;
        }
        try {
            SystemInfo info = new SystemInfo();
            info.updateCurrentTaskInfo();
            this.calculator.setFromInfo(info);
            this.recordLongValue((ILongCounterDataAccumulator)this.lsqaPrivateAbove16MBMetric, info.getLsqaPrivateAbove16MB());
            this.recordLongValue((ILongCounterDataAccumulator)this.lsqaPrivateBelow16MBMetric, info.getLsqaPrivateBelow16MB());
            this.recordLongValue((ILongCounterDataAccumulator)this.srbProcessorTimeDeltaMetric, this.calculator.getSrbProcessorTimeDelta());
            this.recordLongValue((ILongCounterDataAccumulator)this.srbProcessorTimeMetric, this.calculator.getSrbProcessorTime());
            this.recordLongValue((ILongCounterDataAccumulator)this.tcbProcessorTimeDeltaMetric, this.calculator.getTcbProcessorTimeDelta());
            this.recordLongValue((ILongCounterDataAccumulator)this.tcbProcessorTimeMetric, this.calculator.getTcbProcessorTime());
            this.recordLongValue((ILongCounterDataAccumulator)this.totalProcessorTimeDeltaMetric, this.calculator.getTotalProcessorTimeDelta());
            this.recordLongValue((ILongCounterDataAccumulator)this.totalProcessorTimeMetric, this.calculator.getTotalProcessorTime());
            this.recordLongValue((ILongCounterDataAccumulator)this.totalZaapTimeDeltaMetric, this.calculator.getTotalZaapTimeDelta());
            this.recordLongValue((ILongCounterDataAccumulator)this.totalZaapTimeMetric, this.calculator.getTotalZaapTime());
            this.recordLongValue((ILongCounterDataAccumulator)this.userPrivateAbove16MBMetric, info.getUserPrivateAbove16MB());
            this.recordLongValue((ILongCounterDataAccumulator)this.userPrivateBelow16MBMetric, info.getUserPrivateBelow16MB());
            this.recordLongValue((ILongCounterDataAccumulator)this.totalZiipTimeDeltaMetric, this.calculator.getTotalZiipTimeDelta());
            this.recordLongValue((ILongCounterDataAccumulator)this.totalZiipTimeMetric, this.calculator.getTotalZiipTime());
            this.recordLongValue((ILongCounterDataAccumulator)this.mipsMetric, info.getMips());
            this.recordLongValue((ILongCounterDataAccumulator)this.averageCpuUsageMetric, info.getAverageCpuUsage());
            this.recordLongValue((ILongCounterDataAccumulator)this.msusMetric, info.getMsus());
            this.recordLongValue((ILongCounterDataAccumulator)this.cpusOnlineMetric, info.getCpusOnline());
            this.recordLongValue((ILongCounterDataAccumulator)this.zaapsOnlineMetric, info.getZaapsOnline());
            this.recordLongValue((ILongCounterDataAccumulator)this.ziipsOnlineMetric, info.getZiipsOnline());
            this.recordLongValue((ILongCounterDataAccumulator)this.pagingRateMetric, info.getPagingRate());
            this.calculator.rememberValuesForNextPass();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    void recordLongValue(ILongCounterDataAccumulator metric, long value) {
        if (!metric.IDataAccumulator_isShutOff()) {
            metric.ILongCounterDataAccumulator_setValue(value);
        }
    }
}

