/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.backend.IFeedbackBackend;
import com.wily.wilyassert.Assertion;

public class AnyBackendFeedbackChannel
implements IModuleFeedbackChannel {
    protected IFeedbackBackend fBackend;
    private String fApplicationName;
    private Module fModule;
    private String fCategory;
    private String fDynamicModule;
    private Object fLogger;
    private final Lock fLock = new Lock();

    public AnyBackendFeedbackChannel(IFeedbackBackend backend, String applicationName) {
        this.fBackend = backend;
        this.initializeChannel(applicationName, null);
        this.calculateLogger();
    }

    public AnyBackendFeedbackChannel(IFeedbackBackend backend, String applicationName, String moduleName) {
        this.fBackend = backend;
        this.initializeChannel(applicationName, moduleName);
        this.calculateLogger();
    }

    public AnyBackendFeedbackChannel(IFeedbackBackend backend, IModuleFeedbackChannel original, String moduleName) {
        this.fBackend = backend;
        this.initializeChannel(original.getApplicationName(), moduleName);
        this.calculateLogger();
    }

    private void initializeChannel(String applicationName, String moduleName) {
        this.setApplicationName(applicationName);
        this.setModuleName(moduleName);
    }

    public void setApplicationName(String applicationName) {
        Assertion.wilyAssert(false);
        this.fApplicationName = applicationName;
    }

    private void setModuleName(String moduleName) {
        this.fDynamicModule = moduleName;
    }

    @Override
    public SeverityLevel getEffectiveLevel(Module module) {
        Object actualLogger = this.getActualLogger(module);
        return this.fBackend.getEffectiveLevel(actualLogger);
    }

    @Override
    public SeverityLevel getLevel(Module module) {
        Object actualLogger = this.getActualLogger(module);
        return this.fBackend.getLevel(actualLogger);
    }

    @Override
    public void setLevel(SeverityLevel level, Module module) {
        Object actualLogger = this.getActualLogger(module);
        this.fBackend.setLevel(actualLogger, level);
    }

    protected final Object getFeedbackChannelLock() {
        return this.fLock;
    }

    private void calculateLogger() {
        String category = this.getCategory();
        Assertion.wilyAssert(false);
        if (category != null) {
            this.fModule = this.fDynamicModule != null ? new Module(this.fDynamicModule) : new Module(category);
            this.fLogger = this.fBackend.getLoggerByName(category);
        } else {
            this.fLogger = this.fBackend.getLoggerByName("default");
        }
    }

    private String getCategory() {
        if (this.fCategory == null) {
            String category = this.getApplicationName();
            String module = this.getModuleName();
            this.fCategory = module != null ? (category != null ? (category.equals(module) ? category : String.valueOf(category) + "." + module) : module) : category;
            if (this.fCategory != null) {
                this.fCategory = StringUtils.replace(this.fCategory, " ", "");
            }
        }
        return this.fCategory;
    }

    protected Object getActualLogger(Module module) {
        Object logger = null;
        if (this.getModuleName() != null) {
            logger = this.fLogger;
        } else {
            String fullname = null;
            fullname = this.getCategory().equals(module.getName()) ? module.getName() : String.valueOf(this.getCategory()) + "." + module.getName();
            logger = this.fBackend.getLoggerByName(fullname);
        }
        return logger;
    }

    @Override
    public final String getApplicationName() {
        return this.fApplicationName;
    }

    @Override
    public final String getModuleName() {
        return this.fDynamicModule;
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.isLogEnabled(SeverityLevel.VERBOSE, this.fModule);
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.isLogEnabled(SeverityLevel.DEBUG, this.fModule);
    }

    @Override
    public final boolean isTraceEnabled() {
        return this.isLogEnabled(SeverityLevel.TRACE, this.fModule);
    }

    public SeverityLevel getLevel() {
        return this.fBackend.getLevel(this.fLogger);
    }

    public void setLevel(SeverityLevel level) {
        this.fBackend.setLevel(this.fLogger, level);
    }

    @Override
    public final boolean isErrorEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.ERROR, module);
    }

    @Override
    public final boolean isWarningEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.WARN, module);
    }

    @Override
    public final boolean isInfoEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.INFO, module);
    }

    @Override
    public final boolean isVerboseEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.VERBOSE, module);
    }

    @Override
    public final boolean isDebugEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.DEBUG, module);
    }

    @Override
    public final boolean isTraceEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.TRACE, module);
    }

    @Override
    public boolean isLogEnabled(SeverityLevel severity, Module module) {
        Object actualLogger = this.getActualLogger(module);
        return this.fBackend.isEnabledFor(actualLogger, severity);
    }

    @Override
    public final void error(String message) {
        this.log(SeverityLevel.ERROR, this.fModule, message);
    }

    @Override
    public final void error(String message, Throwable t) {
        this.log(SeverityLevel.ERROR, this.fModule, message, t);
    }

    @Override
    public final void warn(String message) {
        this.log(SeverityLevel.WARN, this.fModule, message);
    }

    @Override
    public final void warn(String message, Throwable t) {
        this.log(SeverityLevel.WARN, this.fModule, message, t);
    }

    @Override
    public final void info(String message) {
        this.log(SeverityLevel.INFO, this.fModule, message);
    }

    @Override
    public final void info(String message, Throwable t) {
        this.log(SeverityLevel.INFO, this.fModule, message, t);
    }

    @Override
    public final void verbose(String message) {
        this.log(SeverityLevel.VERBOSE, this.fModule, message);
    }

    @Override
    public final void verbose(String message, Throwable t) {
        this.log(SeverityLevel.VERBOSE, this.fModule, message, t);
    }

    @Override
    public final void debug(String message) {
        this.log(SeverityLevel.DEBUG, this.fModule, message);
    }

    @Override
    public final void debug(String message, Throwable t) {
        this.log(SeverityLevel.DEBUG, this.fModule, message, t);
    }

    @Override
    public final void log(SeverityLevel severity, String message) {
        this.log(severity, this.fModule, message);
    }

    @Override
    public final void log(SeverityLevel severity, String message, Throwable t) {
        this.log(severity, this.fModule, message, t);
    }

    @Override
    public final void error(Throwable t) {
        this.log(SeverityLevel.ERROR, this.fModule, null, t);
    }

    @Override
    public final void verbose(Throwable t) {
        this.log(SeverityLevel.VERBOSE, this.fModule, null, t);
    }

    @Override
    public final void debug(Throwable t) {
        this.log(SeverityLevel.DEBUG, this.fModule, null, t);
    }

    @Override
    public final void error(Module module, String message) {
        this.log(SeverityLevel.ERROR, module, message);
    }

    @Override
    public final void error(Module module, String message, Throwable t) {
        this.log(SeverityLevel.ERROR, module, message, t);
    }

    @Override
    public final void warn(Module module, String message) {
        this.log(SeverityLevel.WARN, module, message);
    }

    @Override
    public final void warn(Module module, String message, Throwable t) {
        this.log(SeverityLevel.WARN, module, message, t);
    }

    @Override
    public final void info(Module module, String message) {
        this.log(SeverityLevel.INFO, module, message);
    }

    @Override
    public final void info(Module module, String message, Throwable t) {
        this.log(SeverityLevel.INFO, module, message, t);
    }

    @Override
    public final void verbose(Module module, String message) {
        this.log(SeverityLevel.VERBOSE, module, message);
    }

    @Override
    public final void verbose(Module module, String message, Throwable t) {
        this.log(SeverityLevel.VERBOSE, module, message, t);
    }

    @Override
    public final void debug(Module module, String message) {
        this.log(SeverityLevel.DEBUG, module, message);
    }

    @Override
    public final void debug(Module module, String message, Throwable t) {
        this.log(SeverityLevel.DEBUG, module, message, t);
    }

    @Override
    public final void trace(String message) {
        this.log(SeverityLevel.TRACE, this.fModule, message);
    }

    @Override
    public final void trace(Module module, String message) {
        this.log(SeverityLevel.TRACE, module, message);
    }

    @Override
    public final void trace(Module module, String message, Throwable t) {
        this.log(SeverityLevel.TRACE, module, message, t);
    }

    @Override
    public final void log(SeverityLevel severity, Module module, String message) {
        this.log(severity, module, message, null);
    }

    @Override
    public final void log(SeverityLevel severity, Module module, String message, Throwable t) {
        this.logbottleneck(severity, module, message, t);
    }

    @Override
    public final void logImmediate(SeverityLevel severity, Module module, String message) {
        this.logImmediate(severity, module, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void logImmediate(SeverityLevel severity, Module module, String message, Throwable t) {
        if (this.isLogEnabled(severity, module)) {
            Object object = this.getFeedbackChannelLock();
            synchronized (object) {
                this.doLog(severity, module, message, t, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logbottleneck(SeverityLevel severity, Module module, String message, Throwable t) {
        if (this.isLogEnabled(severity, module)) {
            Object object = this.getFeedbackChannelLock();
            synchronized (object) {
                this.doLog(severity, module, message, t, false);
            }
        }
    }

    protected void doLog(SeverityLevel severity, Module module, String message, Throwable t, boolean forceImmediate) {
        if (message == null) {
            message = "\n";
        }
        Object actualLogger = this.getActualLogger(module);
        this.fBackend.log(actualLogger, severity, message, t);
    }

    public final String debug_getLog4JCategory() {
        return this.fBackend.getName(this.fLogger);
    }

    private static class Lock {
        private Lock() {
        }
    }
}

