/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.SocketConcurrentInvocationCounter;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.io.InputStream;

public class SocketConcurrentReaderCounter
extends SocketConcurrentInvocationCounter {
    public SocketConcurrentReaderCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected final int getMetricPosition() {
        return 5;
    }

    @Override
    protected void decreaseCacheQuantity(SocketFormatMetricsCache cache) {
        cache.removeFromConcurrentReaders();
    }

    @Override
    protected void increaseCacheQuantity(SocketFormatMetricsCache cache) {
        cache.addToConcurrentReaders();
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketRequired()) {
            Object invocationObject = data.getInvocationObject();
            if (invocationObject instanceof InputStream) {
                SocketFormatMetricsCache cache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
                if (cache.getAccumulators(5) == null) {
                    this.getAccumulator(data);
                }
                return this;
            }
            Assertion.wilyAssert("Instrumentation error: invocation object not an InputStream");
        }
        return null;
    }
}

