/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.callback;

import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.callback.Callback;
import com.wily.isengard.messageprimitives.callback.ICallback;
import com.wily.isengard.messageprimitives.callback.ICallbackConnectorCloseNotification;
import com.wily.isengard.messageprimitives.pipe.AAsyncMessagePipeEndpoint;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.messageprimitives.pipe.IMessagePipeData;
import com.wily.isengard.messageprimitives.pipe.IMessagePipeNotification;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.exception.UnexpectedExceptionError;

public class CallbackConnector<T extends ICallback>
implements IMessagePipeData,
IMessagePipeNotification {
    private AAsyncMessagePipeEndpoint<T> fEndpoint;
    private boolean fIsClosed;
    private final ICallbackConnectorCloseNotification fNotification;
    private final T fConnector;
    private final Callback<T> fCallback;

    public CallbackConnector(PostOffice po, Callback<T> remoteCallback, Class<T> callbackClass) throws EndpointNotFoundException {
        this(po, remoteCallback, callbackClass, null);
    }

    public CallbackConnector(PostOffice po, Callback<T> remoteCallback, Class<T> callbackClass, ICallbackConnectorCloseNotification closeNotification) throws EndpointNotFoundException {
        this.fNotification = closeNotification;
        this.fIsClosed = false;
        this.fCallback = remoteCallback;
        if (remoteCallback == null) {
            throw new EndpointNotFoundException();
        }
        Address addr = remoteCallback.getRemotePipeAddress();
        if (addr == null) {
            this.fConnector = remoteCallback.getHandler();
            remoteCallback.setCallbackConnector(this);
        } else {
            try {
                this.fEndpoint = new AAsyncMessagePipeEndpoint<T>(po, callbackClass, this);
            }
            catch (InvalidIsengardInterface e) {
                throw new UnexpectedExceptionError(e);
            }
            this.fConnector = (ICallback)this.fEndpoint.getPublisher();
            this.fEndpoint.connectToPipeEndpoint(addr);
        }
    }

    public T getInterface() {
        return this.fConnector;
    }

    public synchronized boolean isClosed() {
        return this.fIsClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CallbackConnector callbackConnector = this;
        synchronized (callbackConnector) {
            if (this.fIsClosed) {
                return;
            }
            this.fIsClosed = true;
        }
        if (this.fEndpoint != null) {
            this.fEndpoint.close();
            this.fEndpoint = null;
        }
        this.fCallback.connectorClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closing() {
        CallbackConnector callbackConnector = this;
        synchronized (callbackConnector) {
            if (this.fIsClosed) {
                return;
            }
            this.fIsClosed = true;
        }
        if (this.fEndpoint != null) {
            this.fEndpoint.close();
            this.fEndpoint = null;
        }
        if (this.fNotification != null) {
            this.fNotification.closing(this);
        }
    }

    @Override
    public void pipeClosed() {
        this.closing();
    }

    public void clientClosing() {
        this.closing();
    }
}

