/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.event.IEventNoticer;
import com.wily.introscope.agent.leakhunter.BadCollectionFilter;
import com.wily.introscope.agent.leakhunter.ITrackedLeakReference;
import com.wily.introscope.agent.leakhunter.ITrackedLeakReferenceCreator;
import com.wily.introscope.agent.leakhunter.LeakHunterController;
import com.wily.introscope.agent.leakhunter.PotentialLeakTracker;
import com.wily.introscope.agent.leakhunter.TrackedCollectionReference;
import com.wily.introscope.agent.leakhunter.TrackedMapReference;
import com.wily.util.IConfigurationListener;
import com.wily.util.properties.IndexedProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ALeakHunterEventNoticer
implements IEventNoticer,
ITrackedLeakReferenceCreator {
    private final LeakHunterController fController;
    private BadCollectionFilter fFilter;
    private IAgent fAgent;
    private String[] fIgnoreCollectionArray = new String[0];
    private static volatile boolean sEventNoticerInitialized = false;
    private static IConfigurationListener sListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ALeakHunterEventNoticer(IAgent agent) {
        this.fAgent = agent;
        this.fController = LeakHunterController.getController(agent);
        this.fFilter = this.fController.getLeakHunterSettings().getBadCollectionFilter();
        this.fIgnoreCollectionArray = agent.IAgent_getIndexedProperties().getAndCondenseAllTrimmedIndexedProperties("introscope.agent.leakhunter.ignore");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!sEventNoticerInitialized) {
                this.initializeListener();
                sEventNoticerInitialized = true;
            }
        }
    }

    public void initializeListener() {
        sListener = new IConfigurationListener(){

            public void onChange(IndexedProperties props) {
                Object[] oldPropArray;
                boolean areEqual;
                Object[] newPropArray = props.getAndCondenseAllTrimmedIndexedProperties("introscope.agent.leakhunter.ignore");
                if (newPropArray == null) {
                    newPropArray = new String[]{};
                }
                if (!(areEqual = Arrays.equals(newPropArray, oldPropArray = ALeakHunterEventNoticer.this.fIgnoreCollectionArray))) {
                    ALeakHunterEventNoticer.this.fFilter = new BadCollectionFilter((String[])newPropArray);
                    ALeakHunterEventNoticer.this.fAgent.IAgent_getModuleFeedback().info("Leakhunter ignore collection list has been updated");
                    ALeakHunterEventNoticer.access$002(ALeakHunterEventNoticer.this, (String[])newPropArray);
                }
            }
        };
        this.fAgent.addConfigurationListener(sListener);
    }

    protected boolean shouldTrackNewReferences() {
        return this.fController.shouldTrackNewReferences();
    }

    protected ITrackedLeakReference findExistingLeakReference(Object objectReference) {
        if (this.fController.isEnabled()) {
            PotentialLeakTracker tracker = this.fController.getPotentialLeakTracker();
            return tracker.findLeakReference(objectReference);
        }
        return null;
    }

    protected ITrackedLeakReference findLeakReference(Object objectReference) {
        if (this.fController.isEnabled()) {
            PotentialLeakTracker tracker = this.fController.getPotentialLeakTracker();
            return tracker.createIfNecessary(objectReference, this);
        }
        return null;
    }

    @Override
    public final ITrackedLeakReference createReference(Object trackedObject) {
        if (!this.fFilter.isOK(trackedObject.getClass().getName())) {
            return null;
        }
        if (trackedObject instanceof Collection) {
            return new TrackedCollectionReference();
        }
        if (trackedObject instanceof Map && !(trackedObject instanceof WeakHashMap)) {
            return new TrackedMapReference();
        }
        return null;
    }

    static /* synthetic */ String[] access$002(ALeakHunterEventNoticer x0, String[] x1) {
        x0.fIgnoreCollectionArray = x1;
        return x1;
    }
}

