/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.leakhunter.AllocationStackTrace;
import com.wily.introscope.agent.leakhunter.FieldRecord;
import com.wily.introscope.agent.leakhunter.IPotentialLeakDetector;
import com.wily.introscope.agent.leakhunter.ITrackedLeakReference;
import com.wily.introscope.agent.leakhunter.LeakHunterController;
import com.wily.introscope.agent.leakhunter.LeakHunterLogFile;
import com.wily.introscope.agent.leakhunter.LeakHunterSettings;
import com.wily.introscope.agent.leakhunter.NNewHighsPotentialLeakDetector;
import com.wily.introscope.agent.leakhunter.PotentialLeakIDFactory;
import com.wily.introscope.agent.leakhunter.PotentialLeakMetrics;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.NativeClassSchemaPolicy;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;

public abstract class ATrackedLeakReference
implements ITrackedLeakReference {
    private static final int kInitialAssignedFieldAllocationSize = 3;
    private static final String kPersistentIdentifierSeparator = "-";
    private static final String kUnknownName = "<unknown>";
    public static final String kClassAndMethodSeparator = ".";
    private static LeakHunterController sController;
    private WeakReference fTrackedObjectReference;
    private final IPotentialLeakDetector fLeakDetector;
    private String[] fAssignedFields;
    private String fAllocationClassName;
    private String fAllocationMethodName;
    private String fAllocationMethodDescriptor;
    private long fAllocationTimestamp;
    private AllocationStackTrace fAllocationStackTrace;
    private PotentialLeakAddendum fPotentialLeakAddendum;

    protected ATrackedLeakReference() {
        Assertion.wilyAssert((boolean)false);
        this.fTrackedObjectReference = null;
        this.fLeakDetector = this.createLeakDetector();
        this.fAssignedFields = null;
        this.fAllocationClassName = null;
        this.fAllocationMethodName = null;
        this.fAllocationMethodDescriptor = null;
        this.fAllocationTimestamp = -1L;
        this.fAllocationStackTrace = null;
        this.fPotentialLeakAddendum = null;
    }

    public static void setController(LeakHunterController controller) {
        sController = controller;
    }

    private static LeakHunterController getController() {
        return sController;
    }

    public final IModuleFeedbackChannel getModuleFeedback() {
        return this.getLeakHunterSettings().getModuleFeedback();
    }

    public final IStringLocalizer getStringLocalizer() {
        return this.getLeakHunterSettings().getStringLocalizer();
    }

    @Override
    public final void ITrackedLeakReference_setReference(WeakReference reference) {
        this.fTrackedObjectReference = reference;
    }

    @Override
    public final WeakReference ITrackedLeakReference_getReference() {
        return this.fTrackedObjectReference;
    }

    @Override
    public final synchronized void ITrackedLeakReference_noticeObjectCreation(String allocationClass, String allocationMethod, String allocationDescriptor) {
        this.fAllocationClassName = allocationClass;
        this.fAllocationMethodName = allocationMethod;
        this.fAllocationMethodDescriptor = allocationDescriptor;
        this.fAllocationTimestamp = System.currentTimeMillis();
        if (this.getLeakHunterSettings().collectAllocationStackTraces()) {
            this.fAllocationStackTrace = new AllocationStackTrace();
        }
    }

    @Override
    public final synchronized void ITrackedLeakReference_noticeFieldAssignment(String fieldClass, String fieldName) {
        this.addFieldAssignment(FieldRecord.create(fieldClass, fieldName));
    }

    @Override
    public final boolean ITrackedLeakReference_isValidReference() {
        return this.fTrackedObjectReference.get() != null;
    }

    @Override
    public final boolean ITrackedLeakReference_isPotentialLeak() {
        return this.isPotentialLeak();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void ITrackedLeakReference_checkForLeak(long nowInMillis) {
        Object trackedObject;
        ATrackedLeakReference aTrackedLeakReference = this;
        synchronized (aTrackedLeakReference) {
            trackedObject = this.fTrackedObjectReference.get();
        }
        if (trackedObject != null) {
            int size = 0;
            try {
                size = this.getTrackedObjectSize(trackedObject);
            }
            catch (ConcurrentModificationException cce) {
                ATrackedLeakReference.getController().getAgent().IAgent_getModuleFeedback().debug("ConcurrentModificationException while calling size(), will skip current class on this pass", (Throwable)cce);
                return;
            }
            catch (NullPointerException npe) {
                ATrackedLeakReference.getController().getAgent().IAgent_getModuleFeedback().debug("NullPointerException while calling size(), will skip current class on this pass", (Throwable)npe);
                return;
            }
            ATrackedLeakReference aTrackedLeakReference2 = this;
            synchronized (aTrackedLeakReference2) {
                boolean hasLeak = this.fLeakDetector.IPotentialLeakDetector_hasLeak(nowInMillis, size, trackedObject);
                if (this.isPotentialLeak()) {
                    if (this.fPotentialLeakAddendum.fIsCurrentLeak && !hasLeak) {
                        this.getLeakHunterLogFile().logNoLongerLeaking(this.getPotentialLeakID(), this.getTrackedObjectClassName(), size);
                    } else if (!this.fPotentialLeakAddendum.fIsCurrentLeak && hasLeak) {
                        this.getLeakHunterLogFile().logLeakingAgain(this.getPotentialLeakID(), this.getTrackedObjectClassName(), size);
                    }
                    this.fPotentialLeakAddendum.fPotentialLeakMetrics.updateValues(size, hasLeak);
                    this.fPotentialLeakAddendum.fIsCurrentLeak = hasLeak;
                } else if (hasLeak) {
                    this.setAsPotentialLeak(size, hasLeak, trackedObject);
                }
            }
        }
    }

    @Override
    public final void ITrackedLeakReference_tearDown() {
        this.fTrackedObjectReference.clear();
        this.tearDown();
    }

    protected IPotentialLeakDetector createLeakDetector() {
        return new NNewHighsPotentialLeakDetector(this.getLeakHunterSettings());
    }

    private void tearDown() {
        if (this.isPotentialLeak()) {
            this.fPotentialLeakAddendum.fPotentialLeakMetrics.tearDown();
        }
    }

    private void setAsPotentialLeak(int size, boolean hasLeak, Object trackedObject) {
        if (this.fPotentialLeakAddendum == null) {
            this.fPotentialLeakAddendum = new PotentialLeakAddendum();
        }
        this.fPotentialLeakAddendum.fPotentialLeakID = this.calculatePotentialLeakID();
        this.fPotentialLeakAddendum.fTrackedObjectClassName = this.calculateTrackedObjectClassName(trackedObject);
        this.fPotentialLeakAddendum.fIsCurrentLeak = hasLeak;
        this.fPotentialLeakAddendum.fPotentialLeakMetrics = new PotentialLeakMetrics(ATrackedLeakReference.getController().getAgent(), this.getPotentialLeakID(), this.getTrackedObjectClassName(), this.getFullyQualifiedFormattedAllocationMethod(), this.getAllocationTimestamp(), this.getAllocationStackTraceAsString(), this.getAssignedFields(), size, hasLeak);
        this.getLeakHunterLogFile().logNewPotentialLeak(this.getPotentialLeakID(), this.getTrackedObjectClassName(), this.getFullyQualifiedFormattedAllocationMethod(), this.getAllocationTimestamp(), this.getAllocationStackTraceAsString(), this.getAssignedFields(), size);
    }

    private boolean isPotentialLeak() {
        return this.fPotentialLeakAddendum != null;
    }

    private String calculatePotentialLeakID() {
        String field;
        String name = kUnknownName;
        int hashCode = 0;
        if (this.hasAllocationData()) {
            name = this.getAllocationMethodName();
            hashCode = this.getAllocationClassName().hashCode();
        } else if (this.getAssignedFields().length > 0 && (field = this.getAssignedFields()[0]) != null) {
            name = FieldRecord.getFieldName(field);
            hashCode = FieldRecord.getFieldClassName(field).hashCode();
        }
        String persistentIdentifier = this.buildPersistentIdentifier(name, hashCode);
        return this.getPotentialLeakIDFactory().generateUniqueID(persistentIdentifier);
    }

    private String buildPersistentIdentifier(String method, int hashCode) {
        String hashCodeString = String.valueOf(Math.abs(hashCode % 10000) + 10000).substring(1);
        return method + kPersistentIdentifierSeparator + hashCodeString;
    }

    protected String getPotentialLeakID() {
        if (this.fPotentialLeakAddendum != null) {
            return this.fPotentialLeakAddendum.fPotentialLeakID;
        }
        return null;
    }

    private String calculateTrackedObjectClassName(Object trackedObject) {
        return trackedObject.getClass().getName();
    }

    private String getTrackedObjectClassName() {
        if (this.fPotentialLeakAddendum != null) {
            return this.fPotentialLeakAddendum.fTrackedObjectClassName;
        }
        return null;
    }

    private String getFullyQualifiedFormattedAllocationMethod() {
        if (!this.hasAllocationData()) {
            return null;
        }
        String returnString = null;
        try {
            IMethodSignature md = NativeClassSchemaPolicy.getNativeClassSchemaPolicy().getMethodSignature(this.getAllocationMethodDescriptor());
            returnString = this.getAllocationClassName() + kClassAndMethodSeparator + this.getAllocationMethodName() + md.getSignatureString();
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e.getMessage());
            this.getModuleFeedback().verbose((Throwable)e);
        }
        return returnString;
    }

    private boolean hasAllocationData() {
        return this.getAllocationMethodName() != null;
    }

    private String getAllocationClassName() {
        return this.fAllocationClassName;
    }

    private String getAllocationMethodName() {
        return this.fAllocationMethodName;
    }

    private String getAllocationMethodDescriptor() {
        return this.fAllocationMethodDescriptor;
    }

    private long getAllocationTimestamp() {
        return this.fAllocationTimestamp;
    }

    private String getAllocationStackTraceAsString() {
        if (this.fAllocationStackTrace != null) {
            return this.fAllocationStackTrace.getStackTraceAsString();
        }
        return null;
    }

    private String[] getAssignedFields() {
        if (this.fAssignedFields != null) {
            return this.fAssignedFields;
        }
        return FieldRecord.kZeroLengthAssignedFields;
    }

    private LeakHunterSettings getLeakHunterSettings() {
        return ATrackedLeakReference.getController().getLeakHunterSettings();
    }

    private LeakHunterLogFile getLeakHunterLogFile() {
        return ATrackedLeakReference.getController().getLeakHunterLogFile();
    }

    protected PotentialLeakIDFactory getPotentialLeakIDFactory() {
        return ATrackedLeakReference.getController().getPotentialLeakIDFactory();
    }

    protected abstract int getTrackedObjectSize(Object var1);

    private void addFieldAssignment(String field) {
        if (!this.containsAssignedField(field)) {
            this.addAssignedField(field);
            if (this.isPotentialLeak()) {
                this.fPotentialLeakAddendum.fPotentialLeakMetrics.addAssignedField(field);
            }
        }
    }

    public boolean containsAssignedField(String field) {
        if (this.fAssignedFields == null) {
            return false;
        }
        for (int fieldII = 0; fieldII < this.fAssignedFields.length && this.fAssignedFields[fieldII] != null; ++fieldII) {
            if (!field.equals(this.fAssignedFields[fieldII])) continue;
            return true;
        }
        return false;
    }

    public void addAssignedField(String field) {
        if (this.fAssignedFields == null) {
            this.fAssignedFields = new String[3];
            this.fAssignedFields[0] = field;
        } else {
            int currentSize = this.sizeAssignedFields();
            if (currentSize >= this.fAssignedFields.length) {
                int newSize = this.fAssignedFields.length * 2;
                String[] newAssignedFieldsArray = new String[newSize];
                System.arraycopy(this.fAssignedFields, 0, newAssignedFieldsArray, 0, this.fAssignedFields.length);
                this.fAssignedFields = newAssignedFieldsArray;
            }
            for (int fieldII = currentSize; fieldII > 0 && this.fAssignedFields[fieldII - 1].compareTo(field) > 0; --fieldII) {
                this.fAssignedFields[fieldII] = this.fAssignedFields[fieldII - 1];
            }
            this.fAssignedFields[fieldII] = field;
        }
    }

    public int sizeAssignedFields() {
        int size = 0;
        if (this.fAssignedFields != null) {
            for (int fieldII = 0; fieldII < this.fAssignedFields.length && this.fAssignedFields[fieldII] != null; ++fieldII) {
                ++size;
            }
        }
        return size;
    }

    private static final class PotentialLeakAddendum {
        public String fTrackedObjectClassName;
        public String fPotentialLeakID;
        public PotentialLeakMetrics fPotentialLeakMetrics;
        public boolean fIsCurrentLeak;

        private PotentialLeakAddendum() {
        }
    }
}

