/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.api.DataRecorderFactory;
import com.wily.introscope.agent.api.IllegalMetricNameException;
import com.wily.introscope.agent.api.IntCounterDataRecorder;
import com.wily.introscope.agent.api.IntRateDataRecorder;
import com.wily.introscope.agent.leakhunter.ITrackedLeakReference;
import com.wily.introscope.agent.leakhunter.LeakHunterSettings;
import com.wily.wilyassert.Assertion;

final class LeakHunterMetrics {
    private final boolean fEnabled;
    private LeakHunterSettings fSettings;
    private int fTrackedLeakCountCurrentValue = 0;
    private int fPotentialLeakCountCurrentValue = 0;

    LeakHunterMetrics(LeakHunterSettings settings) {
        this.fSettings = settings;
        this.fEnabled = this.fSettings.isEnabled();
        if (this.fEnabled) {
            try {
                this.getTrackedLeakCountDataRecorder().recordCurrentValue(this.fTrackedLeakCountCurrentValue);
                this.getPotentialLeakCountDataRecorder().recordCurrentValue(this.fPotentialLeakCountCurrentValue);
            }
            catch (IllegalMetricNameException imne) {
                settings.getModuleFeedback().error("Error creating LeakHunter metrics", (Throwable)imne);
                Assertion.wilyFail();
            }
        }
    }

    private IntCounterDataRecorder getTrackedLeakCountDataRecorder() throws IllegalMetricNameException {
        return DataRecorderFactory.createIntCounterDataRecorder((String)"LeakHunter:Tracked Collection Count");
    }

    private IntCounterDataRecorder getPotentialLeakCountDataRecorder() throws IllegalMetricNameException {
        return DataRecorderFactory.createIntCounterDataRecorder((String)"LeakHunter:Potential Leak Count");
    }

    public IntRateDataRecorder getTrackedLeakAllocationRateDataRecorder() throws IllegalMetricNameException {
        return DataRecorderFactory.createIntRateDataRecorder((String)"LeakHunter:Tracked Collection Allocate Rate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeTrackedLeakCountValue(boolean shdIncrease) {
        LeakHunterMetrics leakHunterMetrics = this;
        synchronized (leakHunterMetrics) {
            this.fTrackedLeakCountCurrentValue = shdIncrease ? ++this.fTrackedLeakCountCurrentValue : --this.fTrackedLeakCountCurrentValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePotentialLeakCountValue(boolean shdIncrease) {
        LeakHunterMetrics leakHunterMetrics = this;
        synchronized (leakHunterMetrics) {
            this.fPotentialLeakCountCurrentValue = shdIncrease ? ++this.fPotentialLeakCountCurrentValue : --this.fPotentialLeakCountCurrentValue;
        }
    }

    public void addTrackedLeakReference(ITrackedLeakReference reference) {
        if (this.fEnabled) {
            try {
                this.changeTrackedLeakCountValue(true);
                this.getTrackedLeakCountDataRecorder().recordCurrentValue(this.fTrackedLeakCountCurrentValue);
                if (reference.ITrackedLeakReference_isPotentialLeak()) {
                    this.changePotentialLeakCountValue(true);
                    this.getPotentialLeakCountDataRecorder().recordCurrentValue(this.fPotentialLeakCountCurrentValue);
                }
                this.getTrackedLeakAllocationRateDataRecorder().recordIncident();
            }
            catch (IllegalMetricNameException imne) {
                this.fSettings.getModuleFeedback().error("Error creating LeakHunter metrics", (Throwable)imne);
                Assertion.wilyFail();
            }
        }
    }

    public void removeTrackedLeakReference(ITrackedLeakReference reference) {
        if (this.fEnabled) {
            try {
                this.changeTrackedLeakCountValue(false);
                this.getTrackedLeakCountDataRecorder().recordCurrentValue(this.fTrackedLeakCountCurrentValue);
                if (reference.ITrackedLeakReference_isPotentialLeak()) {
                    this.changePotentialLeakCountValue(false);
                    this.getPotentialLeakCountDataRecorder().recordCurrentValue(this.fPotentialLeakCountCurrentValue);
                }
            }
            catch (IllegalMetricNameException imne) {
                this.fSettings.getModuleFeedback().error("Error creating LeakHunter metrics", (Throwable)imne);
                Assertion.wilyFail();
            }
        }
    }

    public void addPotentialLeak(ITrackedLeakReference reference) {
        try {
            if (this.fEnabled) {
                this.changePotentialLeakCountValue(true);
                this.getPotentialLeakCountDataRecorder().recordCurrentValue(this.fPotentialLeakCountCurrentValue);
            }
        }
        catch (IllegalMetricNameException imne) {
            this.fSettings.getModuleFeedback().error("Error creating LeakHunter metrics", (Throwable)imne);
            Assertion.wilyFail();
        }
    }

    public synchronized void setTrackedLeakReferenceCount(int count) {
        if (this.fEnabled) {
            try {
                this.fTrackedLeakCountCurrentValue = count;
                this.getTrackedLeakCountDataRecorder().recordCurrentValue(count);
            }
            catch (IllegalMetricNameException imne) {
                this.fSettings.getModuleFeedback().error("Error creating LeakHunter metrics", (Throwable)imne);
                Assertion.wilyFail();
            }
        }
    }
}

