/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.leakhunter.ITrackedLeakReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class PotentialLeakHashMap {
    private static final int kInitialCapacity = 256;
    private static final int kMaximumCapacity = 0x40000000;
    private static final float kLoadFactor = 0.75f;
    private static final int kLockCount = 32;
    private static final int kLockMask = 31;
    private boolean fIsActive = true;
    private final Object[] fLocks = this.createLocks();
    private final int[] fCounts = new int[32];
    private Entry[] fTable = this.createTable(256);
    private int fThreshold;
    private volatile transient int fThresholdBitmask;

    private Object[] createLocks() {
        Object[] locks = new Object[32];
        for (int i = 0; i < locks.length; ++i) {
            locks[i] = new Object();
        }
        return locks;
    }

    private Entry[] createTable(int capacity) {
        this.fThreshold = (int)((float)capacity * 0.75f / 32.0f) + 1;
        return new Entry[capacity];
    }

    private static int bitcount(int w) {
        w -= (0xAAAAAAAA & w) >>> 1;
        w = (w & 0x33333333) + (w >>> 2 & 0x33333333);
        w = w + (w >>> 4) & 0xF0F0F0F;
        w += w >>> 8;
        w += w >>> 16;
        return w & 0xFF;
    }

    private static int calculateHashCode(Object key) {
        int h = System.identityHashCode(key);
        return (h << 7) - h + (h >>> 9) + (h >>> 17);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int result = 0;
        for (int i = 0; i < this.fCounts.length; ++i) {
            Object object = this.fLocks[i];
            synchronized (object) {
                result += this.fCounts[i];
                continue;
            }
        }
        return result;
    }

    public boolean setInactive() {
        return this.setInactive(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setInactive(int index) {
        Object object = this.fLocks[index];
        synchronized (object) {
            if (this.isActive()) {
                int next = index + 1;
                if (next < this.fLocks.length) {
                    return this.setInactive(next);
                }
                this.fIsActive = false;
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITrackedLeakReference[] snapshot() {
        for (int attempt = 0; attempt < 2; ++attempt) {
            boolean failed = false;
            ArrayList<ITrackedLeakReference> results = new ArrayList<ITrackedLeakReference>();
            Entry[] table = this.fTable;
            for (int index = 0; index < table.length; ++index) {
                Object object = this.fLocks[index & 0x1F];
                synchronized (object) {
                    if (table == this.fTable) {
                        Entry e = table[index];
                        while (e != null) {
                            results.add(e.fValue);
                            e = e.fNext;
                        }
                    } else {
                        failed = true;
                        break;
                    }
                    continue;
                }
            }
            if (failed) continue;
            return results.toArray(ITrackedLeakReference.kZeroLengthArray);
        }
        return this.lockAndSnapshot(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITrackedLeakReference[] lockAndSnapshot(int index) {
        Object object = this.fLocks[index];
        synchronized (object) {
            int next = index + 1;
            if (next < this.fLocks.length) {
                return this.lockAndSnapshot(next);
            }
            return this.fullSnapshot();
        }
    }

    private ITrackedLeakReference[] fullSnapshot() {
        ArrayList<ITrackedLeakReference> results = new ArrayList<ITrackedLeakReference>();
        Entry[] table = this.fTable;
        for (int index = 0; index < table.length; ++index) {
            Entry e = table[index];
            while (e != null) {
                results.add(e.fValue);
                e = e.fNext;
            }
        }
        return results.toArray(ITrackedLeakReference.kZeroLengthArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITrackedLeakReference get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int hash = PotentialLeakHashMap.calculateHashCode(key);
        Object object = this.fLocks[hash & 0x1F];
        synchronized (object) {
            Entry[] table = this.fTable;
            int index = hash & table.length - 1;
            Entry e = table[index];
            while (e != null) {
                if (e.keyEquals(key)) {
                    return e.fValue;
                }
                e = e.fNext;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ITrackedLeakReference value) {
        Entry entry = (Entry)value.ITrackedLeakReference_getReference();
        int hash = entry.hashCode();
        Object object = this.fLocks[hash & 0x1F];
        synchronized (object) {
            Entry[] table = this.fTable;
            int index = hash & table.length - 1;
            Entry e = table[index];
            while (e != null) {
                if (e == entry) {
                    return true;
                }
                e = e.fNext;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITrackedLeakReference put(Object key, ITrackedLeakReference value) {
        int thresholdBitmask;
        int segmentCount;
        Entry[] table;
        int hash = PotentialLeakHashMap.calculateHashCode(key);
        Object object = this.fLocks[hash & 0x1F];
        synchronized (object) {
            Entry entry;
            table = this.fTable;
            int index = hash & table.length - 1;
            Entry e = table[index];
            while (e != null) {
                if (e.keyEquals(key)) {
                    return e.fValue;
                }
                e = e.fNext;
            }
            if (!this.isActive()) {
                return null;
            }
            table[index] = entry = new Entry(hash, key, value, table[index]);
            int n = hash & 0x1F;
            this.fCounts[n] = this.fCounts[n] + 1;
            segmentCount = this.fCounts[n];
            if (segmentCount < this.fThreshold) {
                return value;
            }
            thresholdBitmask = this.fThresholdBitmask;
            int bit = 1 << (hash & 0x1F);
            if ((thresholdBitmask & bit) == 0) {
                thresholdBitmask = this.fThresholdBitmask |= bit;
            }
        }
        if (PotentialLeakHashMap.bitcount(thresholdBitmask) >= 8 || segmentCount > this.fThreshold * 32) {
            this.resize(0, table);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(int index, Entry[] expectedTable) {
        Object object = this.fLocks[index];
        synchronized (object) {
            if (expectedTable == this.fTable) {
                int next = index + 1;
                if (next < this.fLocks.length) {
                    this.resize(next, expectedTable);
                } else {
                    this.rehash();
                }
            }
        }
    }

    private void rehash() {
        Entry[] table = this.fTable;
        if (table.length >= 0x40000000) {
            this.fThreshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = this.createTable(table.length << 1);
        int mask = newTable.length - 1;
        for (int i = 0; i < table.length; ++i) {
            Entry e = table[i];
            Entry nextE = null;
            while (e != null) {
                Entry newNext;
                nextE = e.fNext;
                int newIndex = e.hashCode() & mask;
                e.fNext = newNext = newTable[newIndex];
                newTable[newIndex] = e;
                e = nextE;
            }
        }
        this.fTable = newTable;
    }

    public void remove(ITrackedLeakReference value) {
        this.remove((Entry)value.ITrackedLeakReference_getReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Entry entry) {
        int hash = entry.hashCode();
        Object object = this.fLocks[hash & 0x1F];
        synchronized (object) {
            Entry[] table = this.fTable;
            int index = hash & table.length - 1;
            Entry previous = null;
            Entry e = table[index];
            while (e != null) {
                if (e == entry) {
                    if (previous == null) {
                        table[index] = e.fNext;
                    } else {
                        previous.fNext = e.fNext;
                    }
                    int n = hash & 0x1F;
                    this.fCounts[n] = this.fCounts[n] - 1;
                    return;
                }
                previous = e;
                e = e.fNext;
            }
        }
    }

    ITrackedLeakReference[] debug_getFullSnapshot() {
        return this.lockAndSnapshot(0);
    }

    private static final class Entry
    extends WeakReference {
        private final int fHashCode;
        final ITrackedLeakReference fValue;
        Entry fNext;

        Entry(int hashCode, Object key, ITrackedLeakReference value, Entry next) {
            super(key);
            this.fHashCode = hashCode;
            this.fValue = value;
            this.fNext = next;
            value.ITrackedLeakReference_setReference(this);
        }

        public int hashCode() {
            return this.fHashCode;
        }

        boolean keyEquals(Object key) {
            return this.get() == key;
        }
    }
}

