/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.leakhunter.FieldRecord;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongConstantDataAccumulator;
import com.wily.introscope.agent.stat.IStringConstantDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import java.util.ArrayList;
import java.util.List;

class PotentialLeakMetrics {
    private final IAgent fAgent;
    private final String fPotentialLeakID;
    private final IStringConstantDataAccumulator fClassNameDataAccumulator;
    private final IStringConstantDataAccumulator fAllocationMethodDataAccumulator;
    private final ILongConstantDataAccumulator fAllocationTimestampDataAccumulator;
    private final IStringConstantDataAccumulator fAllocationStackTraceDataAccumulator;
    private final IIntegerFluctuatingCounterDataAccumulator fCurrentSizeDataAccumulator;
    private final IStringEveryEventDataAccumulator fCurrentlyLeakingDataAccumulator;
    private final List fFieldNameDataAccumulators;
    private boolean fTornDown;

    PotentialLeakMetrics(IAgent agent, String potentialLeakID, String className, String allocationMethod, long allocationTimestamp, String allocationStackTrace, String[] assignedFields, int currentSize, boolean isCurrentlyLeaking) {
        this.fAgent = agent;
        this.fPotentialLeakID = potentialLeakID;
        this.fTornDown = false;
        DataAccumulatorFactory factory = agent.IAgent_getDataAccumulatorFactory();
        this.fClassNameDataAccumulator = factory.safeGetStringConstantDataAccumulator(this.buildMetricNameFromSuffix(":Collection Class"), className);
        this.fAllocationMethodDataAccumulator = allocationMethod == null ? null : factory.safeGetStringConstantDataAccumulator(this.buildMetricNameFromSuffix(":Allocation Method"), allocationMethod);
        this.fAllocationTimestampDataAccumulator = allocationTimestamp < 0L ? null : factory.safeGetTimestampConstantDataAccumulator(this.buildMetricNameFromSuffix(":Allocation Time"), allocationTimestamp);
        this.fAllocationStackTraceDataAccumulator = allocationStackTrace == null ? null : factory.safeGetStringConstantDataAccumulator(this.buildMetricNameFromSuffix(":Allocation Stack Trace"), allocationStackTrace);
        this.fCurrentSizeDataAccumulator = factory.safeGetIntegerFluctuatingCounterDataAccumulator(this.buildMetricNameFromSuffix(":Size"));
        this.fCurrentlyLeakingDataAccumulator = factory.safeGetStringEveryEventDataAccumulator(this.buildMetricNameFromSuffix(":Currently Leaking"));
        this.fFieldNameDataAccumulators = new ArrayList();
        this.addAssignedFields(assignedFields);
        this.updateSize(currentSize);
        this.updateCurrentlyLeaking(isCurrentlyLeaking);
    }

    private String buildMetricNameFromSuffix(String suffix) {
        return "LeakHunter|" + this.fPotentialLeakID + suffix;
    }

    private String buildFieldNameMetricNameFromIndex(int index) {
        String name = this.buildMetricNameFromSuffix(":Field Name");
        if (index > 1) {
            name = name + " #" + String.valueOf(index);
        }
        return name;
    }

    public void updateValues(int currentSize, boolean isCurrentlyLeaking) {
        this.updateSize(currentSize);
        this.updateCurrentlyLeaking(isCurrentlyLeaking);
    }

    private void updateSize(int currentSize) {
        if (!this.fAgent.IAgent_isMetricShutOff(this.fCurrentSizeDataAccumulator.IDataAccumulator_getMetric())) {
            this.fCurrentSizeDataAccumulator.IIntegerCounterDataAccumulator_setValue(currentSize);
        }
    }

    private void updateCurrentlyLeaking(boolean isCurrentlyLeaking) {
        if (!this.fAgent.IAgent_isMetricShutOff(this.fCurrentlyLeakingDataAccumulator.IDataAccumulator_getMetric())) {
            String value = (isCurrentlyLeaking ? Boolean.TRUE : Boolean.FALSE).toString();
            this.fCurrentlyLeakingDataAccumulator.IStringEveryEventDataAccumulator_addString(value);
        }
    }

    private void addAssignedFields(String[] fields) {
        for (int fieldII = 0; fieldII < fields.length && fields[fieldII] != null; ++fieldII) {
            this.addAssignedField(fields[fieldII]);
        }
    }

    public synchronized void addAssignedField(String field) {
        if (!this.fTornDown) {
            int index = this.fFieldNameDataAccumulators.size() + 1;
            IStringConstantDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetStringConstantDataAccumulator(this.buildFieldNameMetricNameFromIndex(index), FieldRecord.getFullyQualifiedFieldName(field));
            this.fFieldNameDataAccumulators.add(accumulator);
        }
    }

    public synchronized void tearDown() {
        if (!this.fTornDown) {
            this.fTornDown = true;
            DataAccumulatorFactory factory = this.fAgent.IAgent_getDataAccumulatorFactory();
            factory.removeDataAccumulator((IDataAccumulator)this.fClassNameDataAccumulator);
            if (this.fAllocationMethodDataAccumulator != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.fAllocationMethodDataAccumulator);
            }
            if (this.fAllocationTimestampDataAccumulator != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.fAllocationTimestampDataAccumulator);
            }
            if (this.fAllocationStackTraceDataAccumulator != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.fAllocationStackTraceDataAccumulator);
            }
            factory.removeDataAccumulator((IDataAccumulator)this.fCurrentSizeDataAccumulator);
            factory.removeDataAccumulator((IDataAccumulator)this.fCurrentlyLeakingDataAccumulator);
            for (IDataAccumulator accumulator : this.fFieldNameDataAccumulators) {
                factory.removeDataAccumulator(accumulator);
            }
        }
    }
}

