/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.metadata.register;

import com.ca.apm.agent.apmservices.client.httpclient.APMServicesHostConnection;
import com.ca.apm.agent.apmservices.client.httpclient.HttpClientFactory;
import com.ca.apm.agent.apmservices.client.metadata.register.MetricRegisterResponseHandler;
import com.ca.apm.agent.apmservices.client.metadata.register.model.RegisteredMetric;
import com.ca.apm.agent.apmservices.client.metadata.register.model.RegisteredMetrics;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricData;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.NASSMetric;
import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityRecorder;
import com.ca.apm.agent.apmservices.client.utils.APMServiceEndpointURL;
import com.ca.apm.agent.apmservices.client.utils.APMServicesConnection;
import com.ca.apm.agent.apmservices.client.utils.StringUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MetricRegistrar {
    private IAgent agent;
    private IModuleFeedbackChannel logger;
    private Cache<NASSMetric, String> metricIdCache;
    private static final long CACHE_SIZE = 1000000L;
    private static final long DEFAULT_AGE = 30L;
    protected final APMServicesConnection connection;
    String extensionName;

    public void initCache(long cacheSize, long cacheAgeInMinute, IAgent agent) {
        if (this.metricIdCache == null) {
            MetricCacheHolder.getInstance().setParameters(cacheSize, cacheAgeInMinute, agent);
            this.metricIdCache = MetricCacheHolder.getInstance().getMetricCache();
        }
    }

    public MetricRegistrar(APMServicesConnection connection, IAgent agent, String extensionName) {
        this.connection = connection;
        this.agent = agent;
        this.extensionName = extensionName;
        this.initCache(1000000L, 30L, agent);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void register(Collection<MetricData> batch) {
        ArrayList<NASSMetric> metricsToRegister = new ArrayList<NASSMetric>();
        for (MetricData entry : batch) {
            NASSMetric metricToRegister = entry.getMetric();
            if (this.lookupMetricIdInCache(metricToRegister) == null) {
                metricsToRegister.add(metricToRegister);
                continue;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Cache entry accessed:: " + metricToRegister.toString());
        }
        RegisteredMetrics registeredMetrics = this.registerMetadata(metricsToRegister);
        this.updateCache(registeredMetrics.getMetrics());
        for (MetricData entry : batch) {
            String metricId = this.lookupMetricIdInCache(entry.getMetric());
            if (metricId == null) continue;
            entry.setMetricId(metricId);
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Cache entry accessed:: " + entry.getMetric().toString());
        }
    }

    private void updateCache(Collection<RegisteredMetric> registeredMetrics) {
        for (RegisteredMetric registeredMetric : registeredMetrics) {
            this.metricIdCache.put((Object)registeredMetric.getMetric(), (Object)registeredMetric.getId());
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Cache entry added:: " + registeredMetric.getMetric().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegisteredMetrics registerMetadata(Collection<NASSMetric> metricsToRegister) {
        RegisteredMetrics metricsRegistered = new RegisteredMetrics();
        if (metricsToRegister == null || metricsToRegister.isEmpty()) {
            return metricsRegistered;
        }
        String jsonPayload = this.createNASSRegistrationPayload(metricsToRegister);
        if (StringUtil.isEmpty(jsonPayload)) {
            return metricsRegistered;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NASS Metadata Payload to register :" + jsonPayload);
        }
        String responseJSON = null;
        Request.Builder httpReq = new Request.Builder();
        httpReq.addHeader("authorization", String.format("Bearer %s", this.connection.getCredential()));
        httpReq.addHeader("content-type", "application/json");
        APMServicesHostConnection hostConnection = this.connection.getApmServicesHostConnection();
        httpReq.url(hostConnection.getConnectionURL("/metadata/registerMetric"));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("authorization :" + String.format("Bearer %s", this.connection.getCredential()));
            this.logger.debug("URL :" + hostConnection.getConnectionURL("/metadata/registerMetric"));
        }
        try (Response response = null;){
            if (jsonPayload != null) {
                httpReq.post(RequestBody.create((MediaType)APMServiceEndpointURL.JSON, (String)new String(jsonPayload.getBytes(), Charset.forName("UTF-8"))));
            }
            MetricRegisterResponseHandler metricRegisterResponseHandler = new MetricRegisterResponseHandler(this.logger);
            response = HttpClientFactory.executeRequestSync(httpReq.build());
            metricRegisterResponseHandler.onResponse(null, response);
            if (response.code() == 200) {
                responseJSON = response.body().string();
                if (StringUtil.isNotBlank(responseJSON)) {
                    Gson gson = new Gson();
                    metricsRegistered = (RegisteredMetrics)gson.fromJson(responseJSON, RegisteredMetrics.class);
                    SustainabilityRecorder.putMetric("|Metadata:Number of Metric Register", metricsRegistered.getMetrics().size());
                } else {
                    this.logger.warn("Bulk registration of metrics failed empty response");
                    SustainabilityRecorder.putMetric("|Metadata:Number of Metric Register Failed", metricsToRegister.size());
                }
            } else {
                this.logger.error("Cannot bulk register Metrics : HTTP Status code = " + response.code() + " Status Text: " + response.message() + " " + response.body().string());
                SustainabilityRecorder.putMetric("|Metadata:Number of Metric Register Failed", metricsToRegister.size());
            }
        }
        return metricsRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createNASSRegistrationPayload(Collection<NASSMetric> metricsToRegister) {
        ByteArrayOutputStream jsonOut = new ByteArrayOutputStream();
        JsonWriter writer = null;
        try {
            writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)jsonOut, "UTF-8"));
            writer.beginObject().name("metrics").beginArray();
            for (NASSMetric metric : metricsToRegister) {
                writer.beginObject();
                writer.name("sourceName").value(metric.getSourceName());
                writer.name("type").value((long)metric.getType());
                writer.name("attributeName").value(metric.getAttributeName());
                writer.endObject();
            }
            writer.endArray().endObject().flush();
        }
        catch (Exception ex) {
            this.logger.error("Error generating JSON metric registration payload for NASS Metrics", (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        return jsonOut.toString();
    }

    private String lookupMetricIdInCache(NASSMetric metric) {
        return (String)this.metricIdCache.getIfPresent((Object)metric);
    }

    public static long getCount() {
        Cache cache = MetricCacheHolder.getInstance().getMetricCache();
        if (cache != null) {
            return cache.size();
        }
        return 0L;
    }

    private static class MetricCacheHolder {
        private static final MetricCacheHolder INSTANCE = new MetricCacheHolder();
        private Cache<NASSMetric, String> metricIdCache;
        private IModuleFeedbackChannel logger;
        private long cacheSize;
        private long cacheAgeInMinute;
        private IAgent agent;

        private MetricCacheHolder() {
        }

        public static MetricCacheHolder getInstance() {
            return INSTANCE;
        }

        public void setParameters(long cacheSize, long cacheAgeInMinute, IAgent agent) {
            this.cacheSize = cacheSize;
            this.cacheAgeInMinute = cacheAgeInMinute;
            this.agent = agent;
            this.logger = agent.IAgent_getModuleFeedback();
        }

        public Cache getMetricCache() {
            if (this.metricIdCache == null) {
                this.initializeCache();
            }
            return this.metricIdCache;
        }

        private synchronized void initializeCache() {
            if (this.metricIdCache == null && this.cacheSize > 0L && this.cacheAgeInMinute > 0L) {
                this.logger = this.agent.IAgent_getModuleFeedback();
                RemovalListener<NASSMetric, String> removalListener = new RemovalListener<NASSMetric, String>(){

                    public void onRemoval(RemovalNotification<NASSMetric, String> removal) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("MetricId Cache entry " + removal.getCause().name() + "In Thread: " + Thread.currentThread().getName());
                        }
                        SustainabilityRecorder.putMetric("|Metadata:Number of Register MetricId Cache Entry Removed", 1L);
                    }
                };
                this.metricIdCache = CacheBuilder.newBuilder().maximumSize(this.cacheSize).recordStats().expireAfterAccess(this.cacheAgeInMinute, TimeUnit.MINUTES).removalListener((RemovalListener)removalListener).build();
                this.logger.info("MetricId Cache created: " + Thread.currentThread().getName());
            }
        }
    }
}

