/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.nass.publisher;

import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityRecorder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class MetricResponseHandler
implements Callback {
    int numRecordsLoaded;
    IModuleFeedbackChannel logger;
    String extensionName;
    long startTime;

    public MetricResponseHandler(IModuleFeedbackChannel logger, String extensionName, int numRecordsLoaded) {
        this.logger = logger;
        this.extensionName = extensionName;
        this.numRecordsLoaded = numRecordsLoaded;
        this.startTime = System.currentTimeMillis();
    }

    public void onFailure(Call call, IOException e) {
        this.logger.error("Unable to sent metric records. URL = " + call.request().url() + "  error: " + e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        long totalTime = System.currentTimeMillis() - this.startTime;
        SustainabilityRecorder.putMetric("|NASS:Metric Store API Call Time(ms)", totalTime);
        if (response.code() == 200) {
            if (!"APMServicesSustainability".equals(this.extensionName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.extensionName + ": Successfully sent << " + this.numRecordsLoaded + " >> metric records");
                }
                SustainabilityRecorder.putMetric("|NASS:Number of Metric Sent", this.numRecordsLoaded);
            }
        } else {
            SustainabilityRecorder.putMetric("|NASS:Number of Metric Sent Failed", this.numRecordsLoaded);
            this.numRecordsLoaded = 0;
            this.logger.error("Unable to sent metric records. HTTP RESPONSE CODE = " + response.code() + "  " + response.body());
        }
        if (response != null) {
            response.close();
        }
    }
}

