/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.service;

import com.ca.apm.agent.apmservices.client.api.JarvisServiceAPI;
import com.ca.apm.agent.apmservices.client.httpclient.APMServicesHostConnection;
import com.ca.apm.agent.apmservices.client.httpclient.HttpClientFactory;
import com.ca.apm.agent.apmservices.client.nass.publisher.MetricResponseHandler;
import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityEvent;
import com.ca.apm.agent.apmservices.client.utils.APMServiceEndpointURL;
import com.ca.apm.agent.apmservices.client.utils.APMServicesConnection;
import com.google.gson.stream.JsonWriter;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class JarvisService
implements JarvisServiceAPI {
    private IAgent iAgent;
    private APMServicesConnection connection;
    private IModuleFeedbackChannel logger;
    private String extensionName;
    private static final String AUTH_HDR_STR = "Authorization";
    private static final String BEARER_TOKEN_STR = "Bearer %s";
    private static final String CONTENTTYPE_HDR_STR = "Content-Type";
    private static final String APPLICATION_JSON_STR = "application/json";
    private static final int BATCH_SIZE = 1000;
    private static final int QUEUE_SIZE = 1000;
    private BlockingQueue<SustainabilityEvent> queue;
    private static final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(2);
    private static boolean sendSustainabilityEvents = true;

    public JarvisService(IAgent iAgent, APMServicesConnection connection, String extensionName) {
        this.iAgent = iAgent;
        this.connection = connection;
        this.logger = iAgent.IAgent_getModuleFeedback();
        this.extensionName = extensionName;
        this.queue = new LinkedBlockingQueue<SustainabilityEvent>(1000);
        executor.schedule(new QueueConsumer(), 15L, TimeUnit.SECONDS);
    }

    @Override
    public void processEvent(Collection<Map<String, String>> events) {
        this.createPayloadAndPushTOES(events, "itoa_events_change_custom");
    }

    public void createPayloadAndPushTOES(Collection<Map<String, String>> events, String indexName) {
        int nextInc;
        int size = 1000;
        ArrayList<Map<String, String>> eventList = new ArrayList<Map<String, String>>(events);
        for (int i = 0; i < events.size(); i += nextInc) {
            nextInc = Math.min(eventList.size() - i, size);
            List<Map<String, String>> eventSubList = eventList.subList(i, i + nextInc);
            String jsonPayloadForEvents = this.createPayload(eventSubList, indexName);
            this.logger.info("Total Event " + eventList.size() + ", Max Batch Size " + 1000 + ", Number of events in this batch " + eventSubList.size() + ", Event Payload for the batch::::::: " + jsonPayloadForEvents);
            this.sendJsontoES(jsonPayloadForEvents, "ao_" + indexName + "_1", false, eventList.size());
        }
    }

    @Override
    public void processAlarm(Collection<Map<String, String>> alarms) {
        int nextInc;
        int size = 1000;
        ArrayList<Map<String, String>> alarmsList = new ArrayList<Map<String, String>>(alarms);
        for (int i = 0; i < alarms.size(); i += nextInc) {
            nextInc = Math.min(alarms.size() - i, size);
            List<Map<String, String>> alarmsSubList = alarmsList.subList(i, i + nextInc);
            String jsonPayloadForAlarm = this.createPayload(alarmsSubList, "itoa_alarms_custom");
            this.logger.info("Total Alarm " + alarmsList.size() + ", Max Batch Size " + 1000 + ", Number of alarms in this batch " + alarmsSubList.size() + ", Alarm Payload for the batch::::::: " + jsonPayloadForAlarm);
            this.sendJsontoES(jsonPayloadForAlarm, "ao_itoa_alarms_custom_1", false, alarmsList.size());
        }
    }

    @Override
    public void pushToESIndexAsync(Collection<Map<String, String>> events, String indexName) {
        this.createPayloadAndPushTOES(events, indexName);
    }

    @Override
    public void processSustainabilityEventsAsync(Collection<SustainabilityEvent> events) {
        this.addEventsTOQueue(events);
    }

    @Override
    public void processSustainabilityEventAsync(SustainabilityEvent event) {
        this.addEventTOQueue(event);
    }

    private void addEventsTOQueue(Collection<SustainabilityEvent> events) {
        ArrayList<SustainabilityEvent> eventList = new ArrayList<SustainabilityEvent>(events);
        for (SustainabilityEvent event : events) {
            this.addEventTOQueue(event);
        }
    }

    private void addEventTOQueue(SustainabilityEvent event) {
        sendSustainabilityEvents = Boolean.parseBoolean(System.getenv().getOrDefault("SEND_SUSTAINABILITY_EVENTS", "true"));
        if (sendSustainabilityEvents) {
            try {
                if (this.queue.size() < 1000) {
                    this.queue.put(event);
                }
                this.wait(15000L);
                this.logger.info("Waited 15 seconds for queue to be available and retrying");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.logger.info("SEND_SUSTAINABILITY_EVENTS is set to false skipping SustainabilityEvents push to elastic");
        }
    }

    private String createEventPayload(Collection<SustainabilityEvent> events, String indexName) {
        String payload = "";
        try (ByteArrayOutputStream jsonOut = new ByteArrayOutputStream();
             JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)jsonOut, StandardCharsets.UTF_8));){
            writer.beginObject();
            writer.name("documents");
            writer.beginArray();
            writer.beginObject();
            this.prepareHeader(writer, indexName, "event_unique_id");
            this.prepareEventBody(events, writer);
            writer.endObject();
            writer.endArray();
            writer.endObject();
            writer.flush();
            payload = jsonOut.toString();
            this.logger.debug("event payload: " + payload);
        }
        catch (Exception ex) {
            this.logger.error("Error in preparing json payload for Events.", (Throwable)ex);
        }
        return payload;
    }

    private void prepareEventBody(Collection<SustainabilityEvent> data, JsonWriter writer) throws IOException {
        writer.name("body");
        writer.beginArray();
        ((Stream)data.stream().parallel()).forEach(object -> {
            try {
                JsonWriter jsonWriter = writer;
                synchronized (jsonWriter) {
                    writer.beginObject();
                    this.logger.debug("SustainabilityEvent being processed is " + object.toString());
                    writer.name("message").value(object.getMessage());
                    writer.name("reason").value(object.getReason());
                    writer.name("timestamp").value(object.getTimeStamp());
                    writer.name("involvedComponent").value(object.getInvolvedComponent());
                    writer.name("agent").value(object.getAgent());
                    writer.name("source").value(object.getSource());
                    writer.name("severity").value(object.getSeverity());
                    writer.name("event_unique_id").value(object.getEventUniqueId());
                    writer.name("agent_source").value(object.getAgentSource());
                    writer.name("environment").value(object.getEnvironment());
                    writer.name("cluster_name").value(object.getClusterName());
                    writer.name("pod_name").value(object.getPodName());
                    writer.name("namespace").value(object.getNamespace());
                    writer.name("product").value("Application Performance Managment");
                    writer.name("product_version").value("1");
                    writer.endObject();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        writer.endArray();
    }

    public String createPayload(Collection<Map<String, String>> data, String esIndex) {
        String payload = "";
        try (ByteArrayOutputStream jsonOut = new ByteArrayOutputStream();
             JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)jsonOut, StandardCharsets.UTF_8));){
            writer.beginObject();
            writer.name("documents");
            writer.beginArray();
            writer.beginObject();
            this.prepareHeader(writer, esIndex, "alarm_unique_id");
            this.prepareBody(data, writer);
            writer.endObject();
            writer.endArray();
            writer.endObject();
            writer.flush();
            payload = jsonOut.toString();
        }
        catch (Exception ex) {
            this.logger.error("Error in preparing json payload for Alarms.", (Throwable)ex);
        }
        return payload;
    }

    private void prepareBody(Collection<Map<String, String>> data, JsonWriter writer) throws IOException {
        writer.name("body");
        writer.beginArray();
        ((Stream)data.stream().parallel()).forEach(object -> {
            try {
                JsonWriter jsonWriter = writer;
                synchronized (jsonWriter) {
                    writer.beginObject();
                    Map eventFields = object;
                    for (Map.Entry fieldEntry : eventFields.entrySet()) {
                        writer.name((String)fieldEntry.getKey()).value((String)fieldEntry.getValue());
                    }
                    writer.endObject();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        writer.endArray();
    }

    private void prepareHeader(JsonWriter writer, String index, String unique_id) throws IOException {
        String cohortID = this.connection.getCohortID();
        writer.name("header");
        writer.beginObject();
        writer.name("product_id").value("ao");
        writer.name("doc_type_id").value(index);
        writer.name("doc_type_version").value("1");
        writer.name("tenant_id").value(cohortID);
        writer.name("unique_id").value("$['" + unique_id + "']");
        this.logger.debug("event doc_type_id: " + index + " tenant_id: " + cohortID + " unique_id: $['" + unique_id + "']");
        writer.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJsontoES(String jsonPayload, String index, Boolean async, int batchSize) {
        Request.Builder httpReq = new Request.Builder();
        httpReq.addHeader(AUTH_HDR_STR, String.format(BEARER_TOKEN_STR, this.connection.getCredential()));
        httpReq.addHeader(CONTENTTYPE_HDR_STR, APPLICATION_JSON_STR);
        httpReq.addHeader("index-name", index);
        APMServicesHostConnection hostConnection = this.connection.getApmServicesHostConnection();
        httpReq.url(hostConnection.getConnectionURL("/jarvis/v2/ingestion"));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Authorization :" + String.format(BEARER_TOKEN_STR, this.connection.getCredential()));
            this.logger.debug("URL :" + hostConnection.getConnectionURL("/jarvis/v2/ingestion"));
        }
        try (Response response = null;){
            if (jsonPayload != null) {
                httpReq.post(RequestBody.create((MediaType)APMServiceEndpointURL.JSON, (String)new String(jsonPayload.getBytes(), StandardCharsets.UTF_8)));
            }
            if (async.booleanValue()) {
                MetricResponseHandler metricResponseHandler = new MetricResponseHandler(this.logger, this.extensionName, batchSize);
                HttpClientFactory.executeRequestAsync(httpReq.build(), metricResponseHandler);
            } else {
                response = HttpClientFactory.executeRequestSync(httpReq.build());
                if (response.code() == 200 || response.code() == 202) {
                    this.logger.info("Events/Alarms has been sent with code " + response.code() + ", Please check respective es index " + index);
                } else {
                    this.logger.error("Error in payload data : HTTP Status code = " + response.code() + ", Status Text: " + response.message() + ", Response Body: " + response.body().string());
                }
            }
        }
    }

    class QueueConsumer
    implements Runnable {
        QueueConsumer() {
        }

        @Override
        public void run() {
            long lastRuntime = System.currentTimeMillis();
            while (true) {
                ArrayList events = new ArrayList();
                if (JarvisService.this.queue.size() > 15 || JarvisService.this.queue.size() > 0 && System.currentTimeMillis() - lastRuntime > 15000L) {
                    JarvisService.this.queue.drainTo(events, 100);
                    if (JarvisService.this.queue != null) {
                        String jsonPayloadForAlarm = JarvisService.this.createEventPayload(events, "itoa_sustainability_events_apm");
                        JarvisService.this.sendJsontoES(jsonPayloadForAlarm, "ao_itoa_sustainability_events_apm_1", false, 1000);
                        events.clear();
                    }
                    lastRuntime = System.currentTimeMillis();
                    continue;
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

