/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.service;

import com.ca.apm.agent.apmservices.client.api.MetadataServiceAPI;
import com.ca.apm.agent.apmservices.client.api.NASSServiceAPI;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.MetricDataService;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricData;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricRequest;
import com.ca.apm.agent.apmservices.client.nass.publisher.MetricPublisher;
import com.ca.apm.agent.apmservices.client.nass.publisher.model.IngestRecord;
import com.ca.apm.agent.apmservices.client.nass.publisher.model.IngestRecords;
import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityRecorder;
import com.ca.apm.agent.apmservices.client.utils.APMServicesConnection;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NASSService
implements NASSServiceAPI {
    private IModuleFeedbackChannel logger;
    private MetadataServiceAPI metadataServiceAPI;
    private String sourceName;
    private MetricDataService metricBatchService;
    private MetricPublisher metricPublisher;
    private Collection<MetricData> batch = new ArrayList<MetricData>();

    public NASSService(IAgent iAgent, APMServicesConnection connection, MetadataServiceAPI metadataServiceAPI, String extensionName) {
        this.logger = iAgent.IAgent_getModuleFeedback();
        String[] triplet = iAgent.IAgent_getHostProcessAgentTriplet();
        this.sourceName = "SuperDomain|" + triplet[0] + "|" + triplet[1] + "|" + triplet[2];
        this.metadataServiceAPI = metadataServiceAPI;
        this.metricBatchService = new MetricDataService(this.logger, this.sourceName);
        this.metricPublisher = new MetricPublisher(connection, this.logger, extensionName);
    }

    public void addMetricToBatch(MetricRequest metricRequest) {
        MetricData metricBatchEntry = this.metricBatchService.getMetricBatchEntry(metricRequest);
        this.batch.add(metricBatchEntry);
    }

    public Integer publishBatchMetrics(boolean async) {
        Integer resultFuture = null;
        if (!this.batch.isEmpty()) {
            this.metadataServiceAPI.registerMetric(this.batch);
            IngestRecords recordBatch = new IngestRecords();
            for (MetricData entry : this.batch) {
                IngestRecord record = (IngestRecord)entry.getMetricRecord();
                record.setId(entry.getMetricId());
                recordBatch.addRecord(record);
            }
            resultFuture = this.metricPublisher.publishMetricRecords(recordBatch, async);
            this.batch.clear();
        }
        return resultFuture;
    }

    @Override
    public Integer sendMetric(MetricRequest request) {
        long startTime = System.currentTimeMillis();
        this.addMetricToBatch(request);
        Integer result = this.publishBatchMetrics(false);
        long totalTime = System.currentTimeMillis() - startTime;
        SustainabilityRecorder.putMetric("|NASS:Register and Store Metric Average Total Time(ms)", totalTime);
        return result;
    }

    @Override
    public void sendMetricAsync(MetricRequest request) {
        long startTime = System.currentTimeMillis();
        this.addMetricToBatch(request);
        this.publishBatchMetrics(true);
        long totalTime = System.currentTimeMillis() - startTime;
        SustainabilityRecorder.putMetric("|NASS:Async Register and Store Metric Average Total Time(ms)", totalTime);
    }

    @Override
    public Integer sendBatchMetric(List<MetricRequest> requestList) {
        for (MetricRequest metricRequest : requestList) {
            this.addMetricToBatch(metricRequest);
        }
        return this.publishBatchMetrics(false);
    }

    @Override
    public void sendBatchMetricAsync(List<MetricRequest> request) {
        for (MetricRequest metricRequest : request) {
            this.addMetricToBatch(metricRequest);
        }
        this.publishBatchMetrics(true);
    }
}

