/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.test;

import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricRequest;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.NASSMetric;
import com.ca.apm.agent.apmservices.client.service.APMServicesClientAPIService;
import com.wily.introscope.agent.IAgent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DataGenerator {
    private static final String METRIC_ATTR_NAME = "testFolder|subFolder:";
    private static final String METADATA_ATTR_TYPE_VAL = "257";
    private String sourceName;

    public DataGenerator(String sourceName) {
        this.sourceName = sourceName;
    }

    public List<NASSMetric> createNUniqueMetricPath(long number, long source) {
        LinkedList<NASSMetric> metricList = new LinkedList<NASSMetric>();
        long atrribute = number / 2L;
        atrribute = atrribute != 0L ? atrribute : 1L;
        List<String> atrributes = this.getNPermutedMetricAttr(atrribute, METRIC_ATTR_NAME);
        List<String> csvMetricNames = this.getNPermutedMetricNames(atrribute);
        long counter = 0L;
        for (String a : atrributes) {
            for (String m : csvMetricNames) {
                metricList.add(this.createMetric(a, m));
                if (++counter < number) continue;
                return metricList;
            }
        }
        return metricList;
    }

    private List<String> getNPermutedMetricNames(long metricSize) {
        LinkedList<String> result = new LinkedList<String>();
        int i = 0;
        while ((long)i < metricSize / 2L) {
            result.add("Test Metric" + i + "" + System.currentTimeMillis());
            ++i;
        }
        i = 0;
        while ((long)i < metricSize / 2L) {
            result.add("Test Metric" + i);
            ++i;
        }
        return result;
    }

    private NASSMetric createMetric(String attribute, String metricName) {
        NASSMetric metric = new NASSMetric(this.sourceName, 257, attribute + metricName);
        return metric;
    }

    private List<String> getNPermutedSource(long number, String source, int hosts, int agents) {
        ArrayList<String> result = new ArrayList<String>();
        String domain = source.split("\\|")[0];
        String sHost = source.split("\\|")[1];
        String sProcess = source.split("\\|")[2];
        String sAgent = source.split("\\|")[3];
        long host = hosts;
        long process = number / (long)(agents * hosts);
        process = process != 0L ? process : 1L;
        long agent = agents;
        int counter = 0;
        StringBuilder path = new StringBuilder();
        for (long h = 0L; h < host; ++h) {
            for (long p = 0L; p < process; ++p) {
                for (long a = 0L; a < agent; ++a) {
                    ++counter;
                    path.append(domain).append("|").append(h).append(sHost).append("|").append(p).append(sProcess).append("|").append(a).append(sAgent);
                    result.add(path.toString());
                    path.setLength(0);
                    if ((long)counter < number) continue;
                    return result;
                }
            }
        }
        return result;
    }

    private List<String> getNPermutedMetricAttr(long number, String metricAtrr) {
        ArrayList<String> result = new ArrayList<String>();
        String sF1 = metricAtrr.split("\\|")[0];
        String sF2 = metricAtrr.split("\\|")[1];
        long folder1 = (long)Math.sqrt(number);
        long folder2 = folder1 + (number - folder1 * folder1);
        int counter = 0;
        StringBuilder path = new StringBuilder();
        for (long f1 = 0L; f1 < folder1; ++f1) {
            for (long f2 = 0L; f2 < folder2; ++f2) {
                ++counter;
                path.append(f1).append(sF1).append("|").append(f2).append(sF2);
                result.add(path.toString());
                path.setLength(0);
                if ((long)counter < number) continue;
                return result;
            }
        }
        return result;
    }

    public static void initPublisher(IAgent agent) {
        ExecutorInstanceHolder.INSTANCE.scheduleAtFixedRate(new SendMetric(agent), 1L, 1L, TimeUnit.MINUTES);
    }

    public static void main(String[] args) {
        String METRIC_SOURCE_NAME = "SuperDomain|myHost|myProcess|myAgent1";
        DataGenerator dataGenerator = new DataGenerator(METRIC_SOURCE_NAME);
        try {
            List<NASSMetric> metricList = dataGenerator.createNUniqueMetricPath(1000000L, 1L);
            System.out.println("size :: " + metricList.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SendMetric
    implements Runnable {
        private static final String METRIC_SOURCE_NAME = "SuperDomain|myHost|myProcess|myAgent1";
        private static IAgent agent;

        public SendMetric(IAgent agent) {
            SendMetric.agent = agent;
        }

        @Override
        public void run() {
            DataGenerator dataGenerator = new DataGenerator(METRIC_SOURCE_NAME);
            List<NASSMetric> metricList = dataGenerator.createNUniqueMetricPath(100000L, 1L);
            this.sendTestMetrics(metricList);
            System.out.println("Custom metric generator ... finished");
        }

        private void sendTestMetrics(List<NASSMetric> metricList) {
            ArrayList<MetricRequest> requestList = new ArrayList<MetricRequest>();
            for (NASSMetric metric : metricList) {
                requestList.add(new MetricRequest(metric.getAttributeName(), "LongCounter", "2.0"));
            }
            APMServicesClientAPIService apmServicesClientAPI = new APMServicesClientAPIService(agent, "dummy agent");
            apmServicesClientAPI.sendBatchMetric(requestList);
        }
    }

    private static class ExecutorInstanceHolder {
        private static final ScheduledThreadPoolExecutor INSTANCE = new ScheduledThreadPoolExecutor(1);

        private ExecutorInstanceHolder() {
        }
    }
}

