/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.utils;

import com.ca.apm.agent.apmservices.client.httpclient.APMServicesHostConnection;
import com.wily.introscope.agent.IAgent;
import com.wily.isengard.api.ServerInstanceLocator;

public class APMServicesConnection {
    private static final int DEFAULT_DOCKER_APMSERVICES_PORT = 8004;
    private static final int DEFAULT_EM_PORT = 5001;
    private static final String DEFAULT_AGENT_TOKEN = "eyJ0eXAiOiJKV1QiLCJhbGciOiJFUzI1NiJ9.eyJhZ2VudCI6dHJ1ZSwidGlkIjoxLCJqdGkiOiI3Mzc3M2M1ZS1hZTJiLTRkMzItYTZkOS1iYjk4Yzg4ODU5ZWYifQ.6sUr6Au-7DFVOieS2esBRLznPn0vVM-o4OLAdoHjld9XpaTKj0iJTMXIPLj7vFzXY38bf-UNynewUZecKiMb9g";
    private APMServicesHostConnection apmServicesHostConnection;
    private String credential;
    private String cohortID;

    public APMServicesConnection(IAgent iAgent) {
        ServerInstanceLocator serverInstanceLocator = iAgent.IAgent_getIsengardServerConnection().getConnectedServer().getServerLocator();
        String protocol = this.getProtocol(serverInstanceLocator.getSocketType());
        this.credential = (String)iAgent.IAgent_getIndexedProperties().get((Object)"agentManager.credential");
        this.cohortID = (String)iAgent.IAgent_getIndexedProperties().get((Object)"introscope.agent.cohortID");
        if (serverInstanceLocator.getPort() != 5001) {
            this.apmServicesHostConnection = this.initAPMServicesHostConnection(protocol, serverInstanceLocator.getHostName(), serverInstanceLocator.getPort(), this.credential);
        } else if (this.credential == null || this.credential.isEmpty()) {
            this.credential = DEFAULT_AGENT_TOKEN;
            this.apmServicesHostConnection = this.initAPMServicesHostConnection(protocol, serverInstanceLocator.getHostName(), 8004, this.credential);
        } else {
            this.apmServicesHostConnection = this.initAPMServicesHostConnection(protocol, serverInstanceLocator.getHostName(), 8004, this.credential);
        }
    }

    private String getProtocol(String socketType) {
        String protocol = "http";
        if ("http tunneling".equals(socketType)) {
            protocol = "http";
        } else if ("https tunneling".equals(socketType) || socketType.startsWith("ssl")) {
            protocol = "https";
        }
        return protocol;
    }

    public String getCredential() {
        return this.credential;
    }

    public String getCohortID() {
        return this.cohortID;
    }

    private APMServicesHostConnection initAPMServicesHostConnection(String protocol, String host, int port, String tenantToken) {
        host = host.replaceAll("-cloudgw-", "-gateway-");
        return new APMServicesHostConnection(protocol, host, port, tenantToken);
    }

    public APMServicesHostConnection getApmServicesHostConnection() {
        return this.apmServicesHostConnection;
    }
}

