/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.ca.dxapm.sdk.gradle.plugin.CaMaaTransformer;
import com.ca.dxapm.sdk.gradle.plugin.extension.CAExtension;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.XmlParser;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0002\u00a8\u0006\u000b"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/MyPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "createLoggerFile", "readXmlProperties", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;", "Companion", "sdk-gradle-plugin"})
public final class MyPlugin
implements Plugin<Project> {
    @NotNull
    private static String finalPath;
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        XmlParser xmlParser;
        AppExtension appExtension;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getLogger().log(LogLevel.INFO, "MyPlugin applied");
        Object ext = project.getExtensions().findByName("android");
        if (ext != null && ext instanceof AppExtension) {
            project.getLogger().log(LogLevel.INFO, "Registering transform");
            XmlParser xmlParser2 = this.readXmlProperties(project);
            appExtension = (AppExtension)ext;
            xmlParser = xmlParser2;
            if (xmlParser == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new Exception(MyPlugin.class.getName() + " plugin may only be applied to Android app projects");
        }
        appExtension.registerTransform((Transform)new CaMaaTransformer(project, xmlParser), new Object[0]);
        project.getExtensions().create("cadxapmsdk", CAExtension.class, new Object[0]);
        project.getRootDir();
        this.createLoggerFile(project);
    }

    @Nullable
    public final XmlParser readXmlProperties(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        XmlParser xmlParser = null;
        StringBuilder stringBuilder = new StringBuilder();
        File file = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootDir");
        String completePath = stringBuilder.append(file.getAbsolutePath()).append(File.separator).append("cadxapmsdk").append(File.separator).append("android.xml").toString();
        Logger.Companion.print("Reading android.xml file");
        try {
            File xmlFile = new File(completePath);
            Logger.Companion.print("Does xml file exist :: " + xmlFile.exists());
            if (xmlFile.exists()) {
                xmlParser = new XmlParser();
                xmlParser.parseXML(completePath);
                Logger.Companion.print("Number of activities :: " + xmlParser.getClassReplacementList().size());
            } else {
                Logger.Companion.print("android.xml file under <project>/cadxapmsdk/android.xml is missing");
            }
        }
        catch (Exception e) {
            return null;
        }
        return xmlParser;
    }

    public final void createLoggerFile(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        StringBuilder stringBuilder = new StringBuilder();
        File file = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootDir");
        String completePath = stringBuilder.append(file.getAbsolutePath()).append(File.separator).append("cadxapmsdk").append(File.separator).append("logger.txt").toString();
        File logFile = new File(completePath);
        finalPath = completePath;
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
    }

    static {
        Companion = new Companion(null);
        finalPath = "";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/MyPlugin$Companion;", "", "()V", "finalPath", "", "getFinalPath", "()Ljava/lang/String;", "setFinalPath", "(Ljava/lang/String;)V", "sdk-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getFinalPath() {
            return finalPath;
        }

        public final void setFinalPath(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            finalPath = string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

