/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.ca.dxapm.sdk.gradle.plugin.CADxAPMTransformer;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtension;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtensionTask;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.XmlParser;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0002\u00a8\u0006\u000b"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/CADxAPMPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "configureCADxAPMExtension", "readXmlProperties", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;", "Companion", "sdk-gradle-plugin"})
public final class CADxAPMPlugin
implements Plugin<Project> {
    @NotNull
    public static final String PLUGIN_NAME = "CADxAPMPlugin";
    @Nullable
    private static CADxAPMExtension extension;
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getLogger().log(LogLevel.INFO, "CADxAPMPlugin applied");
        Object ext = project.getExtensions().findByName("android");
        if (ext != null && ext instanceof AppExtension) {
            project.getLogger().log(LogLevel.INFO, "Registering transform");
            project.getExtensions().create("cadxapmsdk", CADxAPMExtension.class, new Object[]{project.getObjects()});
            CADxAPMExtension cADxAPMExtension = (CADxAPMExtension)project.getExtensions().findByType(CADxAPMExtension.class);
            if (cADxAPMExtension == null) {
                cADxAPMExtension = new CADxAPMExtension(project.getObjects());
            }
        } else {
            throw (Throwable)new Exception("CA DX APM SDK plugin may only be applied to Android app projects");
        }
        XmlParser xmlParser = this.readXmlProperties(project);
        this.configureCADxAPMExtension(project);
        ((AppExtension)ext).registerTransform((Transform)new CADxAPMTransformer(project, xmlParser), new Object[0]);
        project.getRootDir();
    }

    private final void configureCADxAPMExtension(Project project) {
        block0: {
            AppExtension android = (AppExtension)project.getExtensions().findByType(AppExtension.class);
            Logger.Companion.debug("setting up variant");
            AppExtension appExtension = android;
            if (appExtension == null || (appExtension = appExtension.getApplicationVariants()) == null) break block0;
            appExtension.configureEach((Action)new Action<ApplicationVariant>(project){
                final /* synthetic */ Project $project;

                public final void execute(ApplicationVariant it) {
                    StringBuilder stringBuilder = new StringBuilder().append("variant ......");
                    ApplicationVariant applicationVariant = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)applicationVariant, (String)"it");
                    Logger.Companion.debug(stringBuilder.append(applicationVariant.getName()).append(" ..").toString());
                    Logger.Companion.debug("configureVariant......");
                    CADxAPMExtensionTask plistTask = (CADxAPMExtensionTask)this.$project.getTasks().create("CADxAPMSDKConfig-" + it.getName(), CADxAPMExtensionTask.class, new Object[]{this.$project, it.getName()});
                    try {
                        Task buildTask = it.getAssemble();
                        Logger.Companion.debug("created task CADxAPMSDKConfig-" + it.getName() + ".... " + (Object)((Object)plistTask) + ", build task " + buildTask);
                        buildTask.dependsOn(new Object[]{plistTask});
                    }
                    catch (Exception e) {
                        Logger.Companion.printCritical("CA DX APM SDK can not be configured.. Error creating configuration task " + e);
                    }
                }
                {
                    this.$project = project;
                }
            });
        }
    }

    @NotNull
    public final XmlParser readXmlProperties(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        XmlParser xmlParser = null;
        StringBuilder stringBuilder = new StringBuilder();
        File file = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootDir");
        String completePath = stringBuilder.append(file.getAbsolutePath()).append(File.separator).append("cadxapmsdk").append(File.separator).append("android.xml").toString();
        Logger.Companion.print("Reading android.xml file");
        try {
            File xmlFile = new File(completePath);
            if (!xmlFile.exists()) {
                Logger.Companion.printCritical(" Missing rule file <project>/cadxapmsdk/android.xml  ");
                throw (Throwable)new Exception("Missing rule file <project>/cadxapmsdk/android.xml  ");
            }
            xmlParser = new XmlParser();
            xmlParser.parseXML(completePath);
        }
        catch (Exception e) {
            throw (Throwable)new Exception("CA DX APM SDK can not be configured. " + e);
        }
        return xmlParser;
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/CADxAPMPlugin$Companion;", "", "()V", "PLUGIN_NAME", "", "extension", "Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;", "getExtension", "()Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;", "setExtension", "(Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;)V", "sdk-gradle-plugin"})
    public static final class Companion {
        @Nullable
        public final CADxAPMExtension getExtension() {
            return extension;
        }

        public final void setExtension(@Nullable CADxAPMExtension cADxAPMExtension) {
            extension = cADxAPMExtension;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

