/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin.extension;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.utils.FileUtils;
import com.ca.dxapm.sdk.gradle.plugin.CADxAPMPlugin;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtension;
import com.ca.dxapm.sdk.gradle.plugin.extension.VariantConfig;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public class CADxAPMExtensionTask
extends DefaultTask {
    String plistAbsolutePath;
    String variantName;
    Project parentProject;

    @Inject
    public CADxAPMExtensionTask(Project project, String variant) {
        this.parentProject = project;
        this.variantName = variant;
    }

    @TaskAction
    public void setupPlist() throws Exception {
        Logger.debug("Configuring CAExtension for variant " + this.variantName);
        CADxAPMExtension ext = (CADxAPMExtension)this.parentProject.getExtensions().getByType(CADxAPMExtension.class);
        Logger.debug(" CAExtension logInstrumentation " + ext.logInstrumentation);
        CADxAPMPlugin.Companion.setExtension(ext);
        this.createLogFile(ext);
        String globalPlist = ext.plist;
        if (globalPlist == null) {
            Logger.printCritical("CA DX APM SDK is enabled, but no plist is specified. Please specify the plist value in the 'cadxapmsdk' block in build.gradle file");
            throw new Exception("CA DX APM SDK is enabled, but no plist is specified. Please specify the plist value in the 'cadxapmsdk' block in build.gradle file");
        }
        Logger.debug("Global plist " + globalPlist);
        if (!this.isVariantEnabled(this.variantName, ext)) {
            Logger.printCritical("CA DX APM SDK is disabled for variant " + this.variantName + ", based on configuration ");
            return;
        }
        String variantPlist = this.getVariantPlist(this.variantName, ext);
        if (variantPlist != null) {
            Logger.debug("Using Variant plist " + variantPlist);
        }
        String plistToUse = variantPlist != null ? variantPlist : globalPlist;
        AppExtension androidExt = (AppExtension)this.parentProject.getExtensions().getByType(AppExtension.class);
        String[] assetsPath = new String[]{null};
        ((AndroidSourceSet)androidExt.getSourceSets().getByName("main")).getAssets().getSrcDirs().forEach(item -> {
            assetsPath[0] = item.getAbsolutePath();
        });
        Logger.debug(" @ CAExtensionTask plistpath: " + plistToUse + ", assetPath: " + assetsPath[0]);
        File plistPath = new File(plistToUse);
        File assetsPathToCopy = new File(assetsPath[0] + "/conf/" + plistPath.getName());
        File assetsConfigFolder = new File(assetsPath[0] + "/conf/");
        if (assetsConfigFolder.exists() && assetsConfigFolder.isDirectory()) {
            File[] listFiles = assetsConfigFolder.listFiles();
            try {
                for (File file : listFiles) {
                    file.delete();
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                Files.createDirectories(Paths.get(assetsConfigFolder.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            catch (Exception e) {
                Logger.printCritical("CA DX APM SDK can not be configured. Error creating folder " + assetsConfigFolder.getAbsolutePath() + ". Reason " + e);
                throw new Exception("CA DX APM SDK can not be configured.. Error creating folder " + assetsConfigFolder.getAbsolutePath() + ". Reason " + e);
            }
        }
        if (!plistPath.exists()) {
            throw new Exception("CA DX APM SDK can not be configured. Provided plist file does not exists:" + plistToUse);
        }
        if (!plistToUse.endsWith("camdo.plist")) {
            throw new Exception("CA DX APM SDK can not be configured. Provided plist does not have a valid name. The file name should end with 'camdo.plist': '" + plistToUse + "'");
        }
        try {
            FileUtils.copyFile((File)plistPath, (File)assetsPathToCopy);
        }
        catch (Exception e) {
            throw new Exception("CA DX APM SDK can not be configured. Error copying plist file '" + this.plistAbsolutePath + "' to the assets folder:  " + assetsPathToCopy.getAbsolutePath() + ". Reason " + e);
        }
    }

    private void createLogFile(CADxAPMExtension ext) {
        String path = this.parentProject.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk" + File.separator + "logger.txt";
        try {
            File logFile = new File(path);
            if (ext.logInstrumentation && !logFile.exists()) {
                logFile.createNewFile();
            }
            Logger.debugFilePath = path;
        }
        catch (Exception e) {
            System.out.println("Error creating logfile" + path);
        }
    }

    private String getVariantPlist(String currentVariant, CADxAPMExtension ext) {
        Logger.debug("@getVariantPlist getting  plist for variant " + currentVariant);
        for (VariantConfig varName : ext.variants) {
            Logger.debug("checking variant " + varName.getName() + ", plist " + varName.getPlist());
            if (!currentVariant.equalsIgnoreCase(varName.getName())) continue;
            return varName.getPlist();
        }
        return null;
    }

    private boolean isVariantEnabled(String currentVariant, CADxAPMExtension ext) {
        Logger.debug("@isVariantEnabled getting  plist for variant " + currentVariant);
        for (VariantConfig varName : ext.variants) {
            Logger.debug("checking variant " + varName.getName() + ", plist " + varName.getPlist());
            if (!currentVariant.equalsIgnoreCase(varName.getName())) continue;
            return varName.isEnabled();
        }
        return true;
    }
}

