/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.AppExtension;
import com.ca.dxapm.sdk.gradle.plugin.TransformConfig;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtension;
import com.ca.dxapm.sdk.gradle.plugin.extension.VariantConfig;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.XmlParser;
import com.ca.dxapm.sdk.gradle.plugin.transformerimpls.CADxAPMTransformerFacade;
import com.ca.dxapm.sdk.gradle.plugin.transformerimpls.CADxAPMTransformerImpl;
import com.ca.dxapm.sdk.gradle.plugin.transformerimpls.NoOpTransformImpl;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/CADxAPMTransformer;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "xmlParser", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;", "(Lorg/gradle/api/Project;Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "scopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "typeClasses", "Lcom/android/build/api/transform/QualifiedContent$DefaultContentType;", "checkBootclasspaths", "", "Ljava/io/File;", "bootClassPaths", "getInputTypes", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getScopes", "", "isIncremental", "", "isVariantEnabled", "currentVariant", "ext", "Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "sdk-gradle-plugin"})
public final class CADxAPMTransformer
extends Transform {
    private final org.gradle.api.logging.Logger logger;
    private final Set<QualifiedContent.DefaultContentType> typeClasses;
    private final Set<QualifiedContent.Scope> scopes;
    private final Project project;
    private final XmlParser xmlParser;

    @NotNull
    public String getName() {
        String string = CADxAPMTransformer.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CADxAPMTransformer::class.java.simpleName");
        return string;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.typeClasses;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        return CollectionsKt.toMutableSet((Iterable)this.scopes);
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        String currentExecutingVariant;
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        long start = System.currentTimeMillis();
        CADxAPMExtension cADxAPMExtension = (CADxAPMExtension)this.project.getExtensions().findByType(CADxAPMExtension.class);
        if (cADxAPMExtension == null) {
            cADxAPMExtension = new CADxAPMExtension(this.project.getObjects());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)cADxAPMExtension, (String)"project.extensions.findB\u2026xtension(project.objects)");
        CADxAPMExtension ext = cADxAPMExtension;
        Object object = this.project.getExtensions().findByName("android");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.AppExtension");
        }
        AppExtension appExtension = (AppExtension)object;
        List ignores = CollectionsKt.listOf((Object[])new Regex[]{new Regex("com/ca/android/bluetooth.*"), new Regex("com/ca/android/integrations.*"), new Regex("com/ca/mdo.*"), new Regex("com/ca/org.*"), new Regex("com/ca/integration.*")});
        if (ext.ignoreClasses != null) {
            if (ext.ignoreClasses == null) {
                Intrinsics.throwNpe();
            }
            for (String ignoreClass : ext.ignoreClasses) {
                Logger.Companion.print("Ignoring classes : " + ignoreClass);
                Collection collection = ignores;
                String string = ignoreClass;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ignoreClass");
                ignores = CollectionsKt.plus((Collection)collection, (Object)new Regex(string));
            }
        }
        List list = appExtension.getBootClasspath();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"appExtension.bootClasspath");
        List<File> bootClassPaths = this.checkBootclasspaths(list);
        TransformConfig config = new TransformConfig(transformInvocation, bootClassPaths, ignores, ext);
        Context context = transformInvocation.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"transformInvocation.context");
        String string = currentExecutingVariant = context.getVariantName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentExecutingVariant");
        CADxAPMTransformerFacade transformerFacade = this.isVariantEnabled(string, ext) ? (CADxAPMTransformerFacade)new CADxAPMTransformerImpl(config, this.xmlParser) : (CADxAPMTransformerFacade)new NoOpTransformImpl(config, this.xmlParser);
        transformerFacade.doIt();
        long end = System.currentTimeMillis();
        this.logger.info("Transform took " + (end - start) + "ms");
    }

    private final List<File> checkBootclasspaths(List<? extends File> bootClassPaths) {
        List bootClassPathsTemp = bootClassPaths;
        if (bootClassPathsTemp.size() == 1) {
            String legacyLibraryPath;
            String string = legacyLibraryPath = bootClassPaths.get(0).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"legacyLibraryPath");
            legacyLibraryPath = StringsKt.replace$default((String)string, (String)"android.jar", (String)"optional/org.apache.http.legacy.jar", (boolean)false, (int)4, null);
            bootClassPathsTemp = CollectionsKt.plus((Collection)bootClassPaths, (Object)new File(legacyLibraryPath));
        }
        return bootClassPathsTemp;
    }

    private final boolean isVariantEnabled(String currentVariant, CADxAPMExtension ext) {
        NamedDomainObjectContainer<VariantConfig> namedDomainObjectContainer = ext.variants;
        Intrinsics.checkExpressionValueIsNotNull(namedDomainObjectContainer, (String)"ext.variants");
        Iterable $this$forEach$iv = (Iterable)namedDomainObjectContainer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariantConfig it = (VariantConfig)element$iv;
            boolean bl = false;
            VariantConfig variantConfig = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)variantConfig, (String)"it");
            if (!StringsKt.equals((String)currentVariant, (String)variantConfig.getName(), (boolean)true)) continue;
            Boolean isEnabled = ext.vairantStatusMap.get(currentVariant);
            if (isEnabled != null) {
                return isEnabled;
            }
            return true;
        }
        return true;
    }

    public CADxAPMTransformer(@NotNull Project project, @NotNull XmlParser xmlParser) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)xmlParser, (String)"xmlParser");
        this.project = project;
        this.xmlParser = xmlParser;
        this.logger = Logging.getLogger(CADxAPMTransformer.class);
        this.typeClasses = SetsKt.setOf((Object)QualifiedContent.DefaultContentType.CLASSES);
        this.scopes = SetsKt.setOf((Object[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES});
    }
}

