/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin.instrument;

import com.ca.dxapm.sdk.gradle.plugin.InstrumentationConfig;
import com.ca.dxapm.sdk.gradle.plugin.dumps.MethodDumps;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.MethodDetails;
import com.ca.dxapm.sdk.gradle.plugin.parser.ReplaceUtil;
import com.ca.dxapm.sdk.gradle.plugin.parser.XmlParser;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.AdviceAdapter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 32\u00020\u00012\u00020\u0002:\u000234B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJG\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010(\u001a\u00020\u00102\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\"H\u0016J?\u0010-\u001a\u00020.2\u0006\u0010%\u001a\u00020$2\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\u00102\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010*H\u0016\u00a2\u0006\u0002\u00102R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/instrument/CaMaaInstrumentationVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "Lorg/objectweb/asm/Opcodes;", "classVisitor", "config", "Lcom/ca/dxapm/sdk/gradle/plugin/InstrumentationConfig;", "xmlParser", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;", "(Lorg/objectweb/asm/ClassVisitor;Lcom/ca/dxapm/sdk/gradle/plugin/InstrumentationConfig;Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;)V", "canDisplay", "", "getCanDisplay", "()Z", "setCanDisplay", "(Z)V", "classNameTemp", "", "getClassNameTemp", "()Ljava/lang/String;", "setClassNameTemp", "(Ljava/lang/String;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "skipTheFile", "getSkipTheFile", "setSkipTheFile", "stubReplacement", "getStubReplacement", "setStubReplacement", "superClassNameTemp", "getSuperClassNameTemp", "setSuperClassNameTemp", "visit", "", "version", "", "access", "className", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnd", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "methodName", "methodDesc", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "Companion", "MyMethodVisitor", "sdk-gradle-plugin"})
public final class CaMaaInstrumentationVisitor
extends ClassVisitor
implements Opcodes {
    private boolean canDisplay;
    private boolean stubReplacement;
    @NotNull
    private String classNameTemp;
    @NotNull
    private String superClassNameTemp;
    private boolean skipTheFile;
    private final org.gradle.api.logging.Logger logger;
    private final ClassVisitor classVisitor;
    private final InstrumentationConfig config;
    private final XmlParser xmlParser;
    private static final int ASM_API_VERSION = 458752;
    @NotNull
    private static String clsNme;
    private static boolean isModified;
    public static final Companion Companion;

    public final boolean getCanDisplay() {
        return this.canDisplay;
    }

    public final void setCanDisplay(boolean bl) {
        this.canDisplay = bl;
    }

    public final boolean getStubReplacement() {
        return this.stubReplacement;
    }

    public final void setStubReplacement(boolean bl) {
        this.stubReplacement = bl;
    }

    @NotNull
    public final String getClassNameTemp() {
        return this.classNameTemp;
    }

    public final void setClassNameTemp(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.classNameTemp = string;
    }

    @NotNull
    public final String getSuperClassNameTemp() {
        return this.superClassNameTemp;
    }

    public final void setSuperClassNameTemp(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.superClassNameTemp = string;
    }

    public final boolean getSkipTheFile() {
        return this.skipTheFile;
    }

    public final void setSkipTheFile(boolean bl) {
        this.skipTheFile = bl;
    }

    public void visit(int version, int access, @NotNull String className, @Nullable String signature, @NotNull String superName, @Nullable String[] interfaces) {
        String newSuperClassName;
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)superName, (String)"superName");
        clsNme = className;
        this.classNameTemp = className;
        String changedSuperClassName = superName;
        this.superClassNameTemp = superName;
        Logger.Companion.print("Instrumenting class " + className);
        if (this.config.getLogVisits()) {
            this.logger.debug("VISITING CLASS " + className);
            this.logger.debug("  signature: " + signature + " superName: " + superName + " interfaces: " + (interfaces != null ? ArraysKt.joinToString$default((Object[])interfaces, null, null, null, (int)0, null, null, (int)63, null) : null));
        }
        if (this.config.isCordova()) {
            if (StringsKt.contains$default((CharSequence)className, (CharSequence)"com/ca/android/app/CaMDOSystemWebViewClient", (boolean)false, (int)2, null)) {
                try {
                    Logger.Companion.print("Processing CaMDOSystemWebViewClient. Changing super class");
                    changedSuperClassName = "org/apache/cordova/engine/SystemWebViewClient";
                    isModified = true;
                    Logger.Companion.print("Instrumenting super class:: " + className + " :: new super :: " + changedSuperClassName);
                }
                catch (Exception e) {
                    Logger.Companion.printCritical("Skipping Processing of CaMDOSystemWebViewClient, since this is not a cordova app " + e);
                }
            } else if (StringsKt.contains$default((CharSequence)className, (CharSequence)"com/ca/android/app", (boolean)false, (int)2, null)) {
                Logger.Companion.print("Processing stub instrumentation");
                this.stubReplacement = true;
            }
        } else if (StringsKt.contains$default((CharSequence)className, (CharSequence)"com/ca/android/app", (boolean)false, (int)2, null)) {
            Logger.Companion.print("Processing stub instrumentation");
            this.stubReplacement = true;
        }
        if ((!this.stubReplacement || StringsKt.contains$default((CharSequence)superName, (CharSequence)"com/ca/android/integrations/crosswalk/IStub_XWalkGetBitmapCallbackInternal", (boolean)false, (int)2, null)) && (newSuperClassName = ReplaceUtil.Companion.processClassReplacements(this.xmlParser.getClassReplacementList(), superName)) != null) {
            changedSuperClassName = newSuperClassName;
            isModified = true;
            Logger.Companion.print("Instrumenting super class:: " + className + " :: new super :: " + changedSuperClassName);
        }
        this.skipTheFile = ReplaceUtil.Companion.checkFileSkip(this.xmlParser.getMethodReplacementList(), className);
        super.visit(version, access, className, signature, changedSuperClassName, interfaces);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String methodName, @NotNull String methodDesc, @Nullable String signature, @Nullable String[] exceptions) {
        MethodVisitor mv;
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)methodDesc, (String)"methodDesc");
        String newMethodName = methodName;
        String newMethodDesc = methodDesc;
        if (this.config.getLogVisits()) {
            this.logger.debug("Visit method: " + methodName + " desc: " + methodDesc + " signature: " + signature + " exceptions: " + (exceptions != null ? ArraysKt.joinToString$default((Object[])exceptions, null, null, null, (int)0, null, null, (int)63, null) : null));
        }
        if (!this.stubReplacement) {
            if (StringsKt.equals((String)methodName, (String)"build", (boolean)true) && StringsKt.equals((String)methodDesc, (String)"()Lokhttp3/OkHttpClient;", (boolean)true) && !this.config.getDisableHttp()) {
                isModified = true;
                newMethodName = "org_build";
            } else if (methodName.equals("onResume") && StringsKt.endsWith((String)this.classNameTemp, (String)"android/support/v4/app/Fragment", (boolean)true) && !this.config.getDisableUI()) {
                isModified = true;
                newMethodName = "org_onResume";
            } else if (methodName.equals("onPause") && StringsKt.endsWith((String)this.classNameTemp, (String)"android/support/v4/app/Fragment", (boolean)true) && !this.config.getDisableUI()) {
                isModified = true;
                newMethodName = "org_onPause";
            }
        } else {
            MethodDetails updatedMethodDetails = ReplaceUtil.Companion.processSpecialReplacement(this.xmlParser.getSpecialReplacementList(), "", methodDesc);
            if (updatedMethodDetails != null) {
                isModified = true;
                newMethodDesc = updatedMethodDetails.getDesc();
            }
        }
        MethodVisitor methodVisitor = mv = super.visitMethod(access, newMethodName, newMethodDesc, signature, exceptions);
        Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"mv");
        return (MethodVisitor)new MyMethodVisitor(458752, methodVisitor, access, newMethodName, newMethodDesc);
    }

    public void visitEnd() {
        try {
            if (StringsKt.contains((CharSequence)this.classNameTemp, (CharSequence)"okhttp3/OkHttpClient$Builder", (boolean)true) && !this.config.getDisableHttp()) {
                new MethodDumps().OkHttpBuildMethod(this.classVisitor);
            } else if (StringsKt.endsWith((String)this.classNameTemp, (String)"android/support/v4/app/Fragment", (boolean)true) && !this.config.getDisableUI()) {
                new MethodDumps().fragmentOnPause(this.classVisitor);
                new MethodDumps().fragmentOnResume(this.classVisitor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.visitEnd();
    }

    public CaMaaInstrumentationVisitor(@NotNull ClassVisitor classVisitor, @NotNull InstrumentationConfig config, @NotNull XmlParser xmlParser) {
        Intrinsics.checkParameterIsNotNull((Object)classVisitor, (String)"classVisitor");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)xmlParser, (String)"xmlParser");
        super(458752, classVisitor);
        this.classVisitor = classVisitor;
        this.config = config;
        this.xmlParser = xmlParser;
        this.classNameTemp = "";
        this.superClassNameTemp = "";
        this.logger = Logging.getLogger(CaMaaInstrumentationVisitor.class);
    }

    static {
        Companion = new Companion(null);
        clsNme = "";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/instrument/CaMaaInstrumentationVisitor$MyMethodVisitor;", "Lorg/objectweb/asm/commons/AdviceAdapter;", "api", "", "mv", "Lorg/objectweb/asm/MethodVisitor;", "access", "methodName", "", "methodDesc", "(Lcom/ca/dxapm/sdk/gradle/plugin/instrument/CaMaaInstrumentationVisitor;ILorg/objectweb/asm/MethodVisitor;ILjava/lang/String;Ljava/lang/String;)V", "visitMethodInsn", "", "opcode", "owner", "name", "desc", "itf", "", "sdk-gradle-plugin"})
    private final class MyMethodVisitor
    extends AdviceAdapter {
        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (CaMaaInstrumentationVisitor.this.config.getLogVisits()) {
                Logger.Companion.print("visitMethodInsn opcode: " + opcode + " owner: " + owner + " name: " + name + " desc: " + desc);
                CaMaaInstrumentationVisitor.this.logger.debug("visitMethodInsn opcode: " + opcode + " owner: " + owner + " name: " + name + " desc: " + desc);
            }
            if (!CaMaaInstrumentationVisitor.this.getStubReplacement()) {
                MethodDetails regExUpdatedMethod;
                MethodDetails updatedMethodDetails = regExUpdatedMethod = ReplaceUtil.Companion.processRegExReplacement(CaMaaInstrumentationVisitor.this.xmlParser.getRegExReplacementList(), opcode, owner, name, desc, CaMaaInstrumentationVisitor.this.getSuperClassNameTemp());
                if (!CaMaaInstrumentationVisitor.this.getSkipTheFile()) {
                    MethodDetails methodDetails = regExUpdatedMethod;
                    MethodDetails methodDetails2 = regExUpdatedMethod;
                    MethodDetails methodDetails3 = regExUpdatedMethod;
                    MethodDetails methodDetails4 = regExUpdatedMethod;
                    updatedMethodDetails = ReplaceUtil.Companion.processsMethodReplacement(CaMaaInstrumentationVisitor.this.xmlParser.getMethodReplacementList(), methodDetails != null ? Integer.valueOf(methodDetails.getOpcodeInfo()) : null, methodDetails2 != null ? methodDetails2.getOwner() : null, methodDetails3 != null ? methodDetails3.getName() : null, methodDetails4 != null ? methodDetails4.getDesc() : null);
                }
                if (updatedMethodDetails != null) {
                    super.visitMethodInsn(updatedMethodDetails.getOpcodeInfo(), updatedMethodDetails.getOwner(), updatedMethodDetails.getName(), updatedMethodDetails.getDesc(), false);
                } else if (regExUpdatedMethod != null) {
                    super.visitMethodInsn(opcode, regExUpdatedMethod.getOwner(), name, desc, itf);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            } else {
                Logger.Companion.print("Processing stub class insrumentation");
                MethodDetails updatedMethodDetails = ReplaceUtil.Companion.processSpecialReplacement(CaMaaInstrumentationVisitor.this.xmlParser.getSpecialReplacementList(), owner, desc);
                if (updatedMethodDetails != null) {
                    super.visitMethodInsn(opcode, updatedMethodDetails.getOwner(), name, updatedMethodDetails.getDesc(), itf);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        }

        public MyMethodVisitor(@NotNull int api, MethodVisitor mv, @NotNull int access, @NotNull String methodName, String methodDesc) {
            Intrinsics.checkParameterIsNotNull((Object)mv, (String)"mv");
            Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
            Intrinsics.checkParameterIsNotNull((Object)methodDesc, (String)"methodDesc");
            super(api, mv, access, methodName, methodDesc);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/instrument/CaMaaInstrumentationVisitor$Companion;", "", "()V", "ASM_API_VERSION", "", "clsNme", "", "getClsNme", "()Ljava/lang/String;", "setClsNme", "(Ljava/lang/String;)V", "isModified", "", "()Z", "setModified", "(Z)V", "sdk-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getClsNme() {
            return clsNme;
        }

        public final void setClsNme(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            clsNme = string;
        }

        public final boolean isModified() {
            return isModified;
        }

        public final void setModified(boolean bl) {
            isModified = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

