/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin.parser;

import com.ca.dxapm.sdk.gradle.plugin.instrument.CaMaaInstrumentationVisitor;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.MethodDetails;
import com.ca.dxapm.sdk.gradle.plugin.parser.ReplacementElement;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/parser/ReplaceUtil;", "", "()V", "Companion", "sdk-gradle-plugin"})
public final class ReplaceUtil {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u001e\u0010\r\u001a\u0004\u0018\u00010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ>\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tJ(\u0010\u0016\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\tJC\u0010\u0017\u001a\u0004\u0018\u00010\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/parser/ReplaceUtil$Companion;", "", "()V", "checkFileSkip", "", "methodReplacementList", "", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/ReplacementElement;", "className", "", "getOpcodeFromName", "", "name", "processClassReplacements", "classReplacementList", "processRegExReplacement", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/MethodDetails;", "regexReplacementList", "opcode", "owner", "desc", "superClass", "processSpecialReplacement", "processsMethodReplacement", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/ca/dxapm/sdk/gradle/plugin/parser/MethodDetails;", "sdk-gradle-plugin"})
    public static final class Companion {
        @Nullable
        public final String processClassReplacements(@NotNull List<ReplacementElement> classReplacementList, @NotNull String className) {
            Intrinsics.checkParameterIsNotNull(classReplacementList, (String)"classReplacementList");
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            String replacedString = null;
            try {
                for (ReplacementElement replace : classReplacementList) {
                    if (replace.getReplaceFrom() == null || !StringsKt.equals$default((String)replace.getReplaceFrom(), (String)className, (boolean)false, (int)2, null)) continue;
                    replacedString = replace.getReplaceTo();
                    break;
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while class replacement " + className + " :: " + e.getMessage());
            }
            return replacedString;
        }

        public final boolean checkFileSkip(@NotNull List<ReplacementElement> methodReplacementList, @NotNull String className) {
            Intrinsics.checkParameterIsNotNull(methodReplacementList, (String)"methodReplacementList");
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            boolean fileToBeSkipped = false;
            try {
                for (ReplacementElement replace : methodReplacementList) {
                    List skipFile;
                    if (replace.getSkipFiles() == null) continue;
                    String string = replace.getSkipFiles();
                    List list = skipFile = string != null ? StringsKt.split$default((CharSequence)string, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null) : null;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterator iterator = list.iterator();
                    boolean bl = false;
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        String fileToSkip = (String)iterator2.next();
                        if (!StringsKt.contains$default((CharSequence)className, (CharSequence)fileToSkip, (boolean)false, (int)2, null)) continue;
                        fileToBeSkipped = true;
                    }
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while checking file skiping " + className + " :: " + e.getMessage());
            }
            return fileToBeSkipped;
        }

        @Nullable
        public final MethodDetails processsMethodReplacement(@NotNull List<ReplacementElement> methodReplacementList, @Nullable Integer opcode, @Nullable String owner, @Nullable String name, @Nullable String desc) {
            Intrinsics.checkParameterIsNotNull(methodReplacementList, (String)"methodReplacementList");
            MethodDetails methodDetails = new MethodDetails();
            Integer n = opcode;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            methodDetails.setOpcodeInfo(n);
            String string = owner;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            methodDetails.setOwner(string);
            String string2 = name;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            methodDetails.setName(string2);
            String string3 = desc;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            methodDetails.setDesc(string3);
            Logger.Companion.print("Method replacement " + opcode + " :: " + owner + " :: " + name + " :: " + desc);
            try {
                for (ReplacementElement replace : methodReplacementList) {
                    if (!owner.equals(replace.getOwnerFrom()) || !name.equals(replace.getReplaceFrom()) || !desc.equals(replace.getDescFrom())) continue;
                    methodDetails.setOwner(replace.getOwnerTo());
                    methodDetails.setDesc(replace.getDescTo());
                    methodDetails.setName(replace.getReplaceTo());
                    CharSequence charSequence = replace.getMethodTo();
                    boolean bl = false;
                    if (charSequence.length() > 0 && this.getOpcodeFromName(replace.getMethodTo()) != -1) {
                        int newOpcode = this.getOpcodeFromName(replace.getMethodTo());
                        methodDetails.setOpcodeInfo(newOpcode);
                    } else {
                        methodDetails.setOpcodeInfo(opcode);
                    }
                    CaMaaInstrumentationVisitor.Companion.setModified(true);
                    break;
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while method replacement :: " + e.getMessage());
            }
            return methodDetails;
        }

        @Nullable
        public final MethodDetails processRegExReplacement(@NotNull List<ReplacementElement> regexReplacementList, int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, @NotNull String superClass) {
            Intrinsics.checkParameterIsNotNull(regexReplacementList, (String)"regexReplacementList");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull((Object)superClass, (String)"superClass");
            Logger.Companion.print("Replacing REGEX replacement :: " + opcode + " :: " + owner + " :: " + name + " :: " + desc);
            MethodDetails methodDetails = new MethodDetails();
            methodDetails.setOpcodeInfo(opcode);
            methodDetails.setOwner(owner);
            methodDetails.setName(name);
            methodDetails.setDesc(desc);
            try {
                block2: for (ReplacementElement replace : regexReplacementList) {
                    String matcher = replace.getMatcher();
                    if (matcher != null && !StringsKt.equals((String)matcher, (String)superClass, (boolean)true)) continue;
                    for (String pattern : replace.getPatterns()) {
                        int opcodeFrom;
                        List values;
                        CharSequence charSequence = pattern;
                        boolean bl = false;
                        if (!(charSequence.length() > 0) || (values = StringsKt.split$default((CharSequence)pattern, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null)).size() < 2 || (opcodeFrom = this.getOpcodeFromName((String)values.get(0))) != opcode || !StringsKt.equals((String)owner, (String)((String)values.get(1)), (boolean)true)) continue;
                        Logger.Companion.print("Instrumenting REGEX :: " + opcodeFrom + " -- " + owner);
                        MethodDetails methodDetails2 = methodDetails;
                        if (methodDetails2 != null) {
                            methodDetails2.setOwner(replace.getOwnerTo());
                        }
                        CaMaaInstrumentationVisitor.Companion.setModified(true);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while instrumenting REGEX :: " + e.getMessage());
            }
            return methodDetails;
        }

        @Nullable
        public final MethodDetails processSpecialReplacement(@NotNull List<ReplacementElement> regexReplacementList, @Nullable String owner, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull(regexReplacementList, (String)"regexReplacementList");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            String ownerTmp = null;
            String descTmp = null;
            MethodDetails methodDetails = null;
            try {
                Logger.Companion.print("Instrumenting special REGEX :: " + owner + " :: " + desc);
                for (ReplacementElement replace : regexReplacementList) {
                    String matcher = replace.getMatcher();
                    if (matcher != null) continue;
                    for (String pattern : replace.getPatterns()) {
                        if (owner != null && StringsKt.contains$default((CharSequence)owner, (CharSequence)pattern, (boolean)false, (int)2, null)) {
                            if (ownerTmp == null) {
                                ownerTmp = owner;
                            }
                            ownerTmp = StringsKt.replace$default((String)ownerTmp, (String)pattern, (String)replace.getReplaceTo(), (boolean)false, (int)4, null);
                        }
                        if (!StringsKt.contains$default((CharSequence)desc, (CharSequence)pattern, (boolean)false, (int)2, null)) continue;
                        if (descTmp == null) {
                            descTmp = desc;
                        }
                        descTmp = StringsKt.replace$default((String)descTmp, (String)pattern, (String)replace.getReplaceTo(), (boolean)false, (int)4, null);
                    }
                }
                if (ownerTmp != null || descTmp != null) {
                    methodDetails = new MethodDetails();
                    String string = owner;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    methodDetails.setOwner(string);
                    methodDetails.setDesc(desc);
                    if (ownerTmp != null) {
                        methodDetails.setOwner(ownerTmp);
                    }
                    if (descTmp != null) {
                        methodDetails.setDesc(descTmp);
                    }
                    CaMaaInstrumentationVisitor.Companion.setModified(true);
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while special instrumentation :: " + e.getMessage());
            }
            return methodDetails;
        }

        public final int getOpcodeFromName(@NotNull String name) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            switch (name) {
                case "invoke-direct": {
                    n = 183;
                    break;
                }
                case "invoke-static": {
                    n = 184;
                    break;
                }
                case "invoke-virtual": {
                    n = 182;
                    break;
                }
                case "invoke-special": {
                    n = 183;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            return n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

