/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.ca.dxapm.sdk.gradle.plugin.CADxAPMTransformer;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtension;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtensionTask;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.XmlParser;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002\u00a8\u0006\u000e"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/CADxAPMPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "configureCADxAPMExtension", "extractResourcesToLocalPath", "destFolder", "", "readXmlProperties", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;", "Companion", "sdk-gradle-plugin"})
public final class CADxAPMPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PLUGIN_NAME = "CADxAPMPlugin";
    @Nullable
    private static CADxAPMExtension extension;

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getLogger().log(LogLevel.INFO, "CADxAPMPlugin applied");
        Object ext = project.getExtensions().findByName("android");
        if (ext != null && ext instanceof AppExtension) {
            project.getLogger().log(LogLevel.INFO, "Registering transform");
            Object[] objectArray = new Object[]{project.getObjects()};
            project.getExtensions().create("cadxapmsdk", CADxAPMExtension.class, objectArray);
            CADxAPMExtension cADxAPMExtension = (CADxAPMExtension)project.getExtensions().findByType(CADxAPMExtension.class);
            if (cADxAPMExtension == null) {
                cADxAPMExtension = new CADxAPMExtension(project.getObjects());
            }
        } else {
            throw new Exception("CA DX APM SDK plugin may only be applied to Android app projects");
        }
        XmlParser xmlParser = this.readXmlProperties(project);
        this.configureCADxAPMExtension(project);
        ((AppExtension)ext).registerTransform((Transform)new CADxAPMTransformer(project, xmlParser), new Object[0]);
        project.getRootDir();
    }

    private final void configureCADxAPMExtension(Project project) {
        AppExtension android = (AppExtension)project.getExtensions().findByType(AppExtension.class);
        Logger.Companion.debug("setting up variant");
        AppExtension appExtension = android;
        if (appExtension != null) {
            DomainObjectSet domainObjectSet = appExtension.getApplicationVariants();
            if (domainObjectSet != null) {
                domainObjectSet.configureEach(arg_0 -> CADxAPMPlugin.configureCADxAPMExtension$lambda-1(project, arg_0));
            }
        }
    }

    @NotNull
    public final XmlParser readXmlProperties(@NotNull Project project) {
        XmlParser xmlParser;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            xmlParser = null;
            String completePath = project.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk" + File.separator + "android.xml";
            Logger.Companion.print("Reading android.xml file");
            try {
                File xmlFile = new File(completePath);
                if (xmlFile.exists()) {
                    xmlParser = new XmlParser();
                    xmlParser.parseXML(completePath);
                    break block4;
                }
                Logger.Companion.printCritical(" Missing rule file <project>/cadxapmsdk/android.xml , Extracting from Jar");
                this.extractResourcesToLocalPath(project.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk");
                if (xmlFile.exists()) {
                    xmlParser = new XmlParser();
                    xmlParser.parseXML(completePath);
                    break block4;
                }
                Logger.Companion.printCritical(" Missing rule file <project>/cadxapmsdk/android.xml ");
                throw new Exception("Missing rule file <project>/cadxapmsdk/android.xml  ");
            }
            catch (Exception e) {
                throw new Exception(Intrinsics.stringPlus((String)"CA DX APM SDK can not be configured. ", (Object)e));
            }
        }
        return xmlParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void extractResourcesToLocalPath(String destFolder) {
        File parentDir = null;
        parentDir = new File(destFolder);
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        Closeable closeable = CADxAPMPlugin.class.getClassLoader().getResourceAsStream("android.xml");
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"CADxAPMPlugin::class.jav\u2026ceAsStream(\"android.xml\")");
        InputStream ins = closeable;
        closeable = ins;
        Object object = null;
        try {
            Closeable input = closeable;
            boolean bl = false;
            long l = Files.copy(input, Paths.get(parentDir.getAbsolutePath() + File.separator + "android.xml", new String[0]), new CopyOption[0]);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        ins.close();
        object = CADxAPMPlugin.class.getClassLoader().getResourceAsStream("CaMDOInterceptor.js");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CADxAPMPlugin::class.jav\u2026am(\"CaMDOInterceptor.js\")");
        Object ins1 = object;
        object = (Closeable)ins1;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)object;
            boolean bl = false;
            long l = Files.copy(input, Paths.get(parentDir.getAbsolutePath() + File.separator + "CaMDOInterceptor.js", new String[0]), new CopyOption[0]);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        ((InputStream)ins1).close();
    }

    private static final void configureCADxAPMExtension$lambda-1$lambda-0(CADxAPMExtensionTask $plistTask, Task it) {
        Logger.Companion.debug("created task CADxAPMSDKConfig-" + it.getName() + ".... " + (Object)((Object)$plistTask) + ", build task " + it);
        Object[] objectArray = new Object[]{$plistTask};
        it.dependsOn(objectArray);
    }

    private static final void configureCADxAPMExtension$lambda-1(Project $project, ApplicationVariant it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Logger.Companion.debug("configureVariant......" + it.getName() + "..");
        Object[] objectArray = new Object[]{$project, it.getName()};
        CADxAPMExtensionTask plistTask = (CADxAPMExtensionTask)$project.getTasks().create(Intrinsics.stringPlus((String)"CADxAPMSDKConfig-", (Object)it.getName()), CADxAPMExtensionTask.class, objectArray);
        try {
            it.getPreBuildProvider().configure(arg_0 -> CADxAPMPlugin.configureCADxAPMExtension$lambda-1$lambda-0(plistTask, arg_0));
        }
        catch (Exception e) {
            Logger.Companion.printCritical(Intrinsics.stringPlus((String)"CA DX APM SDK can not be configured.. Error creating configuration task ", (Object)e));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/CADxAPMPlugin$Companion;", "", "()V", "PLUGIN_NAME", "", "extension", "Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;", "getExtension", "()Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;", "setExtension", "(Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;)V", "sdk-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CADxAPMExtension getExtension() {
            return extension;
        }

        public final void setExtension(@Nullable CADxAPMExtension cADxAPMExtension) {
            extension = cADxAPMExtension;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

