/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin.parser;

import com.ca.dxapm.sdk.gradle.plugin.constants.Constants;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.ReplacementElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020)J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020)J\u0006\u0010.\u001a\u00020#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;", "", "()V", "CLASS_REPLACEMENT_NODE", "", "METHOD_REPLACEMENT_NODE", "REGEX_REPLACEMENT_NODE", "SPECIAL_REPLACEMENT_NODE", "XML_ATTRIBUTE_TARGETFILE", "XML_NODE_DESC_FROM", "XML_NODE_DESC_TO", "XML_NODE_FILE", "XML_NODE_FROM", "XML_NODE_INSERT_AFTER", "XML_NODE_INSERT_WHAT", "XML_NODE_MATCHER", "XML_NODE_METHODTYPE_FROM", "XML_NODE_METHODTYPE_TO", "XML_NODE_OWNER_FROM", "XML_NODE_OWNER_TO", "XML_NODE_PATTERN", "XML_NODE_SKIP_FILE", "XML_NODE_TO", "XML_NODE_WRAPPER_METHOD", "classReplaceData", "", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/ReplacementElement;", "methodReplaceData", "regexReplaceData", "specialReplaceData", "getClassReplacementList", "getMethodReplacementList", "getRegExReplacementList", "getSpecialReplacementList", "initilize", "", "parseXML", "", "smaliReplacementXMLFile", "setClassReplacementList", "classReplacementList", "Lorg/w3c/dom/NodeList;", "setMethodReplacementList", "methodReplacementList", "setRegExReplacementList", "regexReplacementList", "setSpecialReplaceList", "sdk-gradle-plugin"})
public final class XmlParser {
    @NotNull
    private List<ReplacementElement> classReplaceData = new ArrayList();
    @NotNull
    private List<ReplacementElement> methodReplaceData = new ArrayList();
    @NotNull
    private List<ReplacementElement> regexReplaceData = new ArrayList();
    @NotNull
    private List<ReplacementElement> specialReplaceData = new ArrayList();
    @NotNull
    private final String CLASS_REPLACEMENT_NODE;
    @NotNull
    private final String METHOD_REPLACEMENT_NODE;
    @NotNull
    private final String REGEX_REPLACEMENT_NODE;
    @NotNull
    private final String SPECIAL_REPLACEMENT_NODE;
    @NotNull
    private final String XML_NODE_OWNER_FROM;
    @NotNull
    private final String XML_NODE_OWNER_TO;
    @NotNull
    private final String XML_NODE_DESC_FROM;
    @NotNull
    private final String XML_NODE_DESC_TO;
    @NotNull
    private final String XML_NODE_FROM;
    @NotNull
    private final String XML_NODE_TO;
    @NotNull
    private final String XML_NODE_FILE;
    @NotNull
    private final String XML_NODE_MATCHER;
    @NotNull
    private final String XML_NODE_WRAPPER_METHOD;
    @NotNull
    private final String XML_ATTRIBUTE_TARGETFILE;
    @NotNull
    private final String XML_NODE_SKIP_FILE;
    @NotNull
    private final String XML_NODE_INSERT_AFTER;
    @NotNull
    private final String XML_NODE_INSERT_WHAT;
    @NotNull
    private final String XML_NODE_METHODTYPE_FROM;
    @NotNull
    private final String XML_NODE_METHODTYPE_TO;
    @NotNull
    private final String XML_NODE_PATTERN;

    public XmlParser() {
        this.CLASS_REPLACEMENT_NODE = "classReplacement";
        this.METHOD_REPLACEMENT_NODE = "methodReplacement";
        this.REGEX_REPLACEMENT_NODE = "regexReplacement";
        this.SPECIAL_REPLACEMENT_NODE = "specialReplacement";
        this.XML_NODE_OWNER_FROM = "ownerFrom";
        this.XML_NODE_OWNER_TO = "ownerTo";
        this.XML_NODE_DESC_FROM = "descFrom";
        this.XML_NODE_DESC_TO = "descTo";
        this.XML_NODE_FROM = "from";
        this.XML_NODE_TO = "to";
        this.XML_NODE_FILE = "file";
        this.XML_NODE_MATCHER = "matcher";
        this.XML_NODE_WRAPPER_METHOD = "wrapperMethod";
        this.XML_ATTRIBUTE_TARGETFILE = "targetFile";
        this.XML_NODE_SKIP_FILE = "skipFile";
        this.XML_NODE_INSERT_AFTER = "insertAfter";
        this.XML_NODE_INSERT_WHAT = "insertWhat";
        this.XML_NODE_METHODTYPE_FROM = "methodFrom";
        this.XML_NODE_METHODTYPE_TO = "methodTo";
        this.XML_NODE_PATTERN = "pattern";
    }

    public final void initilize() {
        this.classReplaceData = new ArrayList();
        this.methodReplaceData = new ArrayList();
        this.regexReplaceData = new ArrayList();
        this.specialReplaceData = new ArrayList();
    }

    public final boolean parseXML(@NotNull String smaliReplacementXMLFile) {
        Intrinsics.checkNotNullParameter((Object)smaliReplacementXMLFile, (String)"smaliReplacementXMLFile");
        this.initilize();
        if (((CharSequence)smaliReplacementXMLFile).length() == 0) {
            return false;
        }
        try {
            File file = new File(smaliReplacementXMLFile);
            if (!file.exists()) {
                return false;
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            NodeList classReplacementList = doc.getElementsByTagName(this.CLASS_REPLACEMENT_NODE);
            NodeList methodReplacementList = doc.getElementsByTagName(this.METHOD_REPLACEMENT_NODE);
            NodeList regexReplacementList = doc.getElementsByTagName(this.REGEX_REPLACEMENT_NODE);
            Intrinsics.checkNotNullExpressionValue((Object)methodReplacementList, (String)"methodReplacementList");
            this.setMethodReplacementList(methodReplacementList);
            Intrinsics.checkNotNullExpressionValue((Object)classReplacementList, (String)"classReplacementList");
            this.setClassReplacementList(classReplacementList);
            Intrinsics.checkNotNullExpressionValue((Object)regexReplacementList, (String)"regexReplacementList");
            this.setRegExReplacementList(regexReplacementList);
            this.setSpecialReplaceList();
        }
        catch (Exception e) {
            Logger.Companion.print(Intrinsics.stringPlus((String)"Exception parsing xml: class and method nodes ", (Object)e.getMessage()));
            e.printStackTrace();
        }
        return true;
    }

    public final void setRegExReplacementList(@NotNull NodeList regexReplacementList) {
        Intrinsics.checkNotNullParameter((Object)regexReplacementList, (String)"regexReplacementList");
        int n = 0;
        int n2 = regexReplacementList.getLength();
        while (n < n2) {
            int temp;
            Node nNode;
            if ((nNode = regexReplacementList.item(temp = n++)).getNodeType() != 1) continue;
            Node node = nNode;
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element eElement = (Element)node;
            ReplacementElement replace = new ReplacementElement();
            replace.setType(this.REGEX_REPLACEMENT_NODE);
            String replaceFor = eElement.getAttribute("id");
            replace.setReplaceFrom(replaceFor);
            NodeList patternList = ((Element)nNode).getElementsByTagName(this.XML_NODE_PATTERN);
            int n3 = 0;
            int n4 = patternList.getLength();
            while (n3 < n4) {
                int i;
                Node patternNode;
                if ((patternNode = patternList.item(i = n3++)).getNodeType() != 1) continue;
                Node node2 = patternNode;
                if (node2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element patternElement = (Element)node2;
                String pattern = patternElement.getTextContent();
                Collection collection = replace.getPatterns();
                Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"pattern");
                replace.setPatterns(CollectionsKt.plus((Collection)collection, (Object)pattern));
            }
            String ownerTo = null;
            try {
                ownerTo = eElement.getElementsByTagName(this.XML_NODE_OWNER_TO).item(0).getTextContent();
                replace.setOwnerTo(ownerTo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String matcher = null;
            try {
                matcher = eElement.getElementsByTagName(this.XML_NODE_MATCHER).item(0).getTextContent();
                replace.setMatcher(matcher);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.regexReplaceData = CollectionsKt.plus((Collection)this.regexReplaceData, (Object)replace);
        }
    }

    public final void setClassReplacementList(@NotNull NodeList classReplacementList) {
        Intrinsics.checkNotNullParameter((Object)classReplacementList, (String)"classReplacementList");
        int n = 0;
        int n2 = classReplacementList.getLength();
        while (n < n2) {
            int temp;
            Node nNode;
            if ((nNode = classReplacementList.item(temp = n++)).getNodeType() != 1) continue;
            Node node = nNode;
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element eElement = (Element)node;
            ReplacementElement replace = new ReplacementElement();
            replace.setType(this.CLASS_REPLACEMENT_NODE);
            String replaceFor = eElement.getAttribute("id");
            replace.setReplaceFrom(replaceFor);
            String replaceFrom = null;
            try {
                replaceFrom = eElement.getElementsByTagName(this.XML_NODE_FROM).item(0).getTextContent();
                replace.setReplaceFrom(replaceFrom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String replaceTo = null;
            try {
                replaceTo = eElement.getElementsByTagName(this.XML_NODE_TO).item(0).getTextContent();
                replace.setReplaceTo(replaceTo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String skipFiles = null;
            try {
                skipFiles = eElement.getElementsByTagName(this.XML_NODE_SKIP_FILE).item(0).getTextContent();
                replace.setSkipFiles(skipFiles);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String insertAfter = null;
            try {
                insertAfter = eElement.getElementsByTagName(this.XML_NODE_INSERT_AFTER).item(0).getTextContent();
                replace.setInsertAfter(insertAfter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String insertWhat = null;
            try {
                insertWhat = eElement.getElementsByTagName(this.XML_NODE_INSERT_WHAT).item(0).getTextContent();
                replace.setInsertWhat(insertWhat);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String methodFrom = null;
            try {
                methodFrom = eElement.getElementsByTagName(this.XML_NODE_METHODTYPE_FROM).item(0).getTextContent();
                replace.setMethodFrom(methodFrom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String methodTo = null;
            try {
                methodTo = eElement.getElementsByTagName(this.XML_NODE_METHODTYPE_TO).item(0).getTextContent();
                replace.setMethodTo(methodTo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.classReplaceData = CollectionsKt.plus((Collection)this.classReplaceData, (Object)replace);
        }
    }

    public final void setMethodReplacementList(@NotNull NodeList methodReplacementList) {
        Intrinsics.checkNotNullParameter((Object)methodReplacementList, (String)"methodReplacementList");
        int n = 0;
        int n2 = methodReplacementList.getLength();
        while (n < n2) {
            int temp;
            Node nNode;
            if ((nNode = methodReplacementList.item(temp = n++)).getNodeType() != 1) continue;
            Node node = nNode;
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element eElement = (Element)node;
            ReplacementElement replace = new ReplacementElement();
            replace.setType(this.METHOD_REPLACEMENT_NODE);
            String replaceFor = eElement.getAttribute("id");
            replace.setReplaceFrom(replaceFor);
            String replaceFrom = null;
            try {
                replaceFrom = eElement.getElementsByTagName(this.XML_NODE_FROM).item(0).getTextContent();
                replace.setReplaceFrom(replaceFrom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String replaceTo = null;
            try {
                replaceTo = eElement.getElementsByTagName(this.XML_NODE_TO).item(0).getTextContent();
                replace.setReplaceTo(replaceTo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String ownerFrom = null;
            try {
                ownerFrom = eElement.getElementsByTagName(this.XML_NODE_OWNER_FROM).item(0).getTextContent();
                replace.setOwnerFrom(ownerFrom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String ownerTo = null;
            try {
                ownerTo = eElement.getElementsByTagName(this.XML_NODE_OWNER_TO).item(0).getTextContent();
                replace.setOwnerTo(ownerTo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String descFrom = null;
            try {
                descFrom = eElement.getElementsByTagName(this.XML_NODE_DESC_FROM).item(0).getTextContent();
                replace.setDescFrom(descFrom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String descTo = null;
            try {
                descTo = eElement.getElementsByTagName(this.XML_NODE_DESC_TO).item(0).getTextContent();
                replace.setDescTo(descTo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String methodFrom = null;
            try {
                methodFrom = eElement.getElementsByTagName(this.XML_NODE_METHODTYPE_FROM).item(0).getTextContent();
                replace.setMethodFrom(methodFrom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String methodTo = null;
            try {
                methodTo = eElement.getElementsByTagName(this.XML_NODE_METHODTYPE_TO).item(0).getTextContent();
                replace.setMethodTo(methodTo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String skipFiles = null;
            try {
                skipFiles = eElement.getElementsByTagName(this.XML_NODE_SKIP_FILE).item(0).getTextContent();
                replace.setSkipFiles(skipFiles);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.methodReplaceData = CollectionsKt.plus((Collection)this.methodReplaceData, (Object)replace);
        }
    }

    public final void setSpecialReplaceList() {
        for (String iStub : Constants.Companion.getStubsArray()) {
            String[] stringArray = new String[]{","};
            List values = StringsKt.split$default((CharSequence)iStub, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String stubName = (String)values.get(0);
            String forClass = (String)values.get(1);
            String forFramework = (String)values.get(2);
            if (!(((CharSequence)stubName).length() > 0) || !(((CharSequence)forClass).length() > 0)) continue;
            ReplacementElement replace = new ReplacementElement();
            replace.setType(this.SPECIAL_REPLACEMENT_NODE);
            replace.setReplaceFor(((CharSequence)forFramework).length() > 0 ? "istub" : forFramework);
            replace.setPatterns(CollectionsKt.plus((Collection)replace.getPatterns(), (Object)stubName));
            replace.setReplaceFrom(stubName);
            replace.setReplaceTo(forClass);
            replace.setFile("com/ca/android/app");
            this.specialReplaceData = CollectionsKt.plus((Collection)this.specialReplaceData, (Object)replace);
        }
    }

    @NotNull
    public final List<ReplacementElement> getClassReplacementList() {
        return this.classReplaceData;
    }

    @NotNull
    public final List<ReplacementElement> getMethodReplacementList() {
        return this.methodReplaceData;
    }

    @NotNull
    public final List<ReplacementElement> getRegExReplacementList() {
        return this.regexReplaceData;
    }

    @NotNull
    public final List<ReplacementElement> getSpecialReplacementList() {
        return this.specialReplaceData;
    }
}

