/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin.transformerimpls;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.ca.dxapm.sdk.gradle.plugin.InstrumentationConfig;
import com.ca.dxapm.sdk.gradle.plugin.TransformConfig;
import com.ca.dxapm.sdk.gradle.plugin.dumps.MAAInterceptorDump;
import com.ca.dxapm.sdk.gradle.plugin.instrument.CaMaaClassInstrumenter;
import com.ca.dxapm.sdk.gradle.plugin.instrument.CaMaaInstrumentationVisitor;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.XmlParser;
import com.ca.dxapm.sdk.gradle.plugin.transformerimpls.CADxAPMTransformerFacade;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001bH\u0016J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\tH\u0002J\u0016\u0010'\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0016\u0010+\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0)H\u0002J\u001e\u0010.\u001a\u00020/2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020#H\u0002J\u0018\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0002J \u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/transformerimpls/CADxAPMTransformerImpl;", "Lcom/ca/dxapm/sdk/gradle/plugin/transformerimpls/CADxAPMTransformerFacade;", "config", "Lcom/ca/dxapm/sdk/gradle/plugin/TransformConfig;", "xmlParser", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;", "(Lcom/ca/dxapm/sdk/gradle/plugin/TransformConfig;Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;)V", "androidClasspath", "", "Ljava/io/File;", "ignorePaths", "Lkotlin/text/Regex;", "instrumentationConfig", "Lcom/ca/dxapm/sdk/gradle/plugin/InstrumentationConfig;", "instrumenter", "Lcom/ca/dxapm/sdk/gradle/plugin/instrument/CaMaaClassInstrumenter;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "runtimeClasspath", "Ljava/net/URL;", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "buildRuntimeClasspath", "copyStream", "", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "doIt", "dumpOkHttpInterceptor", "outputDirTmp", "", "PATH", "ensureDirectoryExists", "dir", "instrumentDirectoryInputs", "directoryInputs", "", "Lcom/android/build/api/transform/DirectoryInput;", "instrumentJarInputs", "jarInputs", "Lcom/android/build/api/transform/JarInput;", "isCordova", "", "isInstrumentableClassFile", "path", "normalizedRelativeFilePath", "parent", "file", "processClassStream", "name", "sdk-gradle-plugin"})
public final class CADxAPMTransformerImpl
implements CADxAPMTransformerFacade {
    private final org.gradle.api.logging.Logger logger;
    @NotNull
    private final TransformInvocation transformInvocation;
    @NotNull
    private final List<File> androidClasspath;
    @NotNull
    private final List<Regex> ignorePaths;
    private final TransformOutputProvider outputProvider;
    @NotNull
    private final List<URL> runtimeClasspath;
    @NotNull
    private final InstrumentationConfig instrumentationConfig;
    @NotNull
    private final CaMaaClassInstrumenter instrumenter;

    public CADxAPMTransformerImpl(@NotNull TransformConfig config, @NotNull XmlParser xmlParser) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)xmlParser, (String)"xmlParser");
        this.logger = Logging.getLogger(CADxAPMTransformerImpl.class);
        this.transformInvocation = config.getTransformInvocation();
        this.androidClasspath = config.getAndroidClasspath();
        this.ignorePaths = config.getIgnorePaths();
        this.outputProvider = this.transformInvocation.getOutputProvider();
        this.runtimeClasspath = this.buildRuntimeClasspath(this.transformInvocation);
        this.instrumentationConfig = new InstrumentationConfig(this.runtimeClasspath, config.getPluginConfig().logVisits, config.getPluginConfig().logInstrumentation, config.getPluginConfig().disableHttp, config.getPluginConfig().disableUI, this.isCordova(this.runtimeClasspath, config));
        this.instrumenter = new CaMaaClassInstrumenter(this.instrumentationConfig, xmlParser);
    }

    @Override
    public void doIt() {
        Logger.Companion.print(" Executing  CaMaaTransformer: " + this.transformInvocation.getInputs().size());
        this.logger.debug(this.instrumentationConfig.toString());
        this.logger.debug("isIncremental: " + this.transformInvocation.isIncremental());
        for (TransformInput ti : this.transformInvocation.getInputs()) {
            Logger.Companion.print("transformInputs: " + ti);
            Collection collection = ti.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ti.directoryInputs");
            this.instrumentDirectoryInputs(collection);
            collection = ti.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ti.jarInputs");
            this.instrumentJarInputs(collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<URL> buildRuntimeClasspath(TransformInvocation transformInvocation) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Collection collection2 = transformInvocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"transformInvocation.inputs");
        Collection collection3 = collection2;
        collection2 = transformInvocation.getReferencedInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"transformInvocation.referencedInputs");
        List allTransformInputs = CollectionsKt.plus((Collection)collection3, (Iterable)collection2);
        Iterable $this$map$iv = allTransformInputs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $this$mapTo$iv$iv3;
            void ti;
            TransformInput transformInput = (TransformInput)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Collection collection4 = ti.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"ti.directoryInputs");
            Collection collection5 = collection4;
            collection4 = ti.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"ti.jarInputs");
            Iterable $this$map$iv2 = CollectionsKt.plus((Collection)collection5, (Iterable)collection4);
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void i;
                QualifiedContent qualifiedContent = (QualifiedContent)item$iv$iv2;
                Collection collection6 = destination$iv$iv2;
                boolean bl2 = false;
                collection6.add(i.getFile());
            }
            collection.add((List)destination$iv$iv2);
        }
        List allJarsAndDirs = (List)destination$iv$iv;
        List allClassesAtRuntime = CollectionsKt.plus((Collection)this.androidClasspath, (Iterable)CollectionsKt.flatten((Iterable)allJarsAndDirs));
        Iterable $this$map$iv3 = allClassesAtRuntime;
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File bl = (File)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl3 = false;
            collection.add(file.toURI().toURL());
        }
        return (List)destination$iv$iv3;
    }

    private final boolean isCordova(List<URL> runtimeClasspath, TransformConfig config) {
        if (config.getPluginConfig().isCordova != -1) {
            Logger.Companion.printCritical("Cordova app identified by user Config.. ");
            return config.getPluginConfig().isCordova != 0;
        }
        Logger.Companion.printCritical("Checking if this is a Cordova app .. ");
        Iterator<URL> pathIterator = runtimeClasspath.iterator();
        while (pathIterator.hasNext()) {
            if (!StringsKt.contains$default((CharSequence)("" + pathIterator.next()), (CharSequence)"CordovaLib", (boolean)false, (int)2, null)) continue;
            Logger.Companion.printCritical("Cordova app identified by checking project config.. ");
            return true;
        }
        Logger.Companion.printCritical("App identified as a non-cordova app. ");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentDirectoryInputs(Collection<? extends DirectoryInput> directoryInputs) {
        for (DirectoryInput directoryInput : directoryInputs) {
            Throwable throwable;
            Object object;
            Throwable throwable2;
            Object object2;
            Object relativeFile;
            Object object3;
            File outDir;
            block35: {
                this.logger.debug("TransformInput dir " + directoryInput);
                Logger.Companion.print("TransformInput dir " + directoryInput);
                outDir = this.outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                Logger.Companion.print("Directory input " + directoryInput.getFile());
                this.logger.debug("  Directory input " + directoryInput.getFile());
                this.logger.debug("  Directory output " + outDir);
                if (!this.transformInvocation.isIncremental()) break block35;
                object3 = directoryInput.getChangedFiles();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"di.changedFiles");
                for (Map.Entry changedFile : object3.entrySet()) {
                    Status status = (Status)changedFile.getValue();
                    switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: 
                        case 2: {
                            File file = directoryInput.getFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"di.file");
                            File file2 = file;
                            file = changedFile.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"changedFile.key");
                            relativeFile = this.normalizedRelativeFilePath(file2, file);
                            File destFile = new File(outDir, (String)relativeFile);
                            object2 = changedFile.getKey();
                            Intrinsics.checkNotNullExpressionValue(object2, (String)"changedFile.key");
                            object2 = new FileInputStream((File)object2);
                            throwable2 = null;
                            try {
                                FileInputStream inputStream = (FileInputStream)object2;
                                boolean bl = false;
                                object = new FileOutputStream(destFile);
                                throwable = null;
                                try {
                                    FileOutputStream outputStream = (FileOutputStream)object;
                                    boolean bl2 = false;
                                    if (this.isInstrumentableClassFile((String)relativeFile)) {
                                        this.processClassStream((String)relativeFile, inputStream, outputStream);
                                    } else {
                                        this.copyStream(inputStream, outputStream);
                                    }
                                    outputStream = Unit.INSTANCE;
                                }
                                catch (Throwable outputStream) {
                                    throwable = outputStream;
                                    throw outputStream;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                                }
                                inputStream = Unit.INSTANCE;
                                break;
                            }
                            catch (Throwable inputStream) {
                                throwable2 = inputStream;
                                throw inputStream;
                            }
                            finally {
                                CloseableKt.closeFinally(object2, (Throwable)throwable2);
                            }
                        }
                        case 3: {
                            File destFile = directoryInput.getFile();
                            Intrinsics.checkNotNullExpressionValue((Object)destFile, (String)"di.file");
                            File file = destFile;
                            destFile = changedFile.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)destFile, (String)"changedFile.key");
                            relativeFile = this.normalizedRelativeFilePath(file, destFile);
                            destFile = new File(outDir, (String)relativeFile);
                            FileUtils.forceDelete((File)destFile);
                        }
                    }
                }
                this.logger.debug("  Files processed: " + directoryInput.getChangedFiles().size());
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)outDir, (String)"outDir");
            this.ensureDirectoryExists(outDir);
            FileUtils.cleanDirectory((File)outDir);
            this.logger.debug("  Copying " + directoryInput.getFile() + " to " + outDir);
            int count = 0;
            Iterator iterator = FileUtils.iterateFiles((File)directoryInput.getFile(), null, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterateFiles(di.file, null, true)");
            object3 = iterator;
            while (object3.hasNext()) {
                File file = (File)object3.next();
                relativeFile = directoryInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)relativeFile, (String)"di.file");
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                String relativeFile2 = this.normalizedRelativeFilePath((File)relativeFile, file);
                File destFile = new File(outDir, relativeFile2);
                Object object4 = destFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"destFile.parentFile");
                this.ensureDirectoryExists((File)object4);
                object4 = IOUtils.buffer((InputStream)new FileInputStream(file));
                object2 = null;
                try {
                    BufferedInputStream inputStream = (BufferedInputStream)object4;
                    boolean bl = false;
                    Closeable closeable = IOUtils.buffer((OutputStream)new FileOutputStream(destFile));
                    object = null;
                    try {
                        BufferedOutputStream outputStream = (BufferedOutputStream)closeable;
                        boolean bl3 = false;
                        if (this.isInstrumentableClassFile(relativeFile2)) {
                            try {
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                                InputStream inputStream2 = inputStream;
                                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
                                this.processClassStream(relativeFile2, inputStream2, outputStream);
                            }
                            catch (Exception e) {
                                Logger.Companion.print("Can't process class " + file + " :: " + e.getMessage());
                                this.logger.error("Can't process class " + file, (Throwable)e);
                                throw e;
                            }
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                            InputStream inputStream3 = inputStream;
                            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
                            this.copyStream(inputStream3, outputStream);
                        }
                        throwable = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        object = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    throwable2 = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    object2 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object4, object2);
                }
                int n = count;
                count = n + 1;
            }
            this.logger.debug("Files processed: " + count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentJarInputs(Collection<? extends JarInput> jarInputs) {
        Logger.Companion.print("instrumentJarInputs " + jarInputs.size());
        for (JarInput jarInput : jarInputs) {
            this.logger.debug("TransformInput jar " + jarInput);
            Logger.Companion.print("TransformInput jar " + jarInput);
            File outDir = this.outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.DIRECTORY);
            Logger.Companion.print("Jar input " + jarInput.getFile());
            this.logger.debug("  Jar input " + jarInput.getFile());
            Logger.Companion.print("  Dir output " + outDir);
            boolean doTransform = !this.transformInvocation.isIncremental() || jarInput.getStatus() == Status.ADDED || jarInput.getStatus() == Status.CHANGED;
            Logger.Companion.printCritical("doTransform? ---  " + doTransform);
            if (doTransform) {
                Intrinsics.checkNotNullExpressionValue((Object)outDir, (String)"outDir");
                this.ensureDirectoryExists(outDir);
                FileUtils.cleanDirectory((File)outDir);
                JarFile inJar = new JarFile(jarInput.getFile());
                int count = 0;
                Enumeration<JarEntry> enumeration = inJar.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"inJar.entries()");
                Iterator iterator = CollectionsKt.iterator(enumeration);
                while (iterator.hasNext()) {
                    JarEntry entry = (JarEntry)iterator.next();
                    File outFile = new File(outDir, entry.getName());
                    Logger.Companion.printCritical("entry " + entry.getName());
                    if (entry.isDirectory()) continue;
                    Object object = outFile.getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outFile.parentFile");
                    this.ensureDirectoryExists((File)object);
                    object = inJar.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        InputStream inputStream = (InputStream)object;
                        boolean bl = false;
                        Closeable closeable = IOUtils.buffer((OutputStream)new FileOutputStream(outFile));
                        Throwable throwable2 = null;
                        try {
                            BufferedOutputStream outputStream = (BufferedOutputStream)closeable;
                            boolean bl2 = false;
                            String string = entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                            if (this.isInstrumentableClassFile(string)) {
                                try {
                                    string = entry.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
                                    this.processClassStream(string, inputStream, outputStream);
                                }
                                catch (Exception e) {
                                    Logger.Companion.print("Can't process class " + entry.getName() + " :: " + e.getMessage());
                                    this.logger.error("Can't process class " + entry.getName(), (Throwable)e);
                                    throw e;
                                }
                            } else {
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
                                this.copyStream(inputStream, outputStream);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                    int n = count;
                    count = n + 1;
                }
                this.logger.debug("  Entries copied: " + count);
                continue;
            }
            if (jarInput.getStatus() != Status.REMOVED) continue;
            this.logger.debug("  REMOVED");
            if (!outDir.exists()) continue;
            FileUtils.forceDelete((File)outDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dumpOkHttpInterceptor(String outputDirTmp, String PATH) {
        File directory = new File(outputDirTmp, PATH);
        directory.mkdirs();
        File outFileMaaInterceptor = new File(directory.getAbsolutePath(), "MAAInterceptor.class");
        Closeable closeable = IOUtils.buffer((OutputStream)new FileOutputStream(outFileMaaInterceptor));
        Throwable throwable = null;
        try {
            BufferedOutputStream outputStreamTemp = (BufferedOutputStream)closeable;
            boolean bl = false;
            byte[] s1 = MAAInterceptorDump.dump();
            IOUtils.write((byte[])s1, (OutputStream)outputStreamTemp);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void ensureDirectoryExists(File dir) {
        if (!(dir.isDirectory() && dir.canWrite() || dir.mkdirs())) {
            throw new IOException("Can't write or create " + dir.getPath());
        }
    }

    private final String normalizedRelativeFilePath(File parent, File file) {
        List parts = new ArrayList();
        Object current = file;
        while (!Intrinsics.areEqual((Object)current, (Object)parent)) {
            Object object = ((File)current).getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"current.name");
            parts.add(object);
            object = ((File)current).getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"current.parentFile");
            current = object;
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversedMutable((List)parts), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean isInstrumentableClassFile(String path) {
        boolean bl;
        boolean bl2;
        block5: {
            Iterable $this$any$iv = this.ignorePaths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl3 = false;
                    if (!it.matches((CharSequence)path)) continue;
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            this.logger.debug("Ignoring class " + path);
            bl = false;
        } else {
            String string = path.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            bl = StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null);
        }
        return bl;
    }

    private final void copyStream(InputStream inputStream, OutputStream outputStream) {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    private final void processClassStream(String name, InputStream inputStream, OutputStream outputStream) {
        byte[] byArray;
        byte[] classBytes = IOUtils.toByteArray((InputStream)inputStream);
        CaMaaInstrumentationVisitor.Companion.setModified(false);
        try {
            byte[] byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)classBytes, (String)"classBytes");
            byte[] instrBytes = this.instrumenter.instrument(classBytes);
            if (CaMaaInstrumentationVisitor.Companion.isModified()) {
                Logger.Companion.print("Instrumented " + name + " successfully");
                byArray2 = instrBytes;
            } else {
                byArray2 = classBytes;
            }
            byArray = byArray2;
        }
        catch (Exception e) {
            Logger.Companion.print("Instrumentation failed for " + name + " :: " + e.getMessage());
            this.logger.error("Failed to instrument " + name + ", using original contents", (Throwable)e);
            byArray = classBytes;
        }
        catch (Error errorI) {
            Logger.Companion.print("Instrumentation failed for " + name + " :: " + errorI);
            byArray = classBytes;
        }
        byte[] bytesToWrite = byArray;
        IOUtils.write((byte[])bytesToWrite, (OutputStream)outputStream);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            nArray[Status.ADDED.ordinal()] = 1;
            nArray[Status.CHANGED.ordinal()] = 2;
            nArray[Status.REMOVED.ordinal()] = 3;
            nArray[Status.NOTCHANGED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

