/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin.extension;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.ca.dxapm.sdk.gradle.plugin.CADxAPMPlugin;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtension;
import com.ca.dxapm.sdk.gradle.plugin.extension.VariantConfig;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.ProjectUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public class CADxAPMExtensionTask
extends DefaultTask {
    String plistAbsolutePath;
    String variantName;
    Project parentProject;

    @Inject
    public CADxAPMExtensionTask(Project project, String variant) {
        this.parentProject = project;
        this.variantName = variant;
    }

    @TaskAction
    public void setupSDK() throws Exception {
        Logger.printCritical("Configuring CAExtension for variant " + this.variantName);
        CADxAPMExtension ext = (CADxAPMExtension)this.parentProject.getExtensions().getByType(CADxAPMExtension.class);
        Logger.printCritical("CAExtension logInstrumentation [" + ext.logInstrumentation + "]-----addCoreSdkDependency [" + ext.addCoreSdkDependency + "]");
        CADxAPMPlugin.Companion.setExtension(ext);
        this.createLogFile(ext);
        String assetsPath = this.getAssetPath(ext);
        this.setupPlist(ext, assetsPath);
        this.setupInterceptor(ext, assetsPath);
        if (ProjectUtil.isCordovaApp().booleanValue()) {
            Logger.printCritical("Cordova app identified by checking project config.. ");
        }
    }

    private void setupInterceptor(CADxAPMExtension ext, String assetsPath) throws Exception {
        String interceptorPathToUse = this.parentProject.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk" + File.separator + "CaMDOInterceptor.js";
        File interceptorPath = new File(interceptorPathToUse);
        File assetsPathToCopy = new File(assetsPath + File.separator + "CaMDOInterceptor.js");
        try {
            FileUtils.copyFile((File)interceptorPath, (File)assetsPathToCopy);
        }
        catch (Exception e) {
            throw new Exception("CA DX APM SDK can not be configured. Error copying CaMDOInterceptor file '" + interceptorPathToUse + "' to the assets folder:  " + assetsPathToCopy.getAbsolutePath() + ". Reason " + e);
        }
    }

    private void setupPlist(CADxAPMExtension ext, String assetsPath) throws Exception {
        String globalPlist = ext.plist;
        if (globalPlist == null) {
            Logger.printCritical("CA DX APM SDK is enabled, but no plist is specified. Please specify the plist value in the 'cadxapmsdk' block in build.gradle file");
            throw new Exception("CA DX APM SDK is enabled, but no plist is specified. Please specify the plist value in the 'cadxapmsdk' block in build.gradle file");
        }
        Logger.printCritical("Global plist " + globalPlist);
        boolean isVariantEnabled = this.isVariantEnabled(this.variantName, ext);
        ext.vairantStatusMap.put(this.variantName, isVariantEnabled);
        if (!isVariantEnabled) {
            Logger.printCritical("CA DX APM SDK is disabled for variant " + this.variantName + ", based on configuration ");
            return;
        }
        String variantPlist = this.getVariantPlist(this.variantName, ext);
        if (variantPlist != null) {
            Logger.printCritical("Using Variant plist " + variantPlist);
        }
        String plistToUse = variantPlist != null ? variantPlist : globalPlist;
        Logger.printCritical("@CAExtensionTask plist-path: " + plistToUse + ", assetPath: " + assetsPath);
        File plistPath = new File(plistToUse);
        File assetsPathToCopy = new File(assetsPath + "/conf/" + plistPath.getName());
        File propFileName = new File(this.parentProject.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk" + File.separator + "axa-sdk-plugin.properties");
        File propFileToCopy = new File(assetsPath + "/conf/" + propFileName.getName());
        File assetsConfigFolder = new File(assetsPath + "/conf/");
        if (assetsConfigFolder.exists() && assetsConfigFolder.isDirectory()) {
            File[] listFiles = assetsConfigFolder.listFiles();
            try {
                for (File file : listFiles) {
                    file.delete();
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                Files.createDirectories(Paths.get(assetsConfigFolder.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            catch (Exception e) {
                Logger.printCritical("CA DX APM SDK can not be configured. Error creating folder " + assetsConfigFolder.getAbsolutePath() + ". Reason " + e);
                throw new Exception("CA DX APM SDK can not be configured.. Error creating folder " + assetsConfigFolder.getAbsolutePath() + ". Reason " + e);
            }
        }
        if (!plistPath.exists()) {
            throw new Exception("CA DX APM SDK can not be configured. Provided plist file does not exists:" + plistToUse);
        }
        if (!plistToUse.endsWith("camdo.plist")) {
            throw new Exception("CA DX APM SDK can not be configured. Provided plist does not have a valid name. The file name should end with 'camdo.plist': '" + plistToUse + "'");
        }
        try {
            FileUtils.copyFile((File)plistPath, (File)assetsPathToCopy);
            FileUtils.copyFile((File)propFileName, (File)propFileToCopy);
        }
        catch (Exception e) {
            throw new Exception("CA DX APM SDK can not be configured. Error copying plist file '" + this.plistAbsolutePath + "' to the assets folder:  " + assetsPathToCopy.getAbsolutePath() + ". Reason " + e);
        }
    }

    private void createLogFile(CADxAPMExtension ext) {
        String path = this.parentProject.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk" + File.separator + "logger.txt";
        try {
            File logFile = new File(path);
            if (ext.logInstrumentation && !logFile.exists()) {
                logFile.createNewFile();
            }
            Logger.debugFilePath = path;
        }
        catch (Exception e) {
            System.out.println("Error creating logfile" + path);
        }
    }

    private String getVariantPlist(String currentVariant, CADxAPMExtension ext) {
        Logger.debug("@getVariantPlist getting  plist for variant " + currentVariant);
        for (VariantConfig varName : ext.variants) {
            Logger.debug("checking variant " + varName.getName() + ", plist " + varName.getPlist());
            if (!currentVariant.equalsIgnoreCase(varName.getName())) continue;
            return varName.getPlist();
        }
        return null;
    }

    private boolean isVariantEnabled(String currentVariant, CADxAPMExtension ext) {
        Logger.debug("@isVariantEnabled getting  plist for variant " + currentVariant);
        Iterator it = ext.variants.iterator();
        Pattern p = null;
        if (ext.disabledVariants != null) {
            try {
                p = Pattern.compile(ext.disabledVariants);
            }
            catch (Exception e) {
                Logger.printCritical("Error: " + e);
            }
        }
        Logger.debug("_disabledVariants: " + ext.disabledVariants + ", pattern: " + p);
        while (it.hasNext()) {
            Matcher m;
            VariantConfig varName = (VariantConfig)it.next();
            Logger.debug("checking variant " + varName.getName() + ", plist " + varName.getPlist());
            if (!currentVariant.equalsIgnoreCase(varName.getName())) continue;
            if (p != null && (m = p.matcher(varName.getName())).find()) {
                Logger.printCritical("Disabling variant " + varName.getName() + " since it matched the disablePattern " + p);
                return false;
            }
            return varName.isEnabled();
        }
        return true;
    }

    private String getAssetPath(CADxAPMExtension ext) throws Exception {
        Logger.debug("getting main assets path");
        if (ext.assetsPath != null) {
            if (new File(ext.assetsPath).exists()) {
                return ext.assetsPath;
            }
            throw new Exception("CA DX APM SDK can not be configured. Provided assets path doesnot exists");
        }
        AppExtension androidExt = (AppExtension)this.parentProject.getExtensions().getByType(AppExtension.class);
        if (androidExt.getSourceSets().getByName("main") == null) {
            Logger.debug("Cant find the 'main' source set. ");
            throw new Exception("CA DX APM SDK can not be configured.Can not find assets folder The project is missing the 'main' source set. Since the project uses a non standard structure, please specify the assets folder location in the 'cadxapm' block as 'assetpath' ");
        }
        String mainSourceFolder = ((AndroidSourceSet)androidExt.getSourceSets().getByName("main")).getManifest().getSrcFile().getParent();
        Logger.debug(" mainSourceFolder : " + mainSourceFolder);
        File assetsFolder = new File(mainSourceFolder + "/assets");
        Logger.debug(" constructed assetsFolder path : " + assetsFolder.getAbsolutePath());
        if (!assetsFolder.exists()) {
            Logger.debug(" The project is missing the 'main/assets' folder. Creating one ");
            Files.createDirectories(Paths.get(assetsFolder.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        return assetsFolder.getAbsolutePath();
    }
}

