/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin;

import com.android.build.api.transform.Transform;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.ca.dxapm.sdk.gradle.plugin.CADxAPMPlugin;
import com.ca.dxapm.sdk.gradle.plugin.CADxAPMTransformer;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtension;
import com.ca.dxapm.sdk.gradle.plugin.extension.CADxAPMExtensionTask;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.ProjectUtil;
import com.ca.dxapm.sdk.gradle.plugin.parser.XmlParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/CADxAPMPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "projGradleVersion", "", "projectParentName", "addSdkPluginPropertiesFile", "", "destFolder", "project", "apply", "configureCADxAPMExtension", "extractResourcesToLocalPath", "getProjectVersion", "readXmlProperties", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/XmlParser;", "Companion", "sdk-gradle-plugin"})
public final class CADxAPMPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String projGradleVersion = "";
    @NotNull
    private String projectParentName = "";
    @NotNull
    public static final String PLUGIN_NAME = "CADxAPMPlugin";
    @Nullable
    private static CADxAPMExtension extension;

    public void apply(@NotNull Project project) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getLogger().log(LogLevel.INFO, "CADxAPMPlugin applied");
        String string = project.getGradle().getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.gradle.gradleVersion");
        this.projGradleVersion = string;
        Project project2 = project.getParent();
        String string2 = project2 == null ? null : project2.getName();
        if (string2 == null) {
            stringArray = project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"project.name");
            string2 = stringArray;
        }
        this.projectParentName = string2;
        Logger.Companion.printCritical("Project [" + this.projectParentName + "] is running with Gradle Version: " + this.projGradleVersion);
        stringArray = new String[]{"."};
        Integer gradleMajorVersion = StringsKt.toIntOrNull((String)((String)StringsKt.split$default((CharSequence)this.projGradleVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)));
        project.getConfigurations().configureEach(CADxAPMPlugin::apply$lambda-1);
        Object ext = project.getExtensions().findByName("android");
        if (ext != null && ext instanceof AppExtension) {
            project.getLogger().log(LogLevel.INFO, "Registering transform");
            Object[] objectArray = new Object[]{project.getObjects()};
            project.getExtensions().create("cadxapmsdk", CADxAPMExtension.class, objectArray);
            XmlParser xmlParser = this.readXmlProperties(project);
            ProjectUtil.setProjectDetails(project);
            ProjectUtil.setXmlParser(xmlParser);
            this.configureCADxAPMExtension(project);
            if (gradleMajorVersion != null && gradleMajorVersion >= 8) {
                Logger.Companion.printCritical("@CADxAPMPlugin:Using Instrumentation API");
                AndroidComponentsExtension androidComponents = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
                Intrinsics.checkNotNullExpressionValue((Object)androidComponents, (String)"androidComponents");
                AndroidComponentsExtension.DefaultImpls.onVariants$default((AndroidComponentsExtension)androidComponents, null, (Function1)apply.2.INSTANCE, (int)1, null);
            } else {
                Logger.Companion.printCritical("@CADxAPMPlugin:Using registerTransform API as gradle version is less than 8.0 for supporting backward compatibility");
                ((AppExtension)ext).registerTransform((Transform)new CADxAPMTransformer(project, xmlParser), new Object[0]);
            }
        } else {
            throw new Exception("CA DX APM SDK plugin may only be applied to Android app projects");
        }
        project.getRootDir();
    }

    private final void configureCADxAPMExtension(Project project) {
        AppExtension android;
        CADxAPMExtension ext = (CADxAPMExtension)project.getExtensions().getByType(CADxAPMExtension.class);
        String sdkCoreDependencyModule = "com.ca.dxapm:sdk-core:" + this.getProjectVersion() + "@aar";
        AppExtension appExtension = android = (AppExtension)project.getExtensions().findByType(AppExtension.class);
        if (appExtension != null) {
            DomainObjectSet domainObjectSet = appExtension.getApplicationVariants();
            if (domainObjectSet != null) {
                domainObjectSet.configureEach(arg_0 -> CADxAPMPlugin.configureCADxAPMExtension$lambda-3(project, this, ext, sdkCoreDependencyModule, arg_0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getProjectVersion() {
        String sdkCoreVersion = null;
        Properties properties = new Properties();
        InputStream inputStream = CADxAPMPlugin.class.getClassLoader().getResourceAsStream("sdk-plugin.properties");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                properties.load(input);
                if (properties.containsKey("sdk-core-version")) {
                    sdkCoreVersion = properties.getProperty("sdk-core-version");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            inputStream.close();
        }
        return sdkCoreVersion;
    }

    private final XmlParser readXmlProperties(Project project) {
        XmlParser xmlParser;
        block4: {
            xmlParser = null;
            String completePath = project.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk" + File.separator + "android.xml";
            Logger.Companion.print("Reading android.xml file");
            try {
                File xmlFile = new File(completePath);
                if (xmlFile.exists()) {
                    xmlParser = new XmlParser();
                    xmlParser.parseXML(completePath);
                    this.addSdkPluginPropertiesFile(project.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk", project);
                    break block4;
                }
                Logger.Companion.printCritical(" Missing rule file <project>/cadxapmsdk/android.xml , Extracting from Jar");
                this.extractResourcesToLocalPath(project.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk", project);
                if (xmlFile.exists()) {
                    xmlParser = new XmlParser();
                    xmlParser.parseXML(completePath);
                    break block4;
                }
                Logger.Companion.printCritical(" Missing rule file <project>/cadxapmsdk/android.xml ");
                throw new Exception("Missing rule file <project>/cadxapmsdk/android.xml  ");
            }
            catch (Exception e) {
                throw new Exception("CA DX APM SDK can not be configured. " + e);
            }
        }
        return xmlParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void extractResourcesToLocalPath(String destFolder, Project project) {
        InputStream ins1;
        Object object;
        InputStream ins;
        File parentDir = new File(destFolder);
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if ((ins = CADxAPMPlugin.class.getClassLoader().getResourceAsStream("android.xml")) != null) {
            Closeable closeable = ins;
            object = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                long l = Files.copy(input, Paths.get(parentDir.getAbsolutePath() + File.separator + "android.xml", new String[0]), new CopyOption[0]);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            ins.close();
        }
        if ((ins1 = CADxAPMPlugin.class.getClassLoader().getResourceAsStream("CaMDOInterceptor.js")) != null) {
            object = ins1;
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)object;
                boolean bl = false;
                long l = Files.copy(input, Paths.get(parentDir.getAbsolutePath() + File.separator + "CaMDOInterceptor.js", new String[0]), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            ins1.close();
        }
        this.addSdkPluginPropertiesFile(destFolder, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addSdkPluginPropertiesFile(String destFolder, Project project) {
        File parentDir = new File(destFolder);
        String propertiesFile = project.getRootDir().getAbsolutePath() + File.separator + "cadxapmsdk" + File.separator + "axa-sdk-plugin.properties";
        File propFile = new File(propertiesFile);
        Properties properties = new Properties();
        FileOutputStream fileOutputStream = null;
        if (!propFile.exists()) {
            InputStream inputStream = CADxAPMPlugin.class.getClassLoader().getResourceAsStream("axa-sdk-plugin.properties");
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream input22 = (InputStream)closeable;
                    boolean bl = false;
                    long input22 = Files.copy(input22, Paths.get(parentDir.getAbsolutePath() + File.separator + "axa-sdk-plugin.properties", new String[0]), new CopyOption[0]);
                }
                catch (Throwable input22) {
                    throwable = input22;
                    throw input22;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                inputStream.close();
            }
            properties.load(new FileInputStream(propFile));
            properties.setProperty("gradleVersion", project.getGradle().getGradleVersion());
            fileOutputStream = new FileOutputStream(propertiesFile);
            properties.store(fileOutputStream, "AXA SDK Plugin Properties File");
        } else {
            InputStream inputStream = new FileInputStream(propFile);
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                properties.load(input);
                String existingVersion = properties.getProperty("gradleVersion");
                inputStream.close();
                if (!Intrinsics.areEqual((Object)existingVersion, (Object)project.getGradle().getGradleVersion())) {
                    properties.setProperty("gradleVersion", project.getGradle().getGradleVersion());
                    fileOutputStream = new FileOutputStream(propertiesFile);
                    properties.store(fileOutputStream, "AXA SDK Plugin Properties File");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        FileOutputStream fileOutputStream2 = fileOutputStream;
        if (fileOutputStream2 != null) {
            fileOutputStream2.close();
        }
    }

    private static final void apply$lambda-1$lambda-0(Dependency dependency) {
        block5: {
            block6: {
                String string;
                if (!dependency.getName().equals("unspecified")) {
                    string = dependency.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependency.name");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"CordovaLib", (boolean)false, (int)2, null)) {
                        ProjectUtil.setCordovaApp(true);
                    }
                }
                if (dependency.getName().equals("unspecified")) break block5;
                string = dependency.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependency.name");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"capacitor-android", (boolean)false, (int)2, null)) break block6;
                string = dependency.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependency.name");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"react-native", (boolean)false, (int)2, null)) break block5;
            }
            ProjectUtil.setHybridApp(true);
        }
    }

    private static final void apply$lambda-1(Configuration config) {
        config.getAllDependencies().configureEach(CADxAPMPlugin::apply$lambda-1$lambda-0);
    }

    private static final void configureCADxAPMExtension$lambda-3$lambda-2(ApplicationVariant $it, CADxAPMExtensionTask $plistTask, Task buildTask) {
        Logger.Companion.debug("created task CADxAPMSDKConfig-" + $it.getName() + ".... " + $plistTask + ", build task " + buildTask);
        Object[] objectArray = new Object[]{$plistTask};
        buildTask.dependsOn(objectArray);
    }

    private static final void configureCADxAPMExtension$lambda-3(Project $project, CADxAPMPlugin this$0, CADxAPMExtension $ext, String $sdkCoreDependencyModule, ApplicationVariant it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sdkCoreDependencyModule, (String)"$sdkCoreDependencyModule");
        Logger.Companion.debug("configureVariant......" + it.getName() + "..");
        Object[] objectArray = new Object[]{$project, it.getName()};
        CADxAPMExtensionTask plistTask = (CADxAPMExtensionTask)$project.getTasks().create("CADxAPMSDKConfig-" + it.getName(), CADxAPMExtensionTask.class, objectArray);
        try {
            it.getPreBuildProvider().configure(arg_0 -> CADxAPMPlugin.configureCADxAPMExtension$lambda-3$lambda-2(it, plistTask, arg_0));
            if (this$0.getProjectVersion() != null && $ext.addCoreSdkDependency && !ProjectUtil.isHybridApp().booleanValue()) {
                $project.getDependencies().add("implementation", (Object)$sdkCoreDependencyModule);
            }
        }
        catch (Exception e) {
            Logger.Companion.printCritical("CA DX APM SDK can not be configured.. Error creating configuration task " + e);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/CADxAPMPlugin$Companion;", "", "()V", "PLUGIN_NAME", "", "extension", "Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;", "getExtension", "()Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;", "setExtension", "(Lcom/ca/dxapm/sdk/gradle/plugin/extension/CADxAPMExtension;)V", "sdk-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CADxAPMExtension getExtension() {
            return extension;
        }

        public final void setExtension(@Nullable CADxAPMExtension cADxAPMExtension) {
            extension = cADxAPMExtension;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

