/*
 * Decompiled with CFR 0.152.
 */
package com.ca.dxapm.sdk.gradle.plugin.parser;

import com.ca.dxapm.sdk.gradle.plugin.instrument.CaMaaInstrumentationVisitor;
import com.ca.dxapm.sdk.gradle.plugin.logs.Logger;
import com.ca.dxapm.sdk.gradle.plugin.parser.MethodDetails;
import com.ca.dxapm.sdk.gradle.plugin.parser.ReplacementElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/parser/ReplaceUtil;", "", "()V", "Companion", "sdk-gradle-plugin"})
public final class ReplaceUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u001e\u0010\r\u001a\u0004\u0018\u00010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ>\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tJ(\u0010\u0016\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\tJC\u0010\u0017\u001a\u0004\u0018\u00010\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/ca/dxapm/sdk/gradle/plugin/parser/ReplaceUtil$Companion;", "", "()V", "checkFileSkip", "", "methodReplacementList", "", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/ReplacementElement;", "className", "", "getOpcodeFromName", "", "name", "processClassReplacements", "classReplacementList", "processRegExReplacement", "Lcom/ca/dxapm/sdk/gradle/plugin/parser/MethodDetails;", "regexReplacementList", "opcode", "owner", "desc", "superClass", "processSpecialReplacement", "processsMethodReplacement", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/ca/dxapm/sdk/gradle/plugin/parser/MethodDetails;", "sdk-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String processClassReplacements(@NotNull List<ReplacementElement> classReplacementList, @NotNull String className) {
            Intrinsics.checkNotNullParameter(classReplacementList, (String)"classReplacementList");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            String replacedString = null;
            try {
                for (ReplacementElement replace : classReplacementList) {
                    if (replace.getReplaceFrom() == null || !StringsKt.equals$default((String)replace.getReplaceFrom(), (String)className, (boolean)false, (int)2, null)) continue;
                    replacedString = replace.getReplaceTo();
                    break;
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while class replacement " + className + " :: " + e.getMessage());
            }
            return replacedString;
        }

        public final boolean checkFileSkip(@NotNull List<ReplacementElement> methodReplacementList, @NotNull String className) {
            Intrinsics.checkNotNullParameter(methodReplacementList, (String)"methodReplacementList");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            boolean fileToBeSkipped = false;
            try {
                for (ReplacementElement replace : methodReplacementList) {
                    List skipFile;
                    List list;
                    if (replace.getSkipFiles() == null) continue;
                    String string = replace.getSkipFiles();
                    if (string == null) {
                        list = null;
                    } else {
                        String[] stringArray = new String[]{","};
                        list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    }
                    List list2 = skipFile = list;
                    Intrinsics.checkNotNull(list2);
                    for (String fileToSkip : list2) {
                        if (!StringsKt.contains$default((CharSequence)className, (CharSequence)fileToSkip, (boolean)false, (int)2, null)) continue;
                        fileToBeSkipped = true;
                    }
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while checking file skiping " + className + " :: " + e.getMessage());
            }
            return fileToBeSkipped;
        }

        @Nullable
        public final MethodDetails processsMethodReplacement(@NotNull List<ReplacementElement> methodReplacementList, @Nullable Integer opcode, @Nullable String owner, @Nullable String name, @Nullable String desc) {
            Intrinsics.checkNotNullParameter(methodReplacementList, (String)"methodReplacementList");
            MethodDetails methodDetails = new MethodDetails();
            Object object = methodDetails;
            Integer n = opcode;
            Intrinsics.checkNotNull((Object)n);
            ((MethodDetails)object).setOpcodeInfo(n);
            object = methodDetails;
            String string = owner;
            Intrinsics.checkNotNull((Object)string);
            ((MethodDetails)object).setOwner(string);
            object = methodDetails;
            String string2 = name;
            Intrinsics.checkNotNull((Object)string2);
            ((MethodDetails)object).setName(string2);
            object = methodDetails;
            String string3 = desc;
            Intrinsics.checkNotNull((Object)string3);
            ((MethodDetails)object).setDesc(string3);
            try {
                for (ReplacementElement replace : methodReplacementList) {
                    if (!owner.equals(replace.getOwnerFrom()) || !name.equals(replace.getReplaceFrom()) || !desc.equals(replace.getDescFrom())) continue;
                    MethodDetails methodDetails2 = methodDetails;
                    methodDetails2.setOwner(replace.getOwnerTo());
                    methodDetails2 = methodDetails;
                    methodDetails2.setDesc(replace.getDescTo());
                    methodDetails2 = methodDetails;
                    methodDetails2.setName(replace.getReplaceTo());
                    if (((CharSequence)replace.getMethodTo()).length() > 0 && this.getOpcodeFromName(replace.getMethodTo()) != -1) {
                        int newOpcode = this.getOpcodeFromName(replace.getMethodTo());
                        MethodDetails methodDetails3 = methodDetails;
                        methodDetails3.setOpcodeInfo(newOpcode);
                    } else {
                        methodDetails2 = methodDetails;
                        methodDetails2.setOpcodeInfo(opcode);
                    }
                    CaMaaInstrumentationVisitor.Companion.setModified(true);
                    break;
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while method replacement :: " + e.getMessage());
            }
            return methodDetails;
        }

        @Nullable
        public final MethodDetails processRegExReplacement(@NotNull List<ReplacementElement> regexReplacementList, int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, @NotNull String superClass) {
            Intrinsics.checkNotNullParameter(regexReplacementList, (String)"regexReplacementList");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
            MethodDetails methodDetails = new MethodDetails();
            Object object = methodDetails;
            ((MethodDetails)object).setOpcodeInfo(opcode);
            object = methodDetails;
            ((MethodDetails)object).setOwner(owner);
            object = methodDetails;
            ((MethodDetails)object).setName(name);
            object = methodDetails;
            ((MethodDetails)object).setDesc(desc);
            try {
                block2: for (ReplacementElement replace : regexReplacementList) {
                    String matcher = replace.getMatcher();
                    if (matcher != null && !StringsKt.equals((String)matcher, (String)superClass, (boolean)true)) continue;
                    for (String pattern : replace.getPatterns()) {
                        int opcodeFrom;
                        char[] cArray;
                        List values;
                        if (!(((CharSequence)pattern).length() > 0) || (values = StringsKt.split$default((CharSequence)pattern, (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)).size() < 2 || (opcodeFrom = this.getOpcodeFromName((String)values.get(0))) != opcode || !StringsKt.equals((String)owner, (String)((String)values.get(1)), (boolean)true)) continue;
                        MethodDetails methodDetails2 = methodDetails;
                        methodDetails2.setOwner(replace.getOwnerTo());
                        CaMaaInstrumentationVisitor.Companion.setModified(true);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while instrumenting REGEX :: " + e.getMessage());
            }
            return methodDetails;
        }

        @Nullable
        public final MethodDetails processSpecialReplacement(@NotNull List<ReplacementElement> regexReplacementList, @Nullable String owner, @NotNull String desc) {
            Intrinsics.checkNotNullParameter(regexReplacementList, (String)"regexReplacementList");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            String ownerTmp = null;
            String descTmp = null;
            MethodDetails methodDetails = null;
            try {
                for (ReplacementElement replace : regexReplacementList) {
                    String matcher = replace.getMatcher();
                    if (matcher != null) continue;
                    for (String pattern : replace.getPatterns()) {
                        if (owner != null && StringsKt.contains$default((CharSequence)owner, (CharSequence)pattern, (boolean)false, (int)2, null)) {
                            if (ownerTmp == null) {
                                ownerTmp = owner;
                            }
                            ownerTmp = StringsKt.replace$default((String)ownerTmp, (String)pattern, (String)replace.getReplaceTo(), (boolean)false, (int)4, null);
                        }
                        if (!StringsKt.contains$default((CharSequence)desc, (CharSequence)pattern, (boolean)false, (int)2, null)) continue;
                        if (descTmp == null) {
                            descTmp = desc;
                        }
                        descTmp = StringsKt.replace$default((String)descTmp, (String)pattern, (String)replace.getReplaceTo(), (boolean)false, (int)4, null);
                    }
                }
                if (ownerTmp != null || descTmp != null) {
                    methodDetails = new MethodDetails();
                    String string = owner;
                    Intrinsics.checkNotNull((Object)string);
                    methodDetails.setOwner(string);
                    methodDetails.setDesc(desc);
                    if (ownerTmp != null) {
                        methodDetails.setOwner(ownerTmp);
                    }
                    if (descTmp != null) {
                        methodDetails.setDesc(descTmp);
                    }
                    CaMaaInstrumentationVisitor.Companion.setModified(true);
                }
            }
            catch (Exception e) {
                Logger.Companion.print("Exception while special instrumentation :: " + e.getMessage());
            }
            return methodDetails;
        }

        public final int getOpcodeFromName(@NotNull String name) {
            int n;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            switch (name) {
                case "invoke-direct": {
                    n = 183;
                    break;
                }
                case "invoke-static": {
                    n = 184;
                    break;
                }
                case "invoke-virtual": {
                    n = 182;
                    break;
                }
                case "invoke-special": {
                    n = 183;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

