

################################################################################
# Bundle: dn-agent-unix:21.4.0.26
################################################################################

# This is the .NET agent configuration.

# AutoProbe Properties # 
#
# On/Off Switch 
#
# ================
# This boolean property gives you the ability to disable Introscope AutoProbe by
# settings the property value to false. You must restart the managed application
# before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.autoprobe.enable=true

# Custom Log File Location 
#
# ================
# Introscope AutoProbe will always attempt to log the changes it makes.  Set
# this property to move the location of the log file to something other than the
# default.  Non-absolute names are resolved relative to the location of this
# properties file. You must restart the managed application before changes to
# this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.autoprobe.logfile=logs/AutoProbe.log

# Agent will log information about traces and agent services in this log file.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.logfile=logs/IntroscopeAgent.log

# Changing this property requires restarting the Monitored Process
#introscope.agent.log.level=INFO

# Changing this property requires restarting the Monitored Process
#introscope.agent.log.max.file.size=200MB

# Changing this property requires restarting the Monitored Process
#introscope.agent.log.max.roll.backups=4

# NativeProfiler will log information about the directives it read and the
# method it instrumented in this log file. 
#
# Changing this property requires restarting the Monitored Process
introscope.nativeprofiler.logfile=logs/nativeprofiler.log

# NativeProfiler will list the instrumented byte-code if this property is set to
# true.  It is set to false by default. 
#
# Changing this property requires restarting the Monitored Process
#introscope.nativeprofiler.logBytecode=false

# NativeProfiler will log all methods noticed, even uninstrumented ones if this
# property is enabled. It is disabled by default 
#
# Changing this property requires restarting the Monitored Process
#introscope.nativeprofiler.logAllMethodsNoticed=false

# If you get native profiler log and still .NET agent does not start enable the
# following property. This will use the generic trigger. Note if you enable this
# property you could see defaut domain also being probed however if the agent is
# in restricted mode (which is default) the agent will not connect to EM. In
# ProcSxS Agent names will appear like `<ProcessName>_<ApplicationDomainName>` 
#
# Changing this property requires restarting the Monitored Process
#introscope.nativeprofiler.generic.agent.trigger.enabled=false

# Allows the agent to run without using the GAC. This is required for Azure and
# .NET Core environments 
#
# Changing this property requires restarting the Monitored Process
#introscope.nativeprofiler.synthetic.shim.enabled=true

# Enabled the DA trigger feature. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.da.trace.enabled=true

# Limit the number of transactions analyzed per 15 second interval
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.da.trace.maxTransactionsAnalyzedPerInterval=4

# Native Profiler Startup Bubble Improvement Following property if set to false,
# disables the ngen monitoring. 
#
# Changing this property requires restarting the Monitored Process
#introscope.nativeprofiler.ngen.monitor.enabled=true

# Following property limits the cache size to the number of classes being
# cached. If the cache size is hit an entry of cache saturation will be logged
# in nativeprofiler.log. Default value is 5000 
#
# Changing this property requires restarting the Monitored Process
#introscope.nativeprofiler.directivematching.cache.max.size=5000

# .NET 4.0 specific property which disables the transparency check. If the
# following property set to true the modified IL code runs under full trust
# similar to .NET 2.0 runtime. 
#
# Changing this property requires restarting the Monitored Process
introscope.nativeprofiler.clrv4.transparency.checks.disabled=true

# Following property controls InProcess SxS CLR instances. The valid values are
# None,V2,V4 or v2.0.50727 and v4.0.30319 Default value is None which means the
# first supported CLR is instrumented. 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.nativeprofiler.monitor.inprocsxs.multiple.clrs=V2,V4

# Directives Files 
#
# ================
# This property specifies all the directives files that determine how Introscope
# AutoProbe performs the instrumentation.  Specify a single entry, or a
# comma-delimited list of entries. The list may include any combination of: 
# - directives (.pbd) files 
# - directives list (.pbl) files  
# - directories that will be scanned for .pbd files.  Directives files placed in
# a listed directory will be loaded automatically, without any need to edit this
# Agent profile. Non-absolute names will be resolved relative to the location of
# this properties file. IMPORTANT NOTE: This is a required parameter and it MUST
# be set to a valid value. 
# - If the property is not specified or the values are invalid,  the Introscope
# Agent will not run! 
# - If the property is set to include a directory, and invalid  directives files
# are placed in the directory, AutoProbe 
# metrics will no longer be reported! 
# - If the property is set to include a directory, and loaded  directives files
# are removed from the directory, AutoProbe 
# metrics will no longer be reported! You must restart the managed application
# before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.autoprobe.directivesFile=default-full.pbl

# List of ignored PBD files that are not yet supported on .NET Framework The
# listed files will still be loaded on .NET Core 
#
# Changing this property requires restarting the Monitored Process
introscope.autoprobe.dotnetframework.ignoreDirectivesFile=ef.pbd

# List of ignored PBD files that are not yet supported on .NET Core The listed
# files will still be loaded on .NET Framework 
#
# Changing this property requires restarting the Monitored Process
#introscope.autoprobe.dotnetcore.ignoreDirectivesFile=

# AcceptController (AcceptController is only applicable on AutoProbe profiler. 
# It is NOT available with NativeProfiler) 
#
# ================
# This property controls whether AcceptController will be enabled.  Accept-
# Controller is a feature that reduces application startup time.  It could be
# automatically turned off by using certain directives.  There is no functional
# effect of turning AcceptController on or off, only performance effects. By
# default, AcceptController is enabled in AutoProbe profiler. 
#
# Changing this property requires restarting the Monitored Process
#introscope.autoprobeconnector.acceptcontroller.enable=true

# Agent Properties    # Logging Configuration 
#
# ================
# The following property points to the Log4Net config file You must restart the
# managed application before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.log.config.path=logging.config.xml

# These properties will override values defined in the logging.config.xml
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.log.level=INFO

# Changing this property requires restarting the Monitored Process
#introscope.agent.log.max.file.size=200MB

# Changing this property requires restarting the Monitored Process
#introscope.agent.log.max.roll.backups=4

# DNS lookup configuration 
#
# Agent has following DNS lookup implementations: ?direct? and ?separateThread?.
# Implementation to use is specified by value of
# introscope.agent.dns.lookup.type property. ?direct? performs DNS lookups in
# application thread. Application thread will be delayed by length of time the
# underlying DNS mechanism takes to perform a specific lookup. ?separateThread?
# performs DNS lookups in a separate thread. The application thread is delayed
# at most by introscope.agent.dns.lookup.max.wait.in.milliseconds milliseconds.
# When using ?separateThread? implementation, if lookup of host name by IP
# address times out, IP address will be returned in place of name and if lookup
# of IP address by host name times out, empty IP address will be returned.
# Default DNS lookup implementation is ?separateThread? 
#
# You must restart the managed application before change to this property takes
# effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.dns.lookup.type=direct

# Changing this property requires restarting the Monitored Process
#introscope.agent.dns.lookup.type=separateThread

# Maximum time in milliseconds ?separateThread? implementation waits to lookup a
# host name or IP address. It is ignored by ?direct? implementation.  Default
# value is 200. Change to this property takes effect immediately and does not
# require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.dns.lookup.max.wait.in.milliseconds=200

# Enterprise Manager Failback Retry Interval 
#
# ================
# When the Agent is configured to have multiple Enterprise Managers in its
# connection order and this property is enabled, the Introscope Agent will
# automatically attempt to connect to the Enterprise Manager in its connection
# order to which it can connect in allowed mode. In case no such Enterprise
# Manager is found, the reconnection attempt will occur on a regular interval as
# specified. Agent will not connect to any Enterprise Manager in disallowed
# mode, when this property is enabled. You must restart the managed application
# before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.enterprisemanager.failbackRetryIntervalInSeconds=120

# Custom Process Name 
#
# ================
# Specify the process name as it should appear in the Introscope Enterprise
# Manager and Workstation. You must restart the managed application before
# changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.customProcessName=CustomProcessName

# Default Process Name 
#
# ================
# If no custom process name is provided and the agent is unable to determine the
# name of the main application class, this value will be used for the process
# name. You must restart the managed application before changes to this property
# take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.defaultProcessName=.NET Process

# Agent Name 
#
# ================
# Specify the name of this agent as it appears in the Introscope Enterprise
# Manager and Workstation. You must restart the managed application before
# changes to this property take effect. This enables/disables auto naming of the
# agent using a custom service. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.agentAutoNamingEnabled=true

# This property if true names the agent same as web site name. Enable this
# property if there is only one application configured to run with one website.
# The default value is false. However if no good name evaluated for agent it
# will use website name irrespective of the value of the following property. You
# must restart the managed application for this property to take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.dotnet.naming.sitename.enabled=false

# This property if true names the application name as web site name only if no
# good application name is evaluated. The default value is false. You must
# restart the managed application for this property to take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.dotnet.appnaming.sitename.enabled=true

# The amount of time to delay connecting to the Introscope Enterprise Manager
# while Agent Auto Naming is attempted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.agentAutoNamingMaximumConnectionDelayInSeconds=120

# When Agent Auto Naming is enabled, the Agent will check for a new name based
# on the runtime environment on the specified interval. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.agentAutoRenamingIntervalInMinutes=10

# Auto name of log files (Agent and AutoProbe) with the Agent name or a
# timestamp can be disabled by setting the value of this property to 'true'. 
# Log file auto naming only takes effect when the Agent name can be determined
# using an Environment Variable or based on the current runtime. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.disableLogFileAutoNaming=false

# Uncomment this property to provide a default Agent Name if the other methods
# fail. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.agentName=AgentName

# Use this property if you want to specify the Agent Name using the value of
# certain System Property. 
#
# Changing this property requires restarting the Monitored Process 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.agentNameSystemPropertyKey=

# Fully Qualified Domain Name (FQDN) can be enabled by setting this property
# value to 'true'. By Default (false) it will display HostName. Set to 'true'
# when integrating with Catalyst. You must restart the managed application
# before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.display.hostName.as.fqdn=false

# Application Naming 
#
# This property allows to specify a custom application name for all the
# applications monitored by this agent. This property is not configured by
# default. 
#
# Changing this property does not require restarting the Monitored Process 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.application.name=

# Agent Socket Rate Metrics 
#
# ================
# Set to true to enable the reporting of input and output bandwidth rate metrics
# for individual sockets. You must restart the managed application before
# changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.sockets.reportRateMetrics=true

# Agent Memory Overhead Setting 
#
# ======================= 
# Set to true if you want to attempt to reduce the agent memory overhead
# introduced by architectural improvements to the 8.x Agent. Increased Agent
# memory overhead only occurs in certain extreme cases. The trade-off for the
# possible lower memory consumption is a possible increase in response time.
# Each application is unique and will experience different variations in Memory
# vs. Response Time trade-offs. This property is set to false by default and out
# of the box is commented out. This is not a hot property and the managed
# application needs to be restarted for this flag to take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.reduceAgentMemoryOverhead=true

# Agent Extensions Directory 
#
# ================
# This property specifies the location of all extensions to be loaded by the
# Introscope Agent.  Non-absolute names are resolved relative to the location of
# this properties file. You must restart the managed application before changes
# to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.extensions.directory=extensions

# Changing this property requires restarting the Monitored Process
introscope.agent.ext.directory=ext

# Agent Thread Priority 
#
# ================
# Controls the priority of agent threads.  Varies from 0 (low) to 4 (high).
# Default value if unspecified is Thread.ThreadPriority.Normal (2) 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.thread.all.priority=2

# Cloned Agent Configuration 
#
# ================
# Set to true when running identical copies of an application on the same
# machine. You must restart the managed application before changes to this
# property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.clonedAgent=false

# Restricted Instrumentation 
#
# =========================== 
# Enable/Disable instrumentation for targeted set of processes. By Default,
# there is no restriction on instrumentation.  In other words, every managed
# application and application pools (for IIS 6.0 or later) will be instrumented
# if the properties are not set (or commented out). To restrict instrumentation
# to ASP.NET applications only, set the property
# introscope.agent.dotnet.monitorApplications to w3wp.exe for IIS 6.0 or later
# and aspnet_wp.exe for IIS 5.  Add additional executable names to the list to
# instrument them. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.dotnet.monitorApplications=w3wp.exe,aspnet_wp.exe

# Uncomment the following property and specify IIS application pools to be
# instrumented. Application pool names must be in quotes. Use "NULL" to specify
# applications not running in any application pool. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.dotnet.monitorAppPools="NULL","DefaultAppPool","AppPool1","AppPool2"

# This property if enabled filters the agent to load or not in the specified app
# domain, website name or virtual directory name. Uncomment the following
# property to enable the agent filtering. Default is false. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.dotnet.agentfilter.enabled=true

# Following property is comma separated list of patterns which if matched with
# the Web Site name , application domain name (in case of the console
# applications), Virtual Directory names, the agent will not be loaded. In
# practical, the property is list of the RegEx agent name patterns which user
# wants to disable. Default is no exclusion. Exclusion has the precedence over
# inclusion this means if the exlusion is successful no check for inclusion. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.dotnet.agentfilter.pattern.excludes=None

# Following property is comma separated list of patterns which if matched with
# the Web Site name , application domain name (in case of the console
# applications), Virtual Directory names, the agent will not be loaded. In
# practical, the property is list of the agent name patterns which user wants to
# enable. Default is load all the agents if the exclusion fails. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.dotnet.agentfilter.pattern.includes=*.*

# PerfMon Configuration 
#
# ================
# Properties controlling Perfmon metric collection. You must restart the "CA APM
# PerfMon Collector Service" for the PerfMon properties to take effect. Counter
# expressions are separated by commas.  New counters (e.g.
# |Thread|{osprocessname}*|*) can be appended to the list. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.perfmon.metric.filterPattern=|Processor|*|*,|.NET Data Provider*|*|*,|.NET CLR*|{osprocessname}|*,|.NET CLR Data|*|*,|Process|{osprocessname}|*,|ASP.NET*|*

# Counter expressions that are reported as average values (default:
# LongCounter). Wildcard is only supported at beginning or end, e.g. */sec
# matches all counters that end with "/sec".
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.perfmon.metric.filterPattern.average=*/sec,Avg*,%*,*Length,Connections*,*Connections,*Rate,*Time,*Current Bandwidth,*Free Megabytes,*Running

# Maximum number of Perfmon metrics reported in each interval.
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.perfmon.metric.limit=1000

# Intervals in which Perfmon metrics are collected.  Default is 15 seconds.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.perfmon.metric.pollIntervalInSeconds=15

# Intervals in which new Perfmon categories are discovered.  Default is 600
# seconds (or 10 minutes).
#
# Changing this property requires restarting the Monitored Process
introscope.agent.perfmon.category.browseIntervalInSeconds=600

# Flag to enable/disable new Perfmon category discovery.  Default is true
# (enabled).
#
# Changing this property requires restarting the Monitored Process
introscope.agent.perfmon.category.browseEnabled=true

# Uncomment the following property to get the Perfmon metrics in US English. By
# default The PerfMon metrics are named as par the locale of the operating
# system. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.perfmon.culture.english.enabled=true

# SQL Agent Configuration 
#
# ================
# Configuration settings for Introscope SQL Agent ## Turns off metrics for
# individual SQL statements. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.turnoffmetrics=false

# Report only Average Response Time metric for individual SQL statements
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.artonly=false

# Turn off transaction tracing individual sql statements. They will not be
# from be reported in Transaction Trace.
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.turnofftrace=false

# Unnormalized sql will appear as parameter for Sql components in Transaction
# Trace # Caution: enabling this property may result in passwords and sensitive
# information to be presented in Transaction Trace 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.rawsql=false

# SQL Agent Param Configuration 
#
# ================
# Configuration settings for Introscope SQL Agent ## Enable SQL parameter
# tracing 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.params=false

#### Set number of params to show. It will work only if sql.params is true.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.sqlagent.sql.params.count=5

#### Set max length of the sting param value.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.sqlagent.sql.params.value.maxlimit=256

# SQL Agent Normalizer extension 
#
# ================
# Configuration settings for SQL Agent normalizer extension Specifies the name
# of the sql normalizer extension that will be used to override the
# preconfigured normalization scheme. To make custom normalization extension
# work, the value of its manifest attribute
# com-wily-Extension-Plugin-{pluginName}-Name should match with the value given
# to this property. If you specify a comma separated list of names, only the
# first name will be used. Example, 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.extension=ext1, ext2

# Only ext1 will be used for normalization. By default we now ship the
# RegexSqlNormalizer extension Changes to this property take effect immediately
# and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.extension=RegexSqlNormalizer

# RegexSqlNormalizer extension 
#
# ==================
# The following properties pertain to RegexSqlNormalizer which uses regex
# patterns and replace formats to normalize the sql in a user defined way. This
# property if set to true will make sql strings to be evaluated against all the
# regex key groups. The implementation is chained. Hence, if the sql matches
# multiple key groups, the normalized sql output from group1 is fed as input to
# group2 and so on. If the property is set to 'false', as soon as a key group
# matches, the normalized sql output from that group is returned Default value
# is 'false' 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.matchFallThrough=true

# This property specifies the regex group keys. They are evaluated in order
# Changes to this property take effect immediately and do not require the
# managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.keys=key1

# This property specifies the regex pattern that will be used to match against
# the sql. All valid regex alowed by System.Text.RegularExpressions namespace
# can be used here. Changes to this property take effect immediately and do not
# require the managed application to be restarted. eg: (\\b[0-9,.]+\\b) will
# filter all number values, ('.*?') will filter anything between single quotes,
# ((?i)\\bTRUE\\b|\\bFALSE\\b) will filter boolean values from the query. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.key1.pattern=(".*?")|('.*?')|(\\b[0-9,.]+\\b)|((?i)\\bTRUE\\b|\\bFALSE\\b)

# This property if set to 'false' will replace the first occurrence of the
# matching pattern in the sql with the replacement string. If set to 'true' it
# will replace all occurrences of the matching pattern in the sql with
# replacement string Changes to this property take effect immediately and do not
# require the managed application to be restarted. Default value is 'false' 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.key1.replaceAll=true

# This property specifies the replacement string format. All valid regex allowed
# by System.Text.RegularExpressions namespace can be used here. eg: The default
# normalizer replaces the values with a question mark (?) Changes to this
# property take effect immediately and do not require the managed application to
# be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.key1.replaceFormat=?

# This property specifies whether the pattern match is sensitive to case Changes
# to this property take effect immediately and do not require the managed
# application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.key1.caseSensitive=false

# Transaction Tracer Configuration 
#
# ================
# Configuration settings for Introscope Transaction Tracer The following
# settings configure Transaction Tracer to optionally capture the user ID used
# to invoke frontend components if it is stored in one of the three following
# ways.  Uncomment the set of properties that correspond to how user IDs are
# stored in your application. Make sure only one set of properties are
# uncommented or the wrong properties could be used. You must restart the
# managed application before changes to this property take effect. Uncomment the
# following property if the user ID is accessed through the Http Context
# identity 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.transactiontracer.userid.method=HttpContext.User.Identity.Name

# Uncomment the following property if the user ID is accessed through the URL
# user info
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.userid.method=HttpContext.Request.Uri.UserInfo

# Uncomment the following properties if the user ID is an Http  request header
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.userid.method=HttpRequest.Headers.Get

# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.userid.key=<application defined key string>

# Uncomment the following properties if the user ID is an attribute in the Http
# Session
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.userid.method=HttpContext.Session.Contents

# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.userid.key=<application defined key string>

# Uncomment the following properties to record specific http request headers,
# parameters or session attributes in the Transaction Tracer data. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.parameter.httprequest.headers=User-Agent

# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.parameter.httprequest.parameters=parameter1,parameter2

# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.parameter.httpsession.attributes=attribute1,attribute2

# Uncomment the following property to specify the maximum number of components
# allowed in a Transaction Trace.  By default, the clamp is set at 5000. Note
# that any Transaction Trace exceeding the clamp will be discarded at the agent,
# and a warning message will be logged in the Agent log file. Warning: If this
# clamp size is increased, the requirement on the memory will be higher and as
# such. Changes to this property take effect immediately and do not require the
# managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontrace.componentCountClamp=5000

# Uncomment the following property to specify the maximum depth of components
# allowed in head filtering, which is the process of examining the start of a
# transaction for the purpose of potentially collecting the entire transaction. 
# Head filtering will check until the first blamed component exits, which can be
# a problem on very deep call stacks when no clamping is done.  The clamp value
# will limit the memory and CPU utilization impact of this behavior by forcing
# the agent to only look up to a fixed depth.  By default, the clamp is set at
# 30. Note that any Transaction Trace whose depth exceeds the clamp will no
# longer be examined for possible collection UNLESS some other mechanism, such
# as sampling or user-initiated transaction tracing, is active to select the
# transaction for collection. Warning: If this clamp size is increased, the
# requirement on the memory will be higher and as such, garbage collection
# behavior may be affected, which will have an application-wide performance
# impact. Changes to this property take effect immediately and do not require
# the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontrace.headFilterClamp=30

# Use compression to reduce the size of cross process tracing data. This option
# will increase agent CPU overhead, but reduce the size of interprocess headers.
# Valid options are lzma or none Note that Java agents also support gzip option,
# so if interoperability is required make sure they do not use gzip. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.crossprocess.compression=lzma

# Minimum length of cross process parameter data length for which to apply
# compression
#
# Changing this property requires restarting the Monitored Process
introscope.agent.crossprocess.compression.minlimit=1500

# Maximum size of cross process parameter data allowed. If total size of cross
# process parameter even after applying compression (if allowed) is more than
# this limit, some data will be dropped and some cross process correlation
# functionality will not work properly. However, this settings will protect user
# transactions from failing in network transmission due to too large header
# size. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.crossprocess.correlationid.maxlimit=4096

# Changes to above 3 properties take effect immediately and do not require the
# managed application to be restarted Uncomment the following property to
# disable Transaction Tracer Sampling Changes to this property take effect
# immediately and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.sampling.enabled=false

# The following property limits the number of transactions that are reported by
# the agent per reporting cycle. The default value if the property is not set is
# 50. You must restart the managed application before changes to this property
# take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.ttClamp=50

# TT Sampling 
# ================
# These are normally configured in the EM. Configuring in the Agent disables
# configuring them in the EM You must restart the managed application before
# changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.sampling.perinterval.count=1

# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.sampling.interval.seconds=120

# Deep Instrumentation 
# ================
#
# Enables and disables deep transaction trace visibility. The default value is
# true. You must restart the managed application before changes to this property
# take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.deep.instrumentation.enabled=true

# Controls the sampling rate of trace profiling. You must restart the managed
# application before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.deep.instrumentation.sampling.interval.ms=100

# Controls the call stack limits of trace profiling. You must restart the
# managed application before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.deep.instrumentation.max.stacks=256

# Enables and disables the agent ability to collect deep transaction traces and
# send the data to the Enterprise Manager. The default value is true. Changes to
# this property take effect immediately and do not require the managed
# application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.deep.instrumentation.trace.enabled=true

# Excludes the namespace, class and method for deep transaction traces. You may
# specify as many as you like (using .0, .1, .2 ...). You may use wildcards (*).
# The following are examples only. Changes to this property take effect
# immediately and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.deep.instrumentation.class.exclude.0=*namespacename*

# Includes the namespace, class and method for deep transaction traces. You may
# specify as many as you like (using .0, .1, .2 ...). You may use wildcards (*).
# The following are examples only. Changes to this property take effect
# immediately and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.deep.instrumentation.class.include.0=*method*

# Enables and disables the agent ability to collect 5 minutes deep transaction
# trace data, and create deep instrumentation sample pbd file. The default value
# is false. Changes to this property take effect immediately and do not require
# the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.deep.instrumentation.pbd.generate=false

# Enabling Collection of Filtered Parameters 
# ================
# By default, the .NET Agent reports only the URL for transactions it traces.
# Reporting of individual HTTP properties is restricted to minimize the impacts
# of transaction tracing on system overhead. To enable filtering you must first
# enable collection of HTTP properties, by setting this property to false. By
# default this property is set to true. Enables collection of: Application Name,
# Context Path, URL You must restart the managed application before changes to
# this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.asp.disableHttpProperties=false

# Agent Metric Clamp Configuration 
#
# ================
# The following setting configures the Agent to approximately clamp the number
# of metrics sent to the EM If the number of metrics pass this metric clamp
# value then no new metrics will be created.  Old metrics will still report
# values. The value must be equal to or larger than 1000 to take effect. Lower
# value will be rejected. The default value is 5000. You must restart the
# managed application before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.metricClamp=5000

# Cross Process Transaction Trace 
# ===============================
# This property controls whether the presence of a tail filter triggers
# automatic collection of traces from downstream agents or not. This property
# does not affect collection of automatic downstream traces due to passing of
# head filters. It is enabled by default. Enabling this property and running
# long periods of Transaction Trace session with tail filters can cause large
# number of traces to be sent to the EM Set the property to false to disable
# automatic collection of downstream traces due to tail filter. You must restart
# the managed application before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.transactiontracer.tailfilterPropagate.enable=true

# URL Grouping Configuration 
#
# ================
# Configuration settings for Frontend naming.  By default, all frontends go into
# the "Default" group.  This is done so that invalid URLs (i.e. those that would
# generate a 404 error) do not create unique, one-time metrics -- this can bloat
# the EM's memory.  To get more meaningful metrics out of the
# Frontends|Apps|URLs tree, set up URL groups that are relevant to the
# deployment Changes to this property take effect immediately and do not require
# the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.keys=resources,default

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.group.resources.pathprefix=*/bundle*

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.group.resources.format=Resources

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.group.default.pathprefix=*

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.group.default.format={path_delimited:/:0:5}

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.frontend.url.resources.list=tif,tiff,jpg,jpeg,gif,png,bmp,bmpf,ico,cur,xbm,svg,img,css,woff,nil

# Clamp on the total number of URLs under Frontends|Apps|URLs tree. It includes
# the normalized/unnormalized paths.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.frontend.url.clamp=5

# Configuration settings for Backend URL Path naming.  By default, all HTTP
# backends URL paths go into the "Default" group. This is a hot property. It is
# applicable to the metric path tree: Backends|WebService at
# {protocol}_//{host}_{port}|Paths 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.backendpathgroup.keys=default

# Changing this property requires restarting the Monitored Process
introscope.agent.backendpathgroup.group.default.pathprefix=*

# Changing this property requires restarting the Monitored Process
introscope.agent.backendpathgroup.group.default.format={path_delimited:/:0:5}

# Clamp on the total number of URLs under Backends|WebService at
# {protocol}_//{host}_{port}|Paths. It includes the normalized/unnormalized
# paths.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.backend.url.clamp=5

# Synthetic Transaction Configuration 
#
# ================
# Configuration settings for synthetic transaction monitoring. Parameter
# introscope.agent.synthetic.header.names defines name(s) of HTTP headers that
# indicate a synthetic transaction.  Individual names are separated by commas. 
# If undefined, or empty string, synthetic transactions are not detected.  If
# multiple values defined, they are checked in order until a header is found
# which has non-null, non-empty value.  The header value will be used to create
# synthetic transaction name (and thus node name(s) under which metrics for the
# transaction) as follows: If header name is 'lisaframeid', the transaction name
# 'LISA' will be used.  If header name is anything other than 'lisaframeid' or
# 'x-wtg-info', value of header (with appropriate modification to ensure node
# name is valid) will be used as synthetic transaction name.  If header name is
# 'x-wtg-info', the header value is expected to contain sequence of atributes as
# name, value pairs separated by amperands symbols.  Attribute name and value
# within each pair, are separated by equals sign.  The values of 'group',
# 'name', 'ipaddress' and 'request_id' attributes, separated by '|', are used to
# form synthetic transaction name.   For example the x-wtg-info header: clear
# synthetic=true&instance=ewing&name=sample&group=SampleGroup&version=4.1.0&ipaddress=192.168.193.1&sequencenumber=1&request_id=start&executiontime=1226455047
# would result in metrics being reported under node
# 'SampleGroup|sample|192.168.193.1|start'.  Any attributes which are not
# defined in x-wtg-info header have default values supplied as follows:
# group=unknownGroup, name=unknownScript, 
#
# Changing this property requires restarting the Monitored Process
#ipaddress=0.0.0.0 and request_id=Action.  Final node name is modified if required to ensure it is valid.

# Changes to this property take effect immediately and do not require the
# managed application to be restarted.
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.synthetic.header.names=Synthetic_Transaction,x-wtg-info,lisaframeid

# The following configuration parameters with names starting
# 'introscope.agent.synthetic.' are ignored if parameter
# introscope.agent.synthetic.header.names is undefined. Parameter
# introscope.agent.synthetic.user.name defines name of HTTP header whose value
# holds name of synthetic user.  If undefined, nodes for each unique synthetic
# user will not be created.  Synthetic user names will be modified if required
# to ensure they are valid node names. Changes to this property take effect
# immediately and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.synthetic.user.name=Synthetic_Trace_By_Vuser

# Node under which transactions recognised as synthetic are reported.  This node
# will be located under `Frontends|Apps|<WebAppName>` where `<WebAppName>` is
# web application name.  Defaults to 'Synthetic Users' Changes to this property
# take effect immediately and do not require the managed application to be
# restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.synthetic.node.name=Synthetic Users

# Node under which transactions not recognised as synthetic are reported..  This
# node will be located under `Frontends|Apps|<WebAppName>` where `<WebAppName>`
# is web application name.  If not defined, no additional node under
# `<WebAppName>` is created. Changes to this property take effect immediately
# and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.non.synthetic.node.name=Real Users

# Stall Configuration 
#
# ================
# Configuration settings for stall detection Minimum threshold for stall event
# duration Changes to this property take effect immediately and do not require
# the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.stalls.thresholdseconds=30

# Frequency that the agent checks for stall events Changes to this property take
# effect immediately and do not require the managed application to be restarted.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.stalls.resolutionseconds=10

# Ignore properties let the user specify particular collections that should be
# ignored by leakhunter. For Generic collections, use a syntax that includes the
# generic type qualification like System.Collections.Generic.List`1 Changes to
# this property take effect immediately and do not require the managed
# application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.leakhunter.ignore.0=

# Error Detector Configuration 
#
# ================ 
# Configuration settings for Error Detector You must restart the managed
# application before changes to this property take effect. Please include
# errors.pbd in your pbl (or in introscope.autoprobe.directivesFile) The error
# snapshot feature captures transaction details about serious errors and enables
# recording of error count metrics. Changes to this property take effect
# immediately and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.errorsnapshots.enable=true

# The following setting configures the maximum number of error snapshots that
# the Agent can send in a 15-second period. Changes to this property take effect
# immediately and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.errorsnapshots.throttle=10

# The following series of properties lets you specify error messages to ignore. 
# Error snapshots will not be generated or sent for errors with messages
# matching these filters.  You may specify as many as you like (using .0, .1, .2
# ...). You may use wildcards (*). The following are examples only. Changes to
# this property take effect immediately and do not require the managed
# application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.errorsnapshots.ignore.0=*com.company.HarmlessException*

# Changing this property requires restarting the Monitored Process
#introscope.agent.errorsnapshots.ignore.1=*HTTP Error Code: 404*

# Agent Metric Aging 
# ==============================
# Detects metrics that are not being updated consistently with new data and
# removes these metrics. By removing these metrics you can avoid metric
# explosion. Metrics that are in a group will be removed only if all metrics
# under this group are considered candidates for removal. BlamePointTracer
# metrics are considered a group. 
#
# Enable/disable the metric agent aging feature. Changes to this property take
# effect immediately and do not require the managed application to be restarted.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.metricAging.turnOn=true

# You can choose to ignore metrics from removal by adding the metric name or
# metric filter to the list below. Changes to this property take effect
# immediately and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.metricAging.metricExclude.ignore.0=

# HTTP Header Decorator 
# =======================================
# On/Off Switch 
#
# ================
# If this Boolean value is set to true, it configures the agent to add
# additional performance monitoring information to HTTP response headers. 
# HTTPHeaderDecorator attaches the GUID to each transaction and inserts the GUID
# into an HTTP header, x-wily-info This enables the correlation of transaction
# between Wily CEM and Wily Introscope 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.decorator.enabled=false

# Security 
#
# Determine the format of decorated HTTP response headers, which are sent to
# Wily CEM. clear - clear text encoding encrypted - header data is encrypted
# default is encrypted 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.decorator.security=encrypted

# Primary network interface selector 
#
# Agent reports details of host computer's primary interface (IP address, MAC
# address, host & domain name). If following property is unset, agent will
# attempt to determine an appropriate interface as the primary interface.  If an
# alternate interface is required, uncomment following property and specify
# required interface identity. Change to this property takes effect immediately
# and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.primary.net.interface.name=Local Area Connection.0

# Remote Dynamic Instrumentation Settings 
#
# ================
# Configuration settings for remote dynamic instrumentation Enable/disable the
# remote management of dynamic instrumentation You must restart the managed
# application before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.remoteagentdynamicinstrumentation.enabled=false

# Default Backend Legacy 
#
# The default backend feature behavior has changed to include methods marked as
# frontend in the detection of socket calling. The following property will set
# the default backend detection to run as in 9.0.x release. By default, the
# value of the property of false. You must restart the managed application
# before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.configuration.defaultbackends.legacy=false

# Transaction Structure aging properties 
#
# ================
# This property is to evaluate the number of elements in the transaction
# structure at the period interval, to determine if "emergency aging" is
# required. Default value is "30000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.creation.checkperiod=30000

# This property specifies the period in milliseconds that the aging for the
# transaction structure is checked, Default value is "30000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.aging.checkperiod=30000

# This property specifies the minimum amount in milliseconds that a tree in the
# transaction structure must be inactive before it is purged. The inactivity
# does not imply that it will be aged out. Default value is "60000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.aging.period=60000

# This property sets the maximum percentage increment in the size of the
# structure that is allowed to happen before aging of the transaction structure
# is forced If the change in the number of nodes between the aging periods is
# more than this percentage value, then checking for aging occurs if set to a
# small value, the transaction structure will be aged more frequently, and the
# memory utilization of the agent will be therefore kept lower. Default value is
# "5", i.e. 5% 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.aging.attentionlevel.percentage=5

# This property sets the maximum absolute increment in the size of the structure
# that is allowed to happen before aging of the transaction structure is forced
# If the change in the number of nodes between the aging periods is more than
# this percentage value, then checking for aging occurs if set to a small value,
# the transaction structure will be aged more frequently, and the memory
# utilization of the agent will be therefore kept lower. Default value is
# "100000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.attentionlevel.absolute=100000

# This property is used to avoid spikes in memory utilization of the transaction
# structure. If there is an increase of elements at any time bigger than a third
# of this value, then "emergency aging" occurs immediately. Emergency aging will
# agent parts of the transaction structures that are younger than the value
# specified in com.wily.introscope.agent.harvesting.transaction.aging.period, 
# and will likely reduce the amount of data sent by the agent. Only modify this
# value if the memory requirement are very strict. Default value is "100000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.creation.attentionlevel.absolute=100000

# This property specifies the maximum duration in milliseconds of the aging
# process. It is used to avoid long aging process when resources available are
# not sufficient. default value if 30000 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.aging.duration.max=30000

# Transaction Structure properties 
#
# ================
# Enable/disable to shut down globally the transaction trace feature. Default
# value is "true" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.transaction.doTransactionTrace=true

# Enable/disable high concurrency mode for all repositories. Set to true, it
# will use more memory but may give more throughput Default value is "false" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.highconcurrency.enabled=false

# This property defines the number of stripes in the striped repositories It
# works when the high concurrency mode is on, which is
# "com.wily.introscope.agent.blame.highconcurrency.enabled=true" Default value
# is "16" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.highconcurrency.stripes=16

# Enable/disable to removes stalls from all traces, and remove stall feature
# altogether. Default value is "true" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.stall.trace.enabled=true

# Browser Agent Business Transaction Monitoring properties This property turns
# on/off the automatic injection of BRTM JavaScript snippet in the HTML response
# from the server. Change to this property takes effect immediately and do not
# require the managed application to be restarted. The default value is false. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.browseragent.autoInjectionEnabled=false

# This property specifies the location of the javascript snippet file on disk
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.browseragent.snippetLocation=brtmsnippet.js

# This property specifies the value of the javascript snippet which will take
# precedence over the snippetLocation property 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.browseragent.snippetString=

# The next 3 properties are used to replace text in the JavaScript snippet file
# These properties are used to configure the host, port and protocol (http or
# https) of the DXC. These properties are not required when an AXA snippet is
# configured. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.browseragent.dxchost=

# Changing this property requires restarting the Monitored Process
#introscope.agent.browseragent.dxcport=80

# Changing this property requires restarting the Monitored Process
#introscope.agent.browseragent.ssl.enable=false

# Turn on/off the Browser Agent response cookie used for business transaction
# matching support and end to end transaction trace correlation Change to this
# property takes effect immediately and do not require the managed application
# to be restarted. The default value is false. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.browseragent.responseCookieEnabled=false

# This property specifies the expiration time of the browser agent response
# cookie in the browser. Change to this property takes effect immediately and do
# not require the managed application to be restarted. The default value is 3
# seconds. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.browseragent.responseCookie.expirationTime=3

# Comma separated set of keys used to specify regular expressions for matching
# URLs. URLs which match them will be injected with the BRTM JavaScript snippet.
# see example below 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.browseragent.autoInjection.appID=key1

# Changing this property requires restarting the Monitored Process
introscope.agent.browseragent.autoInjection.key1.includeURLsRegex=.*

# Additional data sent based on the useid cookie name
#
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.decorator.userid.cookie.name=

# Properties to activate sustainability metrics 
#
# ================
# Sustainability metrics are generated to provide information on the agent
# health and internal status. There is a substantial overhead associated with
# these metrics, and therefore, their usage is not suggested at this time in
# production environments. 
#
# Enable/disable to generate globally sustainability debug metrics. Set to true,
# it will generate globally sustainability debug metrics that can be used to
# evaluate the Transaction Structure Default value is "false" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.transactions.debugmetrics.enabled=false

# Enable/disable to generate sustainability metrics on the harvesting process.
# Default value is "false" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.debugmetrics.enabled=false

# This property is to generate the metrics for the health of the data structures
# in the agent. Default value is "false" 
#
# Changing this property requires restarting the Monitored Process
#concurrentMapPolicy.generatemetrics=false

# Allow Agent Extensions to work against any version of the Agent (not just the
# version the extension was compiled against) Default value is "true" 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.allowExtensionsForAnyVersion.enable=false

# Static Attribute Configurations 
#
# Changing this property requires restarting the Monitored Process 
#
# Changing this property requires restarting the Monitored Process
attribute.decoration.static.attributes.configurations=default

# Changing this property requires restarting the Monitored Process
#
# Changing this property requires restarting the Monitored Process
attribute.decoration.static.attributes.configurations.default.attributeName=

# Changing this property requires restarting the Monitored Process
#
# Changing this property requires restarting the Monitored Process
attribute.decoration.static.attributes.configurations.default.value=

# Application Attribute Configurations(Static) 
#
# Changing this property requires restarting the Monitored Process 
#
# Changing this property requires restarting the Monitored Process
attribute.decoration.application.configurations=default

# Changing this property requires restarting the Monitored Process
#
# Changing this property requires restarting the Monitored Process
attribute.decoration.application.configurations.default.attributeName=

# Changing this property requires restarting the Monitored Process
#
# Changing this property requires restarting the Monitored Process
attribute.decoration.application.configurations.default.value=


################################################################################
# Bundle: em-connection:21.4.0.26
################################################################################

# Changing this property requires restarting the Monitored Process
agentManager.credential=

# Changing this property requires restarting the Monitored Process
agentManager.url.1=


################################################################################
# PACKAGE DETAILS
# Tenant name =null
# Tenant id =-1
################################################################################
acc.package.id=70368744177872
acc.server.id=rBMAAzE2MTc5OTA0MDk
acc.package.name=.NET-dn-agent-20210409
acc.package.version=1
acc.package.truststore.hash=0
