########################################################################
#                                                                      
# Introscope Agent Configuration                         
#                                                                      
# DX APM Wily Introscope(R) Version 11.1.4 Release 11.1.4.31
# Copyright (c) 2019 Broadcom. All Rights Reserved.
# Introscope(R) is a registered trademark of DX APM.    
########################################################################


#######################
# Agent Properties    #
#######################


#################################
# Logging Configuration
#
# ================
# The following property points to the Log4Net config file
# You must restart the managed application before changes to this property take effect.

introscope.agent.log.config.path=logging.config.xml


#################################
# Enterprise Manager Connection Order
#
# ================
# The Enterprise Manager connection order list the Agent uses if it 
# is disconnected from its Enterprise Manager.
# You must restart the managed application before changes to this property take effect.

introscope.agent.enterprisemanager.connectionorder=DEFAULT


#################################
# Enterprise Manager Locations and Names 
# (names defined in this section are only used in the 
# introscope.agent.enterprisemanager.connectionorder property)
#
# ================
# Settings the Introscope Agent uses to find the Enterprise Manager 
# and names given to host and port combinations.
# You must restart the managed application before changes to this property take effect.

introscope.agent.enterprisemanager.transport.tcp.host.DEFAULT=localhost
introscope.agent.enterprisemanager.transport.tcp.port.DEFAULT=5001
introscope.agent.enterprisemanager.transport.tcp.socketfactory.DEFAULT=com.wily.isengard.postofficehub.link.net.DefaultSocketFactory


#################################
# Enterprise Manager Failback Retry Interval
#
# ================
# When the Agent is configured to have multiple Enterprise Managers
# in its connection order and this property is enabled, the Introscope 
# Agent will automatically attempt to reconnect to the first Enterprise
# Manager in its connection order when it is connected to any other
# Enterprise Manager. The reconnection attempt will occur on a regular
# interval as specified.
# You must restart the managed application before changes to this property take effect.

#introscope.agent.enterprisemanager.failbackRetryIntervalInSeconds=120


#######################
# Custom Process Name
#
# ================
# Specify the process name as it should appear in the
# Introscope Enterprise Manager and Workstation.
# You must restart the managed application before changes to this property take effect.

introscope.agent.customProcessName=SharePoint Monitor


#######################
# Default Process Name
#
# ================
# If no custom process name is provided and the
# agent is unable to determine the name of the
# main application class, this value will be
# used for the process name.
# You must restart the managed application before changes to this property take effect.

introscope.agent.defaultProcessName=.NET Process


#######################
# Agent Name
#
# ================
# Specify the name of this agent as it appears in the
# Introscope Enterprise Manager and Workstation.
# You must restart the managed application before changes to this property take effect.

# This enables/disables auto naming of the agent using
# a custom service.
introscope.agent.agentAutoNamingEnabled=false

# The amount of time to delay connecting to the Introscope Enterprise
# Manager while Agent Auto Naming is attempted.
introscope.agent.agentAutoNamingMaximumConnectionDelayInSeconds=120

# When Agent Auto Naming is enabled, the Agent will check for 
# a new name based on the runtime environment on the specified interval.
introscope.agent.agentAutoRenamingIntervalInMinutes=10

# Auto name of log files (Agent and AutoProbe) with
# the Agent name or a timestamp can be disabled by setting the 
# value of this property to 'true'.  Log file auto naming only 
# takes effect when the Agent name can be determined using an 
# Environment Variable or based on the current runtime.
introscope.agent.disableLogFileAutoNaming=false

# Uncomment this property to provide a default Agent Name 
# if the other methods fail.
introscope.agent.agentName=SharePoint Services and Event Monitor Agent



#######################
# Agent Thread Priority
#
# ================
# Controls the priority of agent threads.  Varies
# from 0 (low) to 4 (high). Default value if unspecified is Thread.ThreadPriority.Normal (2)

#introscope.agent.thread.all.priority=2




#######################
# PerfMon Configuration
#
# ================
# Properties controlling Perfmon metric collection.
# You must restart the managed application before changes to PerfMon properties take effect.

# System toggle to enable PerfMon metric collection.
introscope.agent.perfmon.enable=false

# Counter expressions are separated by commas.  New counters (e.g. |Thread|{osprocessname}*|*) can be appended to the list.
introscope.agent.perfmon.metric.filterPattern=|Processor|*|*,|.NET Data Provider*|*|*,|.NET CLR*|{osprocessname}|*,|.NET CLR Data|*|*,|Process|{osprocessname}|*,|ASP.NET*|*

# Counter expressions that are reported as average values (default: LongCounter). Wildcard is only supported at beginning or end, e.g. */sec matches all counters that end with "/sec".
#introscope.agent.perfmon.metric.filterPattern.average=*/sec,Avg*,%*,*Length,Connections*,*Connections,*Rate,*Time,*Current Bandwidth,*Free Megabytes,*Running

# Agent expression enable/disables Perfmon reporting in specific Agent processes.  By default, Perfmon metrics are collected on all Agents.
introscope.agent.perfmon.agentExpression=*|*

# Maximum number of Perfmon metrics reported in each interval.
#introscope.agent.perfmon.metric.limit=1000

# Intervals in which Perfmon metrics are collected.  Default is 15 seconds.
introscope.agent.perfmon.metric.pollIntervalInSeconds=15

# Intervals in which new Perfmon categories are discovered.  Default is 600 seconds (or 10 minutes).
introscope.agent.perfmon.category.browseIntervalInSeconds=600




################################
# Agent Metric Aging
# ==============================
# Detects metrics that are not being updated consistently with new data and removes these metrics.
# By removing these metrics you can avoid metric explosion.    
# Metrics that are in a group will be removed only if all metrics under this group are considered candidates for removal.
# BlamePointTracer metrics are considered a group.  
#
# Enable/disable the metric agent aging feature. 
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.metricAging.turnOn=true
# You can choose to ignore metrics from removal by adding the metric name or metric filter to the list below.  
# Changes to this property take effect immediately and do not require the managed application to be restarted.
#introscope.agent.metricAging.metricExclude.ignore.0=

