########################################################################
#                                                                      
# Introscope AutoProbe and Agent Configuration                         
#                                                                      
# DX APM Wily Introscope(R) Version 20.6.0 Release 20.6.0.44
# Copyright (c) 2020 Broadcom. All Rights Reserved.
# Introscope(R) is a registered trademark of DX APM.
########################################################################

########################
# AutoProbe Properties #
#
# On/Off Switch
#f
# ================
# This boolean property gives you the ability to disable
# Introscope AutoProbe by settings the property value
# to false.
# You must restart the managed application before changes to this property take effect.

introscope.autoprobe.enable=true


#######################
# Custom Log File Location
#
# ================
# Introscope AutoProbe will always attempt to log the changes
# it makes.  Set this property to move the location of the
# log file to something other than the default.  Non-absolute
# names are resolved relative to the location of this
# properties file.
# You must restart the managed application before changes to this property take effect.

introscope.autoprobe.logfile=logs/AutoProbe.log

# NativeProfiler will log information about the directives it read and the 
# method it instrumented in this log file.
introscope.nativeprofiler.logfile=logs/nativeprofiler.log

# NativeProfiler will list the instrumented byte-code if this property is
# set to true.  It is set to false by default.
#introscope.nativeprofiler.logBytecode=false

# NativeProfiler will log all methods noticed, even uninstrumented ones
# if this property is enabled. It is disabled by default
#introscope.nativeprofiler.logAllMethodsNoticed=false

# If you get native profiler log and still .NET agent does not start
# enable the following property. This will use the generic trigger.
# Note if you enable this property you could see defaut domain also being probed
# however if the agent is in restricted mode (which is default) the agent will not connect to EM.
# In ProcSxS Agent names will appear like <ProcessName>_<ApplicationDomainName>
#introscope.nativeprofiler.generic.agent.trigger.enabled=false

##############################################
# Native Profiler Startup Bubble Improvement

# Following property if set to false, disables the ngen monitoring. 
#introscope.nativeprofiler.ngen.monitor.enabled=true

# Following property limits the cache size to the number of classes being cached.
# If the cache size is hit an entry of cache saturation will be logged in 
# nativeprofiler.log. Default value is 5000

#introscope.nativeprofiler.directivematching.cache.max.size=5000

##############################################

##############################################
#
# .NET 4.0 specific property which disables the transparency check.
#  If the following property set to true the modified IL code runs under
#  full trust similar to .NET 2.0 runtime.

introscope.nativeprofiler.clrv4.transparency.checks.disabled=true


#Following property controls InProcess SxS CLR instances. 
#The valid values are None,V2,V4 or v2.0.50727 and v4.0.30319
#Default value is None which means the first supported CLR is instrumented.

#com.wily.introscope.nativeprofiler.monitor.inprocsxs.multiple.clrs=V2,V4

##############################################

#######################
# Directives Files
#
# ================
# This property specifies all the directives files that determine
# how Introscope AutoProbe performs the instrumentation.  Specify
# a single entry, or a comma-delimited list of entries. The list 
# may include any combination of:
#    - directives (.pbd) files
#    - directives list (.pbl) files 
#    - directories that will be scanned for .pbd files. 
#      Directives files placed in a listed directory will be loaded automatically, 
#      without any need to edit this Agent profile.    
# Non-absolute names will be resolved relative to the location of 
# this properties file.
# IMPORTANT NOTE: This is a required parameter and it MUST be set
# to a valid value.  
#    - If the property is not specified or the values are invalid, 
#      the Introscope Agent will not run!  
#    - If the property is set to include a directory, and invalid 
#      directives files are placed in the directory, AutoProbe  
#      metrics will no longer be reported!
#    - If the property is set to include a directory, and loaded 
#      directives files are removed from the directory, AutoProbe  
#      metrics will no longer be reported!
# You must restart the managed application before changes to this property 
# take effect. 

introscope.autoprobe.directivesFile=default-typical-legacy.pbl,hotdeploy
introscope.agent.configuration.old=true

#######################
# AcceptController
# (AcceptController is only applicable on AutoProbe profiler.  It is NOT
# available with NativeProfiler)
#
# ================
# This property controls whether AcceptController will be enabled.  Accept-
# Controller is a feature that reduces application startup time.  It could
# be automatically turned off by using certain directives.  There is no
# functional effect of turning AcceptController on or off, only performance
# effects.
# By default, AcceptController is enabled in AutoProbe profiler.

#introscope.autoprobeconnector.acceptcontroller.enable=true


#######################
# Agent Properties    #
#######################


#################################
# Logging Configuration
#
# ================
# The following property points to the Log4Net config file
# You must restart the managed application before changes to this property take effect.

introscope.agent.log.config.path=logging.config.xml


#################################
# Enterprise Manager Connection Order
#
# ================
# The Enterprise Manager connection order list the Agent uses if it 
# is disconnected from its Enterprise Manager.
# You must restart the managed application before changes to this property take effect.

introscope.agent.enterprisemanager.connectionorder=DEFAULT


#################################
# Enterprise Manager Locations and Names 
# (names defined in this section are only used in the 
# introscope.agent.enterprisemanager.connectionorder property)
#
# ================
# Settings the Introscope Agent uses to find the Enterprise Manager 
# and names given to host and port combinations.
# You must restart the managed application before changes to this property take effect.

introscope.agent.enterprisemanager.transport.tcp.host.DEFAULT=localhost
introscope.agent.enterprisemanager.transport.tcp.port.DEFAULT=5001
introscope.agent.enterprisemanager.transport.tcp.socketfactory.DEFAULT=com.wily.isengard.postofficehub.link.net.DefaultSocketFactory

# The following connection properties enable the Agent to tunnel communication 
# to the Enterprise Manager over HTTP.
#
# WARNING: This type of connection will impact Agent and Enterprise Manager 
# performance so it should only be used if a direct socket connection to the 
# the Enterprise Manager is not feasible. This may be the case if the Agent 
# is isolated from the Enterprise Manager with a firewall blocking all but 
# HTTP traffic.
# 
# When enabling the HTTP tunneling Agent, uncomment the following host, port, 
# and socket factory properties, setting the host name and port for the 
# Enterprise Manager Web Server. Comment out any other connection properties 
# assigned to the "DEFAULT" channel and confirm that the "DEFAULT" channel is 
# assigned as a value for the "introscope.agent.enterprisemanager.connectionorder" 
# property.
# You must restart the managed application before changes to this property take effect.
#introscope.agent.enterprisemanager.transport.tcp.host.DEFAULT=localhost
#introscope.agent.enterprisemanager.transport.tcp.port.DEFAULT=8081
#introscope.agent.enterprisemanager.transport.tcp.socketfactory.DEFAULT=com.wily.isengard.postofficehub.link.net.HttpTunnelingSocketFactory

# The following properties are used only when the Agent is tunneling over HTTP 
# and the Agent must connect to the Enterprise Manager through a proxy server 
# (forward proxy). Uncomment and set the appropriate proxy host and port values. 
# If the proxy server cannot be reached at the specified host and port, the 
# Agent will try a direct HTTP tunneled connection to the Enterprise Manager 
# before failing the connection attempt.
# You must restart the managed application before changes to this property take effect.
#introscope.agent.enterprisemanager.transport.http.proxy.host=
#introscope.agent.enterprisemanager.transport.http.proxy.port=

# The following properties are used only when the proxy server requires 
# authentication. Uncomment and set the user name and password properties.
# You must restart the managed application before changes to this property take effect.
#introscope.agent.enterprisemanager.transport.http.proxy.username=
#introscope.agent.enterprisemanager.transport.http.proxy.password=

# To connect to the Enterprise Manager using HTTPS (HTTP over SSL),
# uncomment these properties and set the host and port to the EM's secure https listener host and port.
#introscope.agent.enterprisemanager.transport.tcp.host.DEFAULT=localhost
#introscope.agent.enterprisemanager.transport.tcp.port.DEFAULT=8444
#introscope.agent.enterprisemanager.transport.tcp.socketfactory.DEFAULT=com.wily.isengard.postofficehub.link.net.HttpsTunnelingSocketFactory


# Additional properties for connecting to the Enterprise Manager using SSL.
#
# Location of a pfx containing the agent's certificate.
# A pfx is needed if the EM requires client authentication.
# Either an absolute path or a path relative to the agent's working directory.
# On Windows, backslashes must be escaped.  For example: C:\\wily.pfx
#introscope.agent.enterprisemanager.transport.tcp.keystore.DEFAULT=
# The password for the keystore
#introscope.agent.enterprisemanager.transport.tcp.keypassword.DEFAULT=



#################################
# Enterprise Manager Failback Retry Interval
#
# ================
# When the Agent is configured to have multiple Enterprise Managers
# in its connection order and this property is enabled, the Introscope 
# Agent will automatically attempt to connect to the Enterprise Manager
# in its connection order to which it can connect in allowed mode.
# In case no such Enterprise Manager is found, the reconnection attempt 
# will occur on a regular interval as specified.
# Agent will not connect to any Enterprise Manager in disallowed mode,  
# when this property is enabled.
# You must restart the managed application before changes to this property take effect.

#introscope.agent.enterprisemanager.failbackRetryIntervalInSeconds=120


#######################
# Custom Process Name
#
# ================
# Specify the process name as it should appear in the
# Introscope Enterprise Manager and Workstation.
# You must restart the managed application before changes to this property take effect.

#introscope.agent.customProcessName=CustomProcessName


#######################
# Default Process Name
#
# ================
# If no custom process name is provided and the
# agent is unable to determine the name of the
# main application class, this value will be
# used for the process name.
# You must restart the managed application before changes to this property take effect.

introscope.agent.defaultProcessName=.NET Process


#######################
# Agent Name
#
# ================
# Specify the name of this agent as it appears in the
# Introscope Enterprise Manager and Workstation.
# You must restart the managed application before changes to this property take effect.

# This enables/disables auto naming of the agent using
# a custom service.
introscope.agent.agentAutoNamingEnabled=true

# The amount of time to delay connecting to the Introscope Enterprise
# Manager while Agent Auto Naming is attempted.
introscope.agent.agentAutoNamingMaximumConnectionDelayInSeconds=120

# When Agent Auto Naming is enabled, the Agent will check for 
# a new name based on the runtime environment on the specified interval.
introscope.agent.agentAutoRenamingIntervalInMinutes=10

# Auto name of log files (Agent and AutoProbe) with
# the Agent name or a timestamp can be disabled by setting the 
# value of this property to 'true'.  Log file auto naming only 
# takes effect when the Agent name can be determined using an 
# Environment Variable or based on the current runtime.
introscope.agent.disableLogFileAutoNaming=false

# Uncomment this property to provide a default Agent Name 
# if the other methods fail.
#introscope.agent.agentName=AgentName

# Fully Qualified Domain Name (FQDN) can be enabled by setting this property  
# value to 'true'. By Default (false) it will display HostName.
# Set to 'true' when integrating with Catalyst.
# You must restart the managed application before changes to this property take effect.
introscope.agent.display.hostName.as.fqdn=false


#######################
# Agent Socket Rate Metrics
#
# ================
# Set to true to enable the reporting of input and
# output bandwidth rate metrics for individual sockets.
# You must restart the managed application before changes to this property take effect.

introscope.agent.sockets.reportRateMetrics=true

############################### 
#Agent Memory Overhead Setting 
# 
# ======================= 
# Set to true if you want to attempt to reduce the agent memory overhead introduced by architectural improvements to the 8.x Agent.
# Increased Agent memory overhead only occurs in certain extreme cases.
# The trade-off for the possible lower memory consumption is a possible increase in response time.  
# Each application is unique and will experience different variations in Memory vs. Response Time trade-offs.
# This property is set to false by default and out of the box is commented out. This is not a hot property 
# and the managed application needs to be restarted for this flag to take effect. 
     
#introscope.agent.reduceAgentMemoryOverhead=true 

#######################
# Agent Extensions Directory
#
# ================
# This property specifies the location of all extensions to be loaded
# by the Introscope Agent.  Non-absolute names are resolved relative 
# to the location of this properties file.
# You must restart the managed application before changes to this property take effect.

introscope.agent.extensions.directory=ext



#######################
# Agent Thread Priority
#
# ================
# Controls the priority of agent threads.  Varies
# from 0 (low) to 4 (high). Default value if unspecified is Thread.ThreadPriority.Normal (2)

#introscope.agent.thread.all.priority=2



#######################
# Cloned Agent Configuration
#
# ================
# Set to true when running identical copies of an application on the same machine.
# You must restart the managed application before changes to this property take effect.

introscope.agent.clonedAgent=false


############################# 
# Restricted Instrumentation 
# 
# =========================== 
# Enable/Disable instrumentation for targeted set of processes. 
# By Default, there is no restriction on instrumentation.  In other words, every 
# managed application and application pools (for IIS 6.0 or later) will be 
# instrumented if the properties are not set (or commented out).


# To restrict instrumentation to ASP.NET applications only, set the property 
# introscope.agent.dotnet.monitorApplications to w3wp.exe for IIS 6.0 or later
# and aspnet_wp.exe for IIS 5.  Add additional executable names to the list 
# to instrument them.  Full pathnames with single backslashes are also
# acceptable.  For example, 
# c:\windows\microsoft.net\framework\v1.1.4322\aspnet_wp.exe.

introscope.agent.dotnet.monitorApplications=w3wp.exe,aspnet_wp.exe
 
# Uncomment the following property and specify IIS application pools to be instrumented.
# Application pool names must be in quotes. Use "NULL" to specify applications not running in any application pool.
#introscope.agent.dotnet.monitorAppPools= "NULL","DefaultAppPool","AppPool1","AppPool2"

 
#######################
# PerfMon Configuration
#
# ================
# Properties controlling Perfmon metric collection.
# You must restart the "CA APM PerfMon Collector Service" for the PerfMon properties to take effect.

# Counter expressions are separated by commas.  New counters (e.g. |Thread|{osprocessname}*|*) can be appended to the list.
introscope.agent.perfmon.metric.filterPattern=|Processor|*|*,|.NET Data Provider*|*|*,|.NET CLR*|{osprocessname}|*,|.NET CLR Data|*|*,|Process|{osprocessname}|*,|ASP.NET*|*

# Counter expressions that are reported as average values (default: LongCounter). Wildcard is only supported at beginning or end, e.g. */sec matches all counters that end with "/sec".
#introscope.agent.perfmon.metric.filterPattern.average=*/sec,Avg*,%*,*Length,Connections*,*Connections,*Rate,*Time,*Current Bandwidth,*Free Megabytes,*Running

# Maximum number of Perfmon metrics reported in each interval.
#introscope.agent.perfmon.metric.limit=1000

# Intervals in which Perfmon metrics are collected.  Default is 15 seconds.
introscope.agent.perfmon.metric.pollIntervalInSeconds=15

# Intervals in which new Perfmon categories are discovered.  Default is 600 seconds (or 10 minutes).
introscope.agent.perfmon.category.browseIntervalInSeconds=600

# Flag to enable/disable new Perfmon category discovery.  Default is true (enabled).
introscope.agent.perfmon.category.browseEnabled=true

#######################
# SQL Agent Configuration
#
# ================
# Configuration settings for Introscope SQL Agent

### Turns off metrics for individual SQL statements. 
#introscope.agent.sqlagent.sql.turnoffmetrics=false

## Report only Average Response Time metric for individual SQL statements
#introscope.agent.sqlagent.sql.artonly=false

## Turn off transaction tracing individual sql statements. They will not be from be reported in Transaction Trace.
#introscope.agent.sqlagent.sql.turnofftrace=false

## Unnormalized sql will appear as parameter for Sql components in Transaction Trace 
## Caution: enabling this property may result in passwords and sensitive information to be presented in Transaction Trace
#introscope.agent.sqlagent.sql.rawsql=false


######################################
# SQL Agent Normalizer extension
#
# ================
# Configuration settings for SQL Agent normalizer extension


# Specifies the name of the sql normalizer extension that will be used 
# to override the preconfigured normalization scheme. To make custom 
# normalization extension work, the value of its manifest attribute 
# com-wily-Extension-Plugin-{pluginName}-Name should match with the 
# value given to this property. If you specify a comma separated list 
# of names, only the first name will be used. Example, 
# introscope.agent.sqlagent.normalizer.extension=ext1, ext2
# Only ext1 will be used for normalization. By default we now ship the  
# RegexSqlNormalizer extension
# Changes to this property take effect immediately and do not 
# require the managed application to be restarted.

#introscope.agent.sqlagent.normalizer.extension=RegexSqlNormalizer

##############################
# RegexSqlNormalizer extension
#
# ==================
# The following properties pertain to RegexSqlNormalizer which 
# uses regex patterns and replace formats to normalize the sql in 
# a user defined way. 


# This property if set to true will make sql strings to be
# evaluated against all the regex key groups. The implementation
# is chained. Hence, if the sql matches multiple key groups, the
# normalized sql output from group1 is fed as input to group2 and 
# so on. If the property is set to 'false', as soon as a key group  
# matches, the normalized sql output from that group is returned
# Default value is 'false'
#introscope.agent.sqlagent.normalizer.regex.matchFallThrough=true

# This property specifies the regex group keys. They are evaluated in order
# Changes to this property take effect immediately and do not 
# require the managed application to be restarted.
#introscope.agent.sqlagent.normalizer.regex.keys=key1

# This property specifies the regex pattern that will be used
# to match against the sql. All valid regex alowed by 
# System.Text.RegularExpressions namespace can be used here.
# Changes to this property take effect immediately and do not 
# require the managed application to be restarted.
# eg: (\\b[0-9,.]+\\b) will filter all number values, ('.*?') will filter
# anything between single quotes, ((?i)\\bTRUE\\b|\\bFALSE\\b) will filter
# boolean values from the query.
#introscope.agent.sqlagent.normalizer.regex.key1.pattern=(".*?")|('.*?')|(\\b[0-9,.]+\\b)|((?i)\\bTRUE\\b|\\bFALSE\\b)

# This property if set to 'false' will replace the first occurrence of the
# matching pattern in the sql with the replacement string. If set to 'true'
# it will replace all occurrences of the matching pattern in the sql with
# replacement string
# Changes to this property take effect immediately and do not 
# require the managed application to be restarted.
# Default value is 'false'
#introscope.agent.sqlagent.normalizer.regex.key1.replaceAll=true

# This property specifies the replacement string format. All valid 
# regex allowed by System.Text.RegularExpressions namespace can be used here.
# eg: The default normalizer replaces the values with a question mark (?)
# Changes to this property take effect immediately and do not 
# require the managed application to be restarted.
#introscope.agent.sqlagent.normalizer.regex.key1.replaceFormat=?

# This property specifies whether the pattern match is sensitive to case
# Changes to this property take effect immediately and do not 
# require the managed application to be restarted.
#introscope.agent.sqlagent.normalizer.regex.key1.caseSensitive=false



#######################
# Transaction Tracer Configuration
#
# ================
# Configuration settings for Introscope Transaction Tracer

# The following settings configure Transaction Tracer to optionally
# capture the user ID used to invoke frontend components if it is stored
# in one of the three following ways.  Uncomment the set of properties
# that correspond to how user IDs are stored in your application.
# Make sure only one set of properties are uncommented or the wrong
# properties could be used.
# You must restart the managed application before changes to this property take effect.

# Uncomment the following property if the user ID is accessed through the Http Context identity
introscope.agent.transactiontracer.userid.method=HttpContext.User.Identity.Name

# Uncomment the following property if the user ID is accessed through the URL user info
#introscope.agent.transactiontracer.userid.method=HttpContext.Request.Uri.UserInfo

# Uncomment the following properties if the user ID is an Http  request header
#introscope.agent.transactiontracer.userid.method=HttpRequest.Headers.Get
#introscope.agent.transactiontracer.userid.key=<application defined key string>


# Uncomment the following properties if the user ID is an attribute in the Http Session
#introscope.agent.transactiontracer.userid.method=HttpContext.Session.Contents
#introscope.agent.transactiontracer.userid.key=<application defined key string>

# Uncomment the following properties to record specific http request headers, parameters or session
#  attributes in the Transaction Tracer data.

#introscope.agent.transactiontracer.parameter.httprequest.headers=User-Agent
#introscope.agent.transactiontracer.parameter.httprequest.parameters=parameter1,parameter2
#introscope.agent.transactiontracer.parameter.httpsession.attributes=attribute1,attribute2

# Uncomment the following property to specify the maximum number of components allowed in a Transaction 
# Trace.  By default, the clamp is set at 5000.   
# Note that any Transaction Trace exceeding the clamp will be discarded at the agent, 
# and a warning message will be logged in the Agent log file.
# Warning: If this clamp size is increased, the requirement on the memory will be higher and
# as such.
# Changes to this property take effect immediately and do not require the managed application to be restarted.
#introscope.agent.transactiontrace.componentCountClamp=5000

# Uncomment the following property to specify the maximum depth of components allowed in
# head filtering, which is the process of examining the start of a transaction for
# the purpose of potentially collecting the entire transaction.  Head filtering will
# check until the first blamed component exits, which can be a problem on very deep
# call stacks when no clamping is done.  The clamp value will limit the memory and
# CPU utilization impact of this behavior by forcing the agent to only look up to a
# fixed depth.  By default, the clamp is set at 30.   
# Note that any Transaction Trace whose depth exceeds the clamp will no longer be examined
# for possible collection UNLESS some other mechanism, such as sampling or user-initiated
# transaction tracing, is active to select the transaction for collection.
# Warning: If this clamp size is increased, the requirement on the memory will be higher and
# as such, garbage collection behavior may be affected, which will have an application-wide
# performance impact.
# Changes to this property take effect immediately and do not require the managed application to be restarted.
#introscope.agent.transactiontrace.headFilterClamp=30

#
# Use compression to reduce the size of cross process tracing data. This option will increase agent CPU overhead, 
# but reduce the size of interprocess headers.
# Valid options are lzma or none
# Note that Java agents also support gzip option, so if interoperability is required make sure they do not use gzip.
introscope.agent.crossprocess.compression=lzma
# Minimum length of cross process parameter data length for which to apply compression
introscope.agent.crossprocess.compression.minlimit=1500
# Maximum size of cross process parameter data allowed.
# If total size of cross process parameter even after applying compression (if allowed) is more than this limit,
# some data will be dropped and some cross process correlation functionality will not work properly.
# However, this settings will protect user transactions from failing in network transmission due to too large header size.
introscope.agent.crossprocess.correlationid.maxlimit=4096
# Changes to above 3 properties take effect immediately and do not require the managed application to be restarted

# Uncomment the following property to disable Transaction Tracer Sampling
# Changes to this property take effect immediately and do not require the managed application to be restarted.
#introscope.agent.transactiontracer.sampling.enabled=false

# The following property limits the number of transactions that are reported by the agent 
# per reporting cycle. The default value if the property is not set is 50.
# You must restart the managed application before changes to this property take effect.
introscope.agent.ttClamp=50

########################
# TT Sampling
# ================
# These are normally configured in the EM. Configuring in the Agent disables configuring
# them in the EM
# You must restart the managed application before changes to this property take effect.

#introscope.agent.transactiontracer.sampling.perinterval.count=1
#introscope.agent.transactiontracer.sampling.interval.seconds=120


########################
# Enabling Collection of Filtered Parameters
# ================
# By default, the .NET Agent reports only the URL for transactions it traces.  
# Reporting of individual HTTP properties is restricted to minimize the impacts of transaction tracing on system overhead.  
# To enable filtering you must first enable collection of HTTP properties, by setting this property to false.
# By default this property is set to true.    
# Enables collection of: Application Name, Context Path, URL
# You must restart the managed application before changes to this property take effect.
#introscope.agent.asp.disableHttpProperties=false


#######################
# Agent Metric Clamp Configuration
#
# ================
# The following setting configures the Agent to approximately clamp the number of metrics sent to the EM  
# If the number of metrics pass this metric clamp value then no new metrics will be created.  Old metrics will still report values.
# The value must be equal to or larger than 1000 to take effect. Lower value will be rejected.
# The default value is 50000. 
# You must restart the managed application before changes to this property take effect.
#introscope.agent.metricClamp=50000


#################################
# Cross Process Transaction Trace
# ===============================
# This property controls whether the presence of a tail filter triggers 
# automatic collection of traces from downstream agents or not. This property 
# does not affect collection of automatic downstream traces due to passing of
# head filters. 
# It is enabled by default. Enabling this property
# and running long periods of Transaction Trace session with tail filters can 
# cause large number of traces to be sent to the EM
# Set the property to false to disable automatic collection of downstream 
# traces due to tail filter.
# You must restart the managed application before changes to this property take effect.
introscope.agent.transactiontracer.tailfilterPropagate.enable=true


#######################
# URL Grouping Configuration
#
# ================
# Configuration settings for Frontend naming.  By default, all frontends
# go into the "Default" group.  This is done so that invalid URLs (i.e.
# those that would generate a 404 error) do not create unique, one-time
# metrics -- this can bloat the EM's memory.  To get more meaningful
# metrics out of the Frontends|Apps|URLs tree, set up URL groups that
# are relevant to the deployment
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.urlgroup.keys=default
introscope.agent.urlgroup.group.default.pathprefix=*
introscope.agent.urlgroup.group.default.format=Default

#######################
# Synthetic Transaction Configuration
#
# ================
# Configuration settings for synthetic transaction monitoring.
# Parameter introscope.agent.synthetic.header.names defines name(s) of HTTP headers that indicate a synthetic
# transaction.  Individual names are separated by commas.  If undefined, or empty string, synthetic transactions
# are not detected.  If multiple values defined, they are checked in order until a header is found which has
# non-null, non-empty value.  The header value will be used to create synthetic transaction name (and thus node
# name(s) under which metrics for the transaction) as follows:
# If header name is 'lisaframeid', the transaction name 'LISA' will be used.  If header name is anything other
# than 'lisaframeid' or 'x-wtg-info', value of header (with appropriate modification to ensure node name is valid)
# will be used as synthetic transaction name.  If header name is 'x-wtg-info', the header value is expected to
# contain sequence of atributes as name, value pairs separated by amperands symbols.  Attribute name and value
# within each pair, are separated by equals sign.  The values of 'group', 'name', 'ipaddress' and 'request_id'
# attributes, separated by '|', are used to form synthetic transaction name.   For example the x-wtg-info header:
# clear synthetic=true&instance=ewing&name=sample&group=SampleGroup&version=4.1.0&ipaddress=192.168.193.1&sequencenumber=1&request_id=start&executiontime=1226455047
# would result in metrics being reported under node 'SampleGroup|sample|192.168.193.1|start'.  Any attributes which are
# not defined in x-wtg-info header have default values supplied as follows: group=unknownGroup, name=unknownScript,
# ipaddress=0.0.0.0 and request_id=Action.  Final node name is modified if required to ensure it is valid.
# Changes to this property take effect immediately and do not require the managed application to be restarted.
#introscope.agent.synthetic.header.names=Synthetic_Transaction,x-wtg-info,lisaframeid

# The following configuration parameters with names starting 'introscope.agent.synthetic.' are ignored if
# parameter introscope.agent.synthetic.header.names is undefined. 
# Parameter introscope.agent.synthetic.user.name defines name of HTTP header whose value holds name of 
# synthetic user.  If undefined, nodes for each unique synthetic user will not be created.  Synthetic user
# names will be modified if required to ensure they are valid node names.
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.synthetic.user.name=Synthetic_Trace_By_Vuser
# Node under which transactions recognised as synthetic are reported.  This node will be located under
# Frontends|Apps|<WebAppName> where <WebAppName> is web application name.  Defaults to 'Synthetic Users'
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.synthetic.node.name=Synthetic Users
# Node under which transactions not recognised as synthetic are reported..  This node will be located under
# Frontends|Apps|<WebAppName> where <WebAppName> is web application name.  If not defined, no additional node
# under <WebAppName> is created.
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.non.synthetic.node.name=Real Users

#######################
# Stall Configuration
#
# ================
# Configuration settings for stall detection
# Minimum threshold for stall event duration
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.stalls.thresholdseconds=30

# Frequency that the agent checks for stall events
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.stalls.resolutionseconds=10

####################### 
# LeakHunter Configuration 
# 
# ================ 
# Configuration settings for Introscope LeakHunter 
# You must restart the managed application before changes to this property take effect.  
  
# Controls whether the feature is enabled if the LeakHunter Add-on is present. 
# Set the value to true to enable LeakHunter. 
  
introscope.agent.leakhunter.enable=false 
  
# Controls the location for the LeakHunter log file. 
# Relative filenames are relative to the application working directory. 
# Leave the value blank if you do not want LeakHunter to record data 
# to a log file. 
  
introscope.agent.leakhunter.logfile.location=logs/LeakHunter.log 
  
# Controls whether LeakHunter will append or overwrite the log file. 
# Set the value to true to append to the log file. 
  
introscope.agent.leakhunter.logfile.append=false 
  
# Controls the sensitivity of the leak detection algorithm. 
# The value should be an integer from 1-10.  A higher 
# sensitivity setting will result in more potential leaks 
# reported and a lower sensitivity will result in fewer 
# potential leaks reported. 
  
introscope.agent.leakhunter.leakSensitivity=5 
  
# Controls the length of time LeakHunter spends looking for new 
# potential leaks.  After the timeout, LeakHunter will stop looking 
# for new potential leaks and just continue tracking the previously 
# identified potential leaks.  Set the value to zero if you want 
# LeakHunter to always look for new potential leaks. 
  
introscope.agent.leakhunter.timeoutInMinutes=120 
  
# Controls whether LeakHunter generates allocation stack traces for 
# potential leaks.  Turning this on gives you more precise data about 
# the potential leak's allocation, but requires additional memory and 
# CPU overhead.  For this reason, the default setting is false. 
# Changes to this property take effect immediately and do not require the managed application to be restarted.  
introscope.agent.leakhunter.collectAllocationStackTraces=false 


# Ignore properties let the user specify particular collections that should
# be ignored by leakhunter. For Generic collections, use a syntax that includes
# the generic type qualification like System.Collections.Generic.List`1
# Changes to this property take effect immediately and do not require the managed application to be restarted.
#introscope.agent.leakhunter.ignore.0=


####################### 
# Error Detector Configuration 
# 
# ================ 
# Configuration settings for Error Detector 
# You must restart the managed application before changes to this property take effect.  
  
# Please include errors.pbd in your pbl (or in introscope.autoprobe.directivesFile) 
  
# The error snapshot feature captures transaction details about serious errors 
# and enables recording of error count metrics. 
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.errorsnapshots.enable=true
  
# The following setting configures the maximum number of error snapshots 
# that the Agent can send in a 15-second period. 
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.errorsnapshots.throttle=10 
  
# The following series of properties lets you specify error messages  
# to ignore.  Error snapshots will not be generated or sent for 
# errors with messages matching these filters.  You may specify 
# as many as you like (using .0, .1, .2 ...). You may use wildcards (*).   
# The following are examples only. 
# Changes to this property take effect immediately and do not require the managed application to be restarted.
#introscope.agent.errorsnapshots.ignore.0=*com.company.HarmlessException* 
#introscope.agent.errorsnapshots.ignore.1=*HTTP Error Code: 404* 


################################
# Agent Metric Aging
# ==============================
# Detects metrics that are not being updated consistently with new data and removes these metrics.
# By removing these metrics you can avoid metric explosion.    
# Metrics that are in a group will be removed only if all metrics under this group are considered candidates for removal.
# BlamePointTracer metrics are considered a group.  
#
# Enable/disable the metric agent aging feature. 
# Changes to this property take effect immediately and do not require the managed application to be restarted.
introscope.agent.metricAging.turnOn=true
# You can choose to ignore metrics from removal by adding the metric name or metric filter to the list below.  
# Changes to this property take effect immediately and do not require the managed application to be restarted.
#introscope.agent.metricAging.metricExclude.ignore.0=



#########################################
# ChangeDetector configuration properties
# =======================================
# On/Off Switch
#
# ================
# This boolean property gives you the ability to enable
# Introscope ChangeDetector by settings the property value
# to true. It is set to false by default.
# You must restart the managed application before changes to this property take effect.
#introscope.changeDetector.enable=false
#######################
# Root directory 
#
# ================
# The root directory is the folder where ChangeDetector creates its local cache files. 
# Use a backslash to escape the backslash character, as in the example.   
#introscope.changeDetector.rootDir=c:\\sw\\AppServer\\wily\\change_detector
#######################
# Startup wait time 
#
# ================
# Time to wait after agent starts before trying to connect to the Enterprise manager
#introscope.changeDetector.isengardStartupWaitTimeInSec=15
#######################
# Interval between connection attempts
#
# ================
# Specify the number of seconds to wait before retrying connection to the Enterprise manager
#introscope.changeDetector.waitTimeBetweenReconnectInSec=10
#######################
# Agent ID
#
# ================
# A string used by ChangeDetector to identify this agent
#introscope.changeDetector.agentID=SampleApplicationName
#
#######################
# Data source configuration file path 
#
# ================
# The absolute or relative path to the ChangeDetector datasources configuration file.
# Use a backslash to escape the backslash character.   
#introscope.changeDetector.profile=ChangeDetectorDotnet-config.xml
#
#######################
# Data source configuration file directory
#
# ================
# The absolute or relative path to the datasource configuration file(s) directory.
# Use a backslash to escape the backslash character.
# All datasource configuration file(s) from this directory will be used in addition
# to any file specified by introscope.changeDetector.profile property.
#introscope.changeDetector.profileDir=changeDetector_profiles

#########################################
# HTTP Header Decorator
# =======================================
# On/Off Switch
#
# ================
# If this Boolean value is set to true, it configures the agent to add
# additional performance monitoring information to HTTP response
# headers.  HTTPHeaderDecorator attaches the GUID to each transaction 
# and inserts the GUID into an HTTP header, x-wily-info
# This enables the correlation of transaction between Wily CEM and Wily Introscope
introscope.agent.decorator.enabled=false

#######################
# Security
#
# Determine the format of decorated HTTP response headers, which are sent to Wily CEM.
# clear - clear text encoding
# encrypted - header data is encrypted
# default is encrypted
#
introscope.agent.decorator.security=encrypted

#######################
# Application Map Agent Side
#
# ================
#Enable/disable tracking in the monitored code for Application Map
introscope.agent.appmap.enabled=true

#Enable/disable tracking of metrics for app map nodes. 
#Default value is false
#introscope.agent.appmap.metrics.enabled=true

#Enable/disable sending additional information for integration with catalyst
#default value is false
#introscope.agent.appmap.catalystIntegration.enabled=true

#Set the buffer size for app map data
#default value is 1000. Must be a positive integer. If the value is set to 0, the buffer is 
#unbounded. 
#introscope.agent.appmap.queue.size=1000

#Set the frequency in milliseconds for sending app map data to the EM.
#default value is 1000. Must be a positive integer. 
# If the value is set to 0, the default value is used.
#introscope.agent.appmap.queue.period=1000

#Enable/disable sending additional intermediate nodes between application frontend and 
# backend nodes.
#Default value is false.
# Change to this property takes effect immediately and do not require the managed application to be restarted.
#introscope.agent.appmap.intermediateNodes.enabled=true

#######################
# Business Recording 
#
# ================
# Enable/disable business recording
# You must restart the managed application before changes to this property take effect.
introscope.agent.bizRecording.enabled=true
#
# Match POST parameter patterns before the servlets execute; THIS CAN POTENTIALLY BREAK USER APPLICATIONS
# Please consult a technical CA Wily representative or CA Support before enabling
#introscope.agent.bizdef.matchPost = before
# Never attempt to match POST parameters. This option is fastest, but may result in inaccurate business transaction component matching
#introscope.agent.bizdef.matchPost = never
# Match POST parameter patterns after servlet has executed. Cross process mapping and some metrics will not be available
introscope.agent.bizdef.matchPost = after

#######################
# Primary network interface selector
#
# Agent reports details of host computer's primary interface (IP address, MAC address, host & domain name). 
# If following property is unset, agent will attempt to determine an appropriate interface as the primary
# interface.  If an alternate interface is required, uncomment following property and specify required 
# interface identity.
# Change to this property takes effect immediately and do not require the managed application to be restarted.
#
#introscope.agent.primary.net.interface.name=Local Area Connection.0

#######################
# Remote Dynamic Instrumentation Settings
#
# ================
# Configuration settings for remote dynamic instrumentation 

# Enable/disable the remote management of dynamic instrumentation 
# You must restart the managed application before changes to this property take effect.
# introscope.agent.remoteagentdynamicinstrumentation.enabled=false 

###################
# Default Backend Legacy
#
# The default backend feature behavior has changed to include methods marked as frontend
# in the detection of socket calling. 
# The following property will set the default backend detection to run as in 
# 9.0.x release. By default, the value of the property of false.
# You must restart the managed application before changes to this property take effect.
# 
#introscope.agent.configuration.defaultbackends.legacy=false

#For the AppMapMarkerTracers, we can set the properties that define if they sending
# Class or MethodClass level information
#[Class] will enable to report Class level application edge to Application map
#[MethodClass] will enable to report Method Class level application edge to Application map
introscope.agent.appmap.levels.enabled=MethodClass


#For the AppMapMarkerTracers, we can set the properties that define if they sending
# information for Application or Business Transactionowners
#[Application] will enable to report applciation owners
#[BusinessTransactionComponent] will enable to report BTC owners
introscope.agent.appmap.owners.enabled=Application,BusinessTransactionComponent



#######################
#  Transaction Structure aging properties
#
# ================
# This property is to evaluate the number of elements in the transaction structure at the period interval,
# to determine if "emergency aging" is required.
# Default value is "30000"
# com.wily.introscope.agent.harvesting.transaction.creation.checkperiod=30000       

# This property specifies the period in milliseconds that the aging for the transaction structure is checked, 
# Default value is "30000"
# com.wily.introscope.agent.harvesting.transaction.aging.checkperiod=30000
 
# This property specifies the minimum amount in milliseconds that a tree in the transaction structure must be inactive before it is purged.
# The inactivity does not imply that it will be aged out.
# Default value is "60000"
# com.wily.introscope.agent.harvesting.transaction.aging.period=60000 
             
# This property sets the maximum percentage increment in the size of the structure that is allowed to happen before aging of the transaction structure is forced
# If the change in the number of nodes between the aging periods is more than this percentage value, then checking for aging occurs
# if set to a small value, the transaction structure will be aged more frequently, and the memory utilization of the agent will be therefore 
# kept lower.
# Default value is "5", i.e. 5%
# com.wily.introscope.agent.harvesting.transaction.aging.attentionlevel.percentage=5        
 
# This property sets the maximum absolute increment in the size of the structure that is allowed to happen before aging of the transaction structure is forced
# If the change in the number of nodes between the aging periods is more than this percentage value, then checking for aging occurs
# if set to a small value, the transaction structure will be aged more frequently, and the memory utilization of the agent will be therefore 
# kept lower.
# Default value is "100000"
# com.wily.introscope.agent.harvesting.transaction.attentionlevel.absolute=100000

# This property is used to avoid spikes in memory utilization of the transaction structure.
# If there is an increase of elements at any time bigger than a third of this value,
# then "emergency aging" occurs immediately. Emergency aging will agent parts of the transaction structures that are younger than the 
# value specified in com.wily.introscope.agent.harvesting.transaction.aging.period,  and will likely reduce the amount of data sent by the agent.
# Only modify this value if the memory requirement are very strict. 
# Default value is "100000"
# com.wily.introscope.agent.harvesting.transaction.creation.attentionlevel.absolute=100000

# This property specifies the maximum duration in milliseconds of the aging process. It is used to avoid long aging process when 
# resources available are not sufficient. 
# default value if 30000
# com.wily.introscope.agent.harvesting.transaction.aging.duration.max=30000
 
#######################
#  Transaction Structure properties
#
# ================
# Enable/disable to shut down globally the transaction trace feature.
# Default value is "true"
# com.wily.introscope.agent.blame.transaction.doTransactionTrace=true

# Enable/disable high concurrency mode for all repositories.
# Set to true, it will use more memory but may give more throughput
# Default value is "false"
# com.wily.introscope.agent.blame.highconcurrency.enabled=false

# This property defines the number of stripes in the striped repositories
# It works when the high concurrency mode is on,
# which is "com.wily.introscope.agent.blame.highconcurrency.enabled=true"
# Default value is "16"
# com.wily.introscope.agent.blame.highconcurrency.stripes=16

#######################
# Properties to activate sustainability metrics
#
# ================
# Sustainability metrics are generated to provide information on the agent health and
# internal status. There is a substantial overhead associated with these metrics, and therefore, their
# usage is not suggested at this time in production environments.
#
# Enable/disable to generate globally sustainability debug metrics.
# Set to true, it will generate globally sustainability debug metrics that can be used to evaluate the Transaction Structure
# Default value is "false"
# com.wily.introscope.agent.blame.transactions.debugmetrics.enabled=false           

# Enable/disable to generate sustainability metrics on the harvesting process.
# Default value is "false"
# com.wily.introscope.agent.harvesting.debugmetrics.enabled=false

# This property is to generate the metrics for the health of the data structures in the agent.
# Default value is "false"
# concurrentMapPolicy.generatemetrics=false   
