/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmConstraints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class JsseUtils_7
extends JsseUtils {
    static final Set<CryptoPrimitive> KEY_AGREEMENT_CRYPTO_PRIMITIVES = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT));
    static final Set<CryptoPrimitive> KEY_ENCAPSULATION_CRYPTO_PRIMITIVES = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.KEY_ENCAPSULATION));
    static final Set<CryptoPrimitive> SIGNATURE_CRYPTO_PRIMITIVES = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    static final AlgorithmConstraints DEFAULT_ALGORITHM_CONSTRAINTS = new ExportAlgorithmConstraints(ProvAlgorithmConstraints.DEFAULT);

    JsseUtils_7() {
    }

    static AlgorithmConstraints exportAlgorithmConstraints(BCAlgorithmConstraints constraints) {
        if (ProvAlgorithmConstraints.DEFAULT == constraints) {
            return DEFAULT_ALGORITHM_CONSTRAINTS;
        }
        if (constraints == null) {
            return null;
        }
        if (constraints instanceof ImportAlgorithmConstraints) {
            return ((ImportAlgorithmConstraints)constraints).unwrap();
        }
        return new ExportAlgorithmConstraints(constraints);
    }

    static Object exportAlgorithmConstraintsDynamic(BCAlgorithmConstraints constraints) {
        return JsseUtils_7.exportAlgorithmConstraints(constraints);
    }

    static CryptoPrimitive exportCryptoPrimitive(BCCryptoPrimitive primitive) {
        switch (primitive) {
            case MESSAGE_DIGEST: {
                return CryptoPrimitive.MESSAGE_DIGEST;
            }
            case SECURE_RANDOM: {
                return CryptoPrimitive.SECURE_RANDOM;
            }
            case BLOCK_CIPHER: {
                return CryptoPrimitive.BLOCK_CIPHER;
            }
            case STREAM_CIPHER: {
                return CryptoPrimitive.STREAM_CIPHER;
            }
            case MAC: {
                return CryptoPrimitive.MAC;
            }
            case KEY_WRAP: {
                return CryptoPrimitive.KEY_WRAP;
            }
            case PUBLIC_KEY_ENCRYPTION: {
                return CryptoPrimitive.PUBLIC_KEY_ENCRYPTION;
            }
            case SIGNATURE: {
                return CryptoPrimitive.SIGNATURE;
            }
            case KEY_ENCAPSULATION: {
                return CryptoPrimitive.KEY_ENCAPSULATION;
            }
            case KEY_AGREEMENT: {
                return CryptoPrimitive.KEY_AGREEMENT;
            }
        }
        return null;
    }

    static Set<CryptoPrimitive> exportCryptoPrimitives(Set<BCCryptoPrimitive> primitives) {
        if (SIGNATURE_CRYPTO_PRIMITIVES_BC == primitives) {
            return SIGNATURE_CRYPTO_PRIMITIVES;
        }
        if (KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC == primitives) {
            return KEY_AGREEMENT_CRYPTO_PRIMITIVES;
        }
        if (KEY_ENCAPSULATION_CRYPTO_PRIMITIVES_BC == primitives) {
            return KEY_ENCAPSULATION_CRYPTO_PRIMITIVES;
        }
        HashSet<CryptoPrimitive> result = new HashSet<CryptoPrimitive>();
        for (BCCryptoPrimitive primitive : primitives) {
            result.add(JsseUtils_7.exportCryptoPrimitive(primitive));
        }
        return result;
    }

    static BCAlgorithmConstraints importAlgorithmConstraints(AlgorithmConstraints constraints) {
        if (null == constraints) {
            return null;
        }
        if (constraints instanceof ExportAlgorithmConstraints) {
            return ((ExportAlgorithmConstraints)constraints).unwrap();
        }
        return new ImportAlgorithmConstraints(constraints);
    }

    static BCAlgorithmConstraints importAlgorithmConstraintsDynamic(Object constraints) {
        return JsseUtils_7.importAlgorithmConstraints((AlgorithmConstraints)constraints);
    }

    static BCCryptoPrimitive importCryptoPrimitive(CryptoPrimitive primitive) {
        switch (primitive) {
            case MESSAGE_DIGEST: {
                return BCCryptoPrimitive.MESSAGE_DIGEST;
            }
            case SECURE_RANDOM: {
                return BCCryptoPrimitive.SECURE_RANDOM;
            }
            case BLOCK_CIPHER: {
                return BCCryptoPrimitive.BLOCK_CIPHER;
            }
            case STREAM_CIPHER: {
                return BCCryptoPrimitive.STREAM_CIPHER;
            }
            case MAC: {
                return BCCryptoPrimitive.MAC;
            }
            case KEY_WRAP: {
                return BCCryptoPrimitive.KEY_WRAP;
            }
            case PUBLIC_KEY_ENCRYPTION: {
                return BCCryptoPrimitive.PUBLIC_KEY_ENCRYPTION;
            }
            case SIGNATURE: {
                return BCCryptoPrimitive.SIGNATURE;
            }
            case KEY_ENCAPSULATION: {
                return BCCryptoPrimitive.KEY_ENCAPSULATION;
            }
            case KEY_AGREEMENT: {
                return BCCryptoPrimitive.KEY_AGREEMENT;
            }
        }
        return null;
    }

    static Set<BCCryptoPrimitive> importCryptoPrimitives(Set<CryptoPrimitive> primitives) {
        if (SIGNATURE_CRYPTO_PRIMITIVES == primitives) {
            return SIGNATURE_CRYPTO_PRIMITIVES_BC;
        }
        if (KEY_AGREEMENT_CRYPTO_PRIMITIVES == primitives) {
            return KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
        }
        if (KEY_ENCAPSULATION_CRYPTO_PRIMITIVES == primitives) {
            return KEY_ENCAPSULATION_CRYPTO_PRIMITIVES_BC;
        }
        HashSet<BCCryptoPrimitive> result = new HashSet<BCCryptoPrimitive>();
        for (CryptoPrimitive primitive : primitives) {
            result.add(JsseUtils_7.importCryptoPrimitive(primitive));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ExportAlgorithmConstraints
    implements AlgorithmConstraints {
        private final BCAlgorithmConstraints constraints;

        ExportAlgorithmConstraints(BCAlgorithmConstraints constraints) {
            this.constraints = constraints;
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> primitives, Key key) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(primitives), key);
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(primitives), algorithm, parameters);
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(primitives), algorithm, key, parameters);
        }

        BCAlgorithmConstraints unwrap() {
            return this.constraints;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ImportAlgorithmConstraints
    implements BCAlgorithmConstraints {
        private final AlgorithmConstraints constraints;

        ImportAlgorithmConstraints(AlgorithmConstraints constraints) {
            this.constraints = constraints;
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> primitives, Key key) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(primitives), key);
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(primitives), algorithm, parameters);
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(primitives), algorithm, key, parameters);
        }

        AlgorithmConstraints unwrap() {
            return this.constraints;
        }
    }
}

