/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.api;

import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.MonitoringEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class BaseMonitoringEntity
implements MonitoringEntity {
    protected String id;
    protected String name;
    protected String parentId;
    protected transient Map<String, Label> labelsMap;
    protected List<Label> labels = new ArrayList<Label>();

    public BaseMonitoringEntity() {
        this.labelsMap = new HashMap<String, Label>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
        labels.forEach(label -> this.labelsMap.put(label.getKey(), (Label)label));
    }

    @Override
    public Optional<Label> getLabelWithKey(String key) {
        return Optional.ofNullable(this.labelsMap.get(key));
    }

    @Override
    public boolean hasLabelWithKey(String key) {
        return this.labelsMap.containsKey(key);
    }

    @Override
    public void addLabel(Label label) {
        this.labels.add(label);
        this.labelsMap.put(label.getKey(), label);
    }

    @Override
    public void addLabel(Optional<Label> label) {
        if (!label.isPresent()) {
            return;
        }
        Label l = label.get();
        this.labels.add(l);
        this.labelsMap.put(l.getKey(), l);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parentId == null ? 0 : this.parentId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseMonitoringEntity other = (BaseMonitoringEntity)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parentId == null ? other.parentId != null : !this.parentId.equals(other.parentId));
    }

    public String toString() {
        return "BaseMonitoringEntity [id=" + this.id + ", name=" + this.name + ", parentId=" + this.parentId + ", labels=" + this.labels + "]";
    }
}

