/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.api;

import com.ca.apm.gaps.api.BaseMonitoringEntity;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.Monitor;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.api.Utils;
import java.util.ArrayList;
import java.util.List;

public class BasicMonitoringTarget
extends BaseMonitoringEntity
implements MonitoringTarget {
    private MonitoringTarget.MonitoringTargetType type;
    private List<MonitoringTarget> childTargets;
    private List<Monitor> monitors;

    public BasicMonitoringTarget() {
        this.childTargets = new ArrayList<MonitoringTarget>();
        this.monitors = new ArrayList<Monitor>();
    }

    public BasicMonitoringTarget(String name, MonitoringTarget.MonitoringTargetType type, List<Label> labels, List<MonitoringTarget> children, List<Monitor> monitors) {
        this.name = name;
        this.type = type;
        this.id = Utils.createId(type.name(), name);
        this.childTargets = children;
        this.monitors = monitors;
        this.setLabels(labels);
    }

    public BasicMonitoringTarget(String name, MonitoringTarget.MonitoringTargetType type) {
        this(name, type, new ArrayList<Label>(), new ArrayList<MonitoringTarget>(), new ArrayList<Monitor>());
    }

    @Override
    public MonitoringTarget.MonitoringTargetType getType() {
        return this.type;
    }

    public void setType(MonitoringTarget.MonitoringTargetType type) {
        this.type = type;
    }

    @Override
    public List<MonitoringTarget> getChildTargets() {
        return this.childTargets;
    }

    public void setChildren(List<MonitoringTarget> children) {
        this.childTargets = children;
    }

    @Override
    public List<Monitor> getMyMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<Monitor> monitors) {
        this.monitors = monitors;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.childTargets == null ? 0 : this.childTargets.hashCode());
        result = 31 * result + (this.monitors == null ? 0 : this.monitors.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicMonitoringTarget other = (BasicMonitoringTarget)obj;
        if (this.childTargets == null ? other.childTargets != null : !this.childTargets.equals(other.childTargets)) {
            return false;
        }
        if (this.monitors == null ? other.monitors != null : !this.monitors.equals(other.monitors)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public String toString() {
        return "BasicMonitoringTarget [type=" + (Object)((Object)this.type) + ", childTargets=" + this.childTargets + ", monitors=" + this.monitors + ", id=" + this.id + ", name=" + this.name + ", parentId=" + this.parentId + ", labels=" + this.labels + "]";
    }
}

