/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps;

import com.ca.apm.gaps.notifications.GapEventStore;
import com.ca.apm.gaps.notifications.GapsChangeNotifier;
import java.io.File;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableScheduling
@EnableAsync(proxyTargetClass=true)
public class GapsMain {
    private static final Logger logger = LoggerFactory.getLogger(GapsMain.class);
    private static final String PID_FILE = ".monitoring-gaps.pid";
    @Autowired
    GapsChangeNotifier gapsFinder;
    @Autowired
    GapEventStore gapEventStore;

    @PostConstruct
    public void init() {
        if (this.gapEventStore != null) {
            this.gapsFinder.addGapChangeListener(this.gapEventStore);
        }
    }

    public static void main(String[] args) {
        try {
            SpringApplication app = new SpringApplicationBuilder(new Class[]{GapsMain.class}).build();
            app.addListeners(new ApplicationListener[]{new ApplicationPidFileWriter(PID_FILE)});
            app.addListeners(new ApplicationListener[]{new ApplicationListener<WebServerInitializedEvent>(){

                public void onApplicationEvent(WebServerInitializedEvent event) {
                    System.err.println("INFO: APM Monitoring Gaps Service started.");
                }
            }});
            app.run(args);
        }
        catch (Exception ex) {
            System.err.println("ERROR: monitoring-gap start failed.");
            ex.printStackTrace(System.err);
        }
        finally {
            File pid = new File(PID_FILE);
            pid.deleteOnExit();
        }
    }
}

