/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps;

import com.google.gson.Gson;
import java.util.Base64;

public class TenantInfo {
    private String agentManagerUrl;
    private String publicApiToken;
    private String tenantId;
    private String cohortId;

    public TenantInfo() {
    }

    public TenantInfo(String agentManagerUrl, String token) throws Exception {
        this.agentManagerUrl = agentManagerUrl;
        this.publicApiToken = token;
        this.tenantId = TenantInfo.findTenantId(token);
    }

    public String getAgentManagerUrl() {
        return this.agentManagerUrl;
    }

    public void setAgentManagerUrl(String agentManagerUrl) {
        this.agentManagerUrl = agentManagerUrl;
    }

    public String getPublicApiToken() {
        return this.publicApiToken;
    }

    public void setPublicApiToken(String token) throws Exception {
        this.publicApiToken = token;
        this.tenantId = TenantInfo.findTenantId(token);
    }

    public String getTenantId() {
        if (this.tenantId != null) {
            return this.tenantId;
        }
        try {
            this.tenantId = TenantInfo.findTenantId(this.publicApiToken);
        }
        catch (Exception e) {
            this.tenantId = "N/A";
        }
        return this.tenantId;
    }

    public String getCohortId() {
        return this.cohortId;
    }

    public void setCohortId(String cohortId) {
        this.cohortId = cohortId;
    }

    public String toString() {
        return "TenantInfo [agentManagerUrl=" + this.agentManagerUrl + ", tenantId=" + this.tenantId + "]";
    }

    private static String findTenantId(String token) throws Exception {
        String[] tokens = token.split("\\.");
        if (tokens.length < 2) {
            throw new Exception("Invalid Public API token format.");
        }
        String json = new String(Base64.getDecoder().decode(tokens[1].getBytes()));
        return Integer.toString(((Bag)new Gson().fromJson(json, Bag.class)).getTid());
    }

    private class Bag {
        int tid;

        public Bag(int tid) {
            this.tid = tid;
        }

        public int getTid() {
            return this.tid;
        }
    }
}

