/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.controllers;

import com.ca.apm.gaps.Utils;
import com.ca.apm.gaps.api.BasicLabel;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.models.MonitoringBundle;
import com.ca.apm.gaps.serializers.BundleDeserializer;
import com.ca.apm.gaps.serializers.LabelSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atc/gaps/monitoring-bundles"})
public class MonitoringBundlesController {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringBundlesController.class);
    private static final String BUNDLES_FILE = "monitoring-bundles.json";
    MonitoringBundle[] bundles;
    MonitoringBundle[] emptyBundles = new MonitoringBundle[0];
    Gson gson;

    @PostConstruct
    public void init() {
        Type collectionType = new TypeToken<MonitoringBundle[]>(){}.getType();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(collectionType, (Object)new BundleDeserializer());
        this.gson = gsonBuilder.create();
        try {
            this.bundles = (MonitoringBundle[])this.gson.fromJson(Utils.readFile(BUNDLES_FILE), collectionType);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Label.class, (Object)new LabelSerializer());
        this.gson = gsonBuilder.create();
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<String> getBundles(@RequestParam(required=false) String type) {
        MonitoringBundle[] bundles = type == null ? this.bundles : this.getMonitoringBundleOfType(type);
        String json = this.gson.toJson((Object)bundles);
        return ResponseEntity.ok((Object)json);
    }

    public MonitoringBundle[] getMonitoringBundleOfType(String type) {
        return this.getMonitoringBundleOfType(MonitoringTarget.MonitoringTargetType.valueOf((String)type.toUpperCase()));
    }

    public MonitoringBundle[] getMonitoringBundleOfType(MonitoringTarget.MonitoringTargetType type) {
        if (type == null) {
            return this.emptyBundles;
        }
        return Arrays.stream((MonitoringBundle[])this.bundles.clone()).filter(b -> Arrays.stream(b.getMonitors()).anyMatch(label -> label.getKey().equals("targetType") && label.getValue().equalsIgnoreCase(type.name()))).collect(Collectors.toList()).toArray(this.emptyBundles);
    }

    public Map<String, MonitoringBundle> getMonitoringBundleAsMap(MonitoringTarget.MonitoringTargetType type) {
        HashMap<String, MonitoringBundle> bundleMap = new HashMap<String, MonitoringBundle>();
        Arrays.stream(this.getMonitoringBundleOfType(type)).forEach(bundle -> bundleMap.put(bundle.getName().toLowerCase(), (MonitoringBundle)bundle));
        return bundleMap;
    }

    public Map<String, MonitoringBundle> getBundlesApplicableForTarget(MonitoringTarget target) {
        HashMap<String, MonitoringBundle> bundleMap = new HashMap<String, MonitoringBundle>();
        Arrays.stream(this.getMonitoringBundleOfType(target.getType())).forEach(bundle -> {
            HashSet<Label> targetLabels = new HashSet<Label>(target.getLabels());
            targetLabels.add(BasicLabel.of((String)"targetType", (String)target.getType().name().toLowerCase()));
            if (targetLabels.containsAll(Arrays.asList(bundle.getMonitors()))) {
                bundleMap.put(bundle.getId().toLowerCase(), (MonitoringBundle)bundle);
            }
        });
        logger.debug("list of bundles available for monitoring target {}: ", (Object)target.getName(), bundleMap.keySet());
        return bundleMap;
    }
}

