/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.controllers;

import com.ca.apm.gaps.api.BasicLabel;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.api.Utils;
import com.ca.apm.gaps.controllers.MonitoringBundlesController;
import com.ca.apm.gaps.dao.MonitoringTargetDao;
import com.ca.apm.gaps.models.MonitoringBundle;
import com.ca.apm.gaps.models.MonitoringGap;
import com.ca.apm.gaps.serializers.LabelSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{tenantId}/atc/gaps/monitoring-gaps/query"})
public class MonitoringGapsController {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringGapsController.class);
    private Gson shortFormatJson;
    private Gson longFormatJson;
    @Autowired
    MonitoringTargetDao monitoringTargetDao;
    @Autowired
    MonitoringBundlesController bundlesRepo;

    @PostConstruct
    public void init() {
        GsonBuilder shortFormatbuilder = new GsonBuilder();
        shortFormatbuilder.registerTypeAdapter(MonitoringTarget.class, (Object)new TargetSerShort());
        shortFormatbuilder.registerTypeAdapter(MonitoringBundle.class, (Object)new BundleSerShort());
        this.shortFormatJson = shortFormatbuilder.create();
        GsonBuilder detailedFormatBuilder = new GsonBuilder();
        detailedFormatBuilder.registerTypeAdapter(MonitoringTarget.class, (Object)new TargetSerShort());
        detailedFormatBuilder.registerTypeAdapter(Label.class, (Object)new LabelSerializer());
        this.longFormatJson = detailedFormatBuilder.create();
    }

    @PostMapping(produces={"application/json"})
    public ResponseEntity<String> findGap(@PathVariable String tenantId, @RequestBody(required=false) Map<String, String> params, @RequestParam(defaultValue="false", name="details") Boolean details, @RequestParam(defaultValue="false", name="exclusive") Boolean exclusive) {
        logger.debug("received gaps query for tenant {} : {}", (Object)tenantId, params);
        if (params == null || params.isEmpty()) {
            return ResponseEntity.ok((Object)this.findTenantGaps(tenantId, details, exclusive));
        }
        boolean shortFormat = details == false;
        String hostId = params.get("hostId");
        String containerId = params.get("containerId");
        String proceessId = params.get("processId");
        String agentId = params.get("agentId");
        String prefix = MonitoringTarget.MonitoringTargetType.HOST.name().toLowerCase();
        if (hostId != null && !hostId.startsWith(prefix)) {
            hostId = Utils.createId((String)prefix, (String)hostId);
        }
        prefix = MonitoringTarget.MonitoringTargetType.CONTAINER.name().toLowerCase();
        if (containerId != null && !containerId.startsWith(prefix)) {
            containerId = Utils.createId((String)prefix, (String)containerId);
        }
        Optional<Object> mayBeGap = Optional.empty();
        if (hostId != null || containerId != null) {
            Optional<MonitoringTarget> hostOrContainerTarget = this.monitoringTargetDao.findRootTarget(tenantId, hostId == null ? containerId : hostId);
            if (hostOrContainerTarget.isPresent()) {
                mayBeGap = Optional.of(exclusive != false ? this.getOwnGaps(hostOrContainerTarget.get()) : this.getAllGaps(hostOrContainerTarget.get()));
            }
        } else if (agentId != null) {
            mayBeGap = this.getAgentGaps(tenantId, agentId, exclusive);
        }
        return ResponseEntity.ok((Object)(!mayBeGap.isPresent() ? "" : (shortFormat ? this.shortFormatJson : this.longFormatJson).toJson(mayBeGap.get())));
    }

    private String findTenantGaps(String tenantId, boolean details, boolean exclusive) {
        boolean shortFormat = !details;
        ArrayList<MonitoringGap> tenantGaps = new ArrayList<MonitoringGap>();
        for (MonitoringTarget target : this.monitoringTargetDao.getAllRootTargetsOfTenant(tenantId)) {
            tenantGaps.add(exclusive ? this.getOwnGaps(target) : this.getAllGaps(target));
        }
        return shortFormat ? this.shortFormatJson.toJson(tenantGaps) : this.longFormatJson.toJson(tenantGaps);
    }

    public Optional<MonitoringTarget> findAgentTarget(String tenantId, String agentId) {
        Optional<List<MonitoringTarget>> targets = this.findPathToAgentTarget(tenantId, agentId);
        return targets.isPresent() ? Optional.of(targets.get().get(targets.get().size() - 1)) : Optional.empty();
    }

    private Optional<List<MonitoringTarget>> findPathToAgentTarget(String tenantId, String agentId) {
        Optional<Collection<MonitoringTarget>> labelTargets = this.monitoringTargetDao.findRootTargetOfLabel(tenantId, BasicLabel.of((String)"agentId", (String)agentId));
        if (labelTargets.isPresent() && !labelTargets.get().isEmpty()) {
            MonitoringTarget hostTarget = labelTargets.get().iterator().next();
            ArrayList<MonitoringTarget> parents = new ArrayList<MonitoringTarget>();
            if (this.findDescendantTargetWithLabel(BasicLabel.of((String)"agentId", (String)agentId), hostTarget, parents)) {
                return Optional.of(parents);
            }
        }
        return Optional.empty();
    }

    private boolean findDescendantTargetWithLabel(Label label, MonitoringTarget target, List<MonitoringTarget> path) {
        path.add(target);
        if (target.getMyMonitors().stream().filter(m -> m.getLabels().stream().anyMatch(l -> l.equals(label))).findAny().isPresent()) {
            return true;
        }
        for (MonitoringTarget child : target.getChildTargets()) {
            if (!this.findDescendantTargetWithLabel(label, child, path)) continue;
            return true;
        }
        path.remove(path.size() - 1);
        return false;
    }

    public List<MonitoringBundle> getAgentGapsAsList(String tenantId, String agentId, boolean exclusive) {
        Optional<MonitoringGap> mayBeGap = this.getAgentGaps(tenantId, agentId, exclusive);
        if (mayBeGap.isPresent()) {
            ArrayList<MonitoringBundle> combinedBundlesList = new ArrayList<MonitoringBundle>();
            ArrayDeque<MonitoringGap> gapsQueue = new ArrayDeque<MonitoringGap>();
            gapsQueue.add(mayBeGap.get());
            while (!gapsQueue.isEmpty()) {
                int size = gapsQueue.size();
                while (size-- > 0) {
                    MonitoringGap curentGap = (MonitoringGap)gapsQueue.poll();
                    combinedBundlesList.addAll(curentGap.getMissingBundles());
                    gapsQueue.addAll(curentGap.getChildMonitoringGaps());
                }
            }
            return combinedBundlesList;
        }
        return Collections.emptyList();
    }

    private Optional<MonitoringGap> getAgentGaps(String tenantId, String agentId, boolean exclusive) {
        Optional<List<MonitoringTarget>> targets = this.findPathToAgentTarget(tenantId, agentId);
        if (targets.isPresent()) {
            MonitoringTarget processTarget = targets.get().get(targets.get().size() - 1);
            return Optional.of(exclusive ? this.getOwnGaps(processTarget) : this.getAncestorAndMyGaps(targets.get()));
        }
        return Optional.empty();
    }

    private MonitoringGap getAncestorAndMyGaps(List<MonitoringTarget> targets) {
        return this.getAncestorAndMyGaps(targets, 0);
    }

    private MonitoringGap getAncestorAndMyGaps(List<MonitoringTarget> targets, int index) {
        if (index == targets.size() - 1) {
            return this.getAllGaps(targets.get(index));
        }
        MonitoringGap parentGap = this.getOwnGaps(targets.get(index));
        parentGap.getChildMonitoringGaps().add(this.getAncestorAndMyGaps(targets, index + 1));
        return parentGap;
    }

    private MonitoringGap getAllGaps(MonitoringTarget target) {
        MonitoringGap myGap = this.getOwnGaps(target);
        for (MonitoringTarget child : target.getChildTargets()) {
            MonitoringGap childGap = this.getAllGaps(child);
            myGap.getChildMonitoringGaps().add(childGap);
        }
        return myGap;
    }

    public MonitoringGap getOwnGaps(MonitoringTarget target) {
        return new MonitoringGap(target, this.findAndAddMissingBundles(target));
    }

    public List<MonitoringBundle> findAndAddMissingBundles(MonitoringTarget target) {
        ArrayList<MonitoringBundle> bundles = new ArrayList<MonitoringBundle>();
        Map<String, MonitoringBundle> map = this.bundlesRepo.getBundlesApplicableForTarget(target);
        target.getMyMonitors().stream().forEach(monitor -> map.remove(monitor.getBundleId()));
        bundles.addAll(map.values());
        return bundles;
    }

    private class BundleSerShort
    implements JsonSerializer<MonitoringBundle> {
        private BundleSerShort() {
        }

        public JsonElement serialize(MonitoringBundle bundle, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(bundle.getName());
        }
    }

    private class TargetSerShort
    implements JsonSerializer<MonitoringTarget> {
        private TargetSerShort() {
        }

        public JsonElement serialize(MonitoringTarget target, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject targetObject = new JsonObject();
            targetObject.addProperty("id", target.getId());
            targetObject.addProperty("name", target.getName());
            targetObject.addProperty("type", target.getType().name());
            return targetObject;
        }
    }

    private class GapSerShort
    implements JsonSerializer<MonitoringGap> {
        private GapSerShort() {
        }

        public JsonElement serialize(MonitoringGap gap, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject targetGaps = new JsonObject();
            JsonArray bundles = new JsonArray();
            for (MonitoringBundle bundle : gap.getMissingBundles()) {
                bundles.add(bundle.getName());
            }
            targetGaps.addProperty("id", gap.getTarget().getId());
            targetGaps.addProperty("name", gap.getTarget().getName());
            targetGaps.add("gaps", (JsonElement)bundles);
            return targetGaps;
        }
    }
}

