/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.controllers;

import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.dao.MonitoringTargetDao;
import com.ca.apm.gaps.serializers.LabelSerializer;
import com.ca.apm.gaps.serializers.TargetDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{tenantId}/atc/gaps/monitoring-targets"})
public class MonitoringTargetController {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringTargetController.class);
    private Gson gsonForDeser;
    private Gson gsonForSer;
    static Type collectionType = new TypeToken<MonitoringTarget>(){}.getType();
    @Autowired
    MonitoringTargetDao monitoringTargetDao;

    @PostConstruct
    public void init() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(collectionType, (Object)new TargetDeserializer());
        this.gsonForDeser = gsonBuilder.create();
        gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Label.class, (Object)new LabelSerializer());
        this.gsonForSer = gsonBuilder.create();
    }

    @PostMapping(consumes={"application/json"})
    public void addTargetAndGaps(@PathVariable String tenantId, @RequestBody String body) {
        logger.debug("Received monitoring-data post request from tenant {} : {} ", (Object)tenantId, (Object)body);
        List targets = (List)this.gsonForDeser.fromJson(body, collectionType);
        for (MonitoringTarget target : targets) {
            this.monitoringTargetDao.saveTarget(tenantId, target);
        }
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<String> fetchAllTargets(@PathVariable String tenantId) {
        List<MonitoringTarget> targets = this.monitoringTargetDao.getAllRootTargetsOfTenant(tenantId);
        String json = this.gsonForSer.toJson(targets);
        return ResponseEntity.ok((Object)json);
    }
}

