/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.dao;

import com.ca.apm.gaps.api.BasicMonitoringTarget;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.dao.MonitoringTargetDao;
import com.ca.apm.gaps.models.Utils;
import com.ca.apm.gaps.notifications.GapChangeEvent;
import com.ca.apm.gaps.notifications.GapChangeListener;
import com.ca.apm.gaps.notifications.GapsChangeNotifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.stereotype.Component;

@Component
public class MonitoringTargetInMemoryDao
implements MonitoringTargetDao,
GapsChangeNotifier {
    private static final MonitoringTarget DUMMY_TARGET = new BasicMonitoringTarget("dummy", MonitoringTarget.MonitoringTargetType.NONE);
    private final Map<String, Map<String, MonitoringTarget>> tenantCache = new ConcurrentHashMap<String, Map<String, MonitoringTarget>>();
    private final Map<String, Map<Label, Collection<MonitoringTarget>>> labelToRootTargetId = new HashMap<String, Map<Label, Collection<MonitoringTarget>>>();
    private final List<GapChangeListener> listeners = new ArrayList<GapChangeListener>();

    @Override
    public void saveTarget(String tenantId, MonitoringTarget target) {
        boolean updated = false;
        Map targets = this.tenantCache.computeIfAbsent(tenantId, k -> new ConcurrentHashMap());
        MonitoringTarget existingTarget = targets.getOrDefault(target.getId(), DUMMY_TARGET);
        boolean bl = updated = !existingTarget.equals(target);
        if (updated) {
            Optional hostName;
            targets.put(target.getId(), target);
            HashSet<Label> interestingLabels = new HashSet<Label>();
            for (Label agentIdLabel : MonitoringTargetInMemoryDao.getLabelsWithKey(target, "agentId")) {
                Collection currentTargets = this.labelToRootTargetId.computeIfAbsent(tenantId, k -> new ConcurrentHashMap()).computeIfAbsent(agentIdLabel, k2 -> new ConcurrentLinkedQueue());
                currentTargets.remove(existingTarget);
                currentTargets.add(target);
                interestingLabels.add(agentIdLabel);
            }
            for (Label externalId : MonitoringTargetInMemoryDao.getLabelsWithKey(target, "externalId")) {
                interestingLabels.add(externalId);
            }
            Optional containerId = target.getLabelWithKey("containerId");
            if (containerId.isPresent()) {
                interestingLabels.add((Label)containerId.get());
            }
            if ((hostName = target.getLabelWithKey("hostname")).isPresent()) {
                interestingLabels.add((Label)hostName.get());
            }
            GapChangeEvent event = new GapChangeEvent(tenantId, target, interestingLabels);
            this.notifyGap(event);
        }
    }

    @Override
    public void notifyGap(GapChangeEvent event) {
        for (GapChangeListener listener : this.listeners) {
            listener.notify(event);
        }
    }

    @Override
    public Optional<MonitoringTarget> findRootTarget(String tenantId, String targetId) {
        return Optional.ofNullable((MonitoringTarget)this.tenantCache.getOrDefault(tenantId, Collections.emptyMap()).get(targetId));
    }

    @Override
    public Optional<Collection<MonitoringTarget>> findRootTargetOfLabel(String tenantId, Label label) {
        return Optional.ofNullable((Collection)this.labelToRootTargetId.getOrDefault(tenantId, Collections.emptyMap()).get(label));
    }

    public Optional<MonitoringTarget> findAgentTarget(String tenantId, String agentId) {
        return Optional.empty();
    }

    @Override
    public boolean existsTarget(String tenantId, String targetId) {
        return this.findRootTargetWithId(tenantId, targetId).isPresent();
    }

    public boolean existsRootTarget(String tenantId, String targetId) {
        return this.tenantCache.containsKey(targetId) ? this.tenantCache.get(tenantId).containsKey(targetId) : false;
    }

    public Optional<MonitoringTarget> findRootTargetOfChild(String tenantId, MonitoringTarget target) {
        return target.getParentId() == null ? Optional.of(target) : this.findRootTargetWithId(tenantId, Utils.getRootTargetId(target.getId()));
    }

    public Optional<MonitoringTarget> findRootTargetWithId(String tenantId, String targetId) {
        return this.findRootTarget(tenantId, targetId.split("-")[0]);
    }

    @Override
    public List<MonitoringTarget> getAllRootTargetsOfTenant(String tenantId) {
        return new ArrayList<MonitoringTarget>(this.tenantCache.getOrDefault(tenantId, Collections.emptyMap()).values());
    }

    private static List<Label> getLabelsWithKey(MonitoringTarget target, String key) {
        ArrayList<Label> labels = new ArrayList<Label>();
        MonitoringTargetInMemoryDao.addLabelsWithKey(target, key, labels);
        return labels;
    }

    private static void addLabelsWithKey(MonitoringTarget target, String key, List<Label> labels) {
        Optional label = target.getLabelWithKey(key);
        if (label.isPresent()) {
            labels.add((Label)label.get());
        }
        target.getMyMonitors().stream().forEach(monitor -> {
            Optional label2 = monitor.getLabelWithKey(key);
            if (label2.isPresent()) {
                labels.add((Label)label2.get());
            }
        });
        for (MonitoringTarget childTarget : target.getChildTargets()) {
            MonitoringTargetInMemoryDao.addLabelsWithKey(childTarget, key, labels);
        }
    }

    Optional<MonitoringTarget> findChildWithLabel(Label label, MonitoringTarget target, List<MonitoringTarget> parents) {
        if (target.getMyMonitors().stream().filter(m -> m.getLabels().stream().anyMatch(l -> l.equals(label))).findAny().isPresent()) {
            return Optional.of(target);
        }
        for (MonitoringTarget child : target.getChildTargets()) {
            parents.add(target);
            Optional<MonitoringTarget> match = this.findChildWithLabel(label, child, parents);
            if (match.isPresent()) {
                return match;
            }
            parents.remove(parents.size() - 1);
        }
        return Optional.empty();
    }

    @Override
    public void addGapChangeListener(GapChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeGapChangeListener(GapChangeListener listener) {
        this.listeners.remove(listener);
    }
}

