/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.discovery;

import com.ca.apm.gaps.MonitoringBundles;
import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.Utils;
import com.ca.apm.gaps.api.BasicLabel;
import com.ca.apm.gaps.api.BasicMonitor;
import com.ca.apm.gaps.api.Container;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.discovery.AbstractDiscoverer;
import com.ca.apm.gaps.discovery.Discoverer;
import com.ca.apm.gaps.query.api.MetricQuery;
import com.ca.apm.gaps.query.api.MonitoringResourceQuery;
import com.ca.apm.gaps.query.api.ResourceData;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class ContainerDiscoverer
extends AbstractDiscoverer<Container>
implements Discoverer<Container> {
    private static final Logger logger = LoggerFactory.getLogger(ContainerDiscoverer.class);
    private static final String CONTAINER_METRIC_NAME = "Host:Container ID";
    private MetricQuery containerMetricQuery;

    ContainerDiscoverer(TenantInfo tenant, RestTemplate restTemplate) {
        this("Container And UMA Discovery", "1.0", tenant, restTemplate);
    }

    ContainerDiscoverer(String name, String version, TenantInfo tenant, RestTemplate restTemplate) {
        super(name, version, tenant, restTemplate);
        this.containerMetricQuery = new MetricQuery(restTemplate, tenant, CONTAINER_METRIC_NAME);
    }

    @Override
    public Set<Container> discover() {
        logger.debug("Running container discovery " + this.toString());
        Set<Container> containers = this.findAllContainers();
        for (Container container : containers) {
            try {
                this.verifyAndAddMonitor(container);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return containers;
    }

    private Set<Container> findAllContainers() {
        HashSet<Container> containers = new HashSet<Container>();
        try {
            Optional<Map<String, Map<String, String>>> conainerData = this.containerMetricQuery.execute();
            if (conainerData.isPresent()) {
                logger.debug("Containers data received for metric query: {}", conainerData.get());
                conainerData.get().forEach((id, map) -> {
                    String containerId = (String)map.get(CONTAINER_METRIC_NAME);
                    if (Utils.isValid(containerId)) {
                        containers.add(this.createContainerTarget(containerId, (String)id));
                    }
                });
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return containers;
    }

    protected Container createContainerTarget(String containerId, String agentId) {
        Container container = new Container(containerId);
        container.addLabel(BasicLabel.of((String)"containerId", (String)containerId));
        Optional<ResourceData> resourceData = this.getAgentData(agentId);
        if (resourceData.isPresent()) {
            Optional<MonitoringTarget> process;
            ResourceData data = resourceData.get();
            if (data.getAgentId().isPresent() && (process = this.createProcessTargetForAgent(data)).isPresent()) {
                container.getChildTargets().add(process.get());
            }
            container.addLabel(BasicLabel.of((String)"externalId", data.getExternalId()));
        }
        return container;
    }

    public void verifyAndAddMonitor(Container container) {
        if (!Utils.isValid(container.getId())) {
            logger.debug("Invalid Container data: {}", (Object)container);
            return;
        }
        MonitoringResourceQuery.Builder queryBuilder = new MonitoringResourceQuery.Builder(this.tenant, this.restTemplate);
        MonitoringResourceQuery query = queryBuilder.hasAttribute("k8s_container_state", "Running").inLayer("INFRASTRUCTURE").hasAttribute("k8s_pod_container_id", container.getContainerId()).build();
        Optional<List<ResourceData>> containerResources = query.execute();
        if (containerResources.isPresent()) {
            logger.debug("uma data received for graph query:" + containerResources.get());
            List<ResourceData> monitors = containerResources.get();
            monitors.forEach(resource -> {
                Optional<String> agentId = resource.getAgentId();
                if (agentId.isPresent()) {
                    BasicMonitor uma = new BasicMonitor(com.ca.apm.gaps.api.Utils.createId((String)"monitor", (String)agentId.get()), "UMA", MonitoringBundles.UMA.getId());
                    container.getMyMonitors().add(uma);
                }
            });
        }
    }

    @Override
    public String toString() {
        return "ContainerDiscovery [tenantId=" + this.tenant.getTenantId() + ", name=" + this.getName() + ", version=" + this.getVersion() + "]";
    }
}

