/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.discovery;

import com.ca.apm.gaps.GapsConfiguration;
import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.api.BasicMonitoringTarget;
import com.ca.apm.gaps.api.Container;
import com.ca.apm.gaps.api.Host;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.discovery.ContainerDiscoverer;
import com.ca.apm.gaps.discovery.Discoverer;
import com.ca.apm.gaps.discovery.FakeData;
import com.ca.apm.gaps.discovery.HostDiscoverer;
import com.ca.apm.gaps.serializers.LabelSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DiscoveryTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryTask.class);
    private static final String MONITORING_RESOURCES_URL_UNFORMATTED = "%s/%s/atc/gaps/monitoring-targets";
    private final Discoverer<Container> containerDiscovery;
    private final Discoverer<Host> hostDiscovery;
    private final TenantInfo tenant;
    private final Gson gson;
    private final RestTemplate restTemplate;
    private final String gapsServiceUrl;
    private MultiValueMap<String, String> headers;

    public DiscoveryTask(TenantInfo tenant, RestTemplate restTemplate, String gapsServiceUrl, GapsConfiguration config) {
        this.tenant = tenant;
        this.restTemplate = restTemplate;
        this.gapsServiceUrl = gapsServiceUrl;
        this.containerDiscovery = config.containerDicoveryEnabled ? new ContainerDiscoverer(tenant, restTemplate) : new NoopDiscoverer();
        this.hostDiscovery = config.hostDicoveryEnabled ? new HostDiscoverer(tenant, restTemplate) : new NoopDiscoverer();
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Label.class, (Object)new LabelSerializer());
        this.gson = builder.create();
        this.headers = new LinkedMultiValueMap();
        this.headers.add((Object)"Content-Type", (Object)"application/json;charset=UTF-8");
        this.headers.add((Object)"Connection", (Object)"close");
    }

    @Override
    public void run() {
        Set<Object> containers;
        logger.debug("Running monitoring target discovery task for tenant {}", (Object)this.tenant.getTenantId());
        boolean fake = false;
        Set<Object> set = containers = fake ? new HashSet() : this.containerDiscovery.discover();
        if (fake) {
            FakeData fakeData = new FakeData();
        }
        logger.info("Discovered container targets: " + containers.toString());
        this.reportMonitoringTargets(containers);
        Set<Host> hosts = this.hostDiscovery.discover();
        logger.info("Discovered host targets: " + hosts.toString());
        this.reportMonitoringTargets(hosts);
    }

    private void reportMonitoringTargets(Set<? extends BasicMonitoringTarget> targets) {
        if (targets.isEmpty()) {
            logger.debug("No monitoring targets to report.");
            return;
        }
        String url = String.format(MONITORING_RESOURCES_URL_UNFORMATTED, this.gapsServiceUrl, this.tenant.getTenantId());
        if (logger.isDebugEnabled()) {
            logger.debug("Making a post request to  {} with payload {}", (Object)url, (Object)this.gson.toJson(targets));
        }
        try {
            HttpEntity entity = new HttpEntity((Object)this.gson.toJson(targets), this.headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private static final class NoopDiscoverer<T extends MonitoringTarget>
    implements Discoverer<T> {
        private NoopDiscoverer() {
        }

        @Override
        public String getName() {
            return "NoopDiscoverer";
        }

        @Override
        public String getVersion() {
            return "0";
        }

        @Override
        public Set<T> discover() {
            return Collections.emptySet();
        }
    }
}

