/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.discovery;

import com.ca.apm.gaps.GapsConfiguration;
import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.TenantsAdmin;
import com.ca.apm.gaps.discovery.DiscoveryTask;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class GapsDiscoveryClient {
    private static final Logger logger = LoggerFactory.getLogger(GapsDiscoveryClient.class);
    private static final String SERVICE_NAME = "Monitoring Gaps Discovery Service";
    @Autowired
    TenantsAdmin tenantDetails;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    GapsConfiguration config;
    @Value(value="${gaps.service.url:http://localhost:8080}")
    private String gapsServiceUrl;

    public static void main(String[] args) {
        SpringApplication.run(GapsDiscoveryClient.class, (String[])args);
        logger.info("Started '{}'", (Object)SERVICE_NAME);
    }

    @PostConstruct
    public void init() {
    }

    @Scheduled(fixedRateString="${gaps.discovery.frequency:300000}")
    public void discover() {
        logger.debug("Running monitoring target discovery task");
        if (this.tenantDetails != null && this.tenantDetails.getTenants() != null) {
            for (TenantInfo tenant : this.tenantDetails.getTenants()) {
                new DiscoveryTask(tenant, this.restTemplate, this.gapsServiceUrl, this.config).run();
            }
        }
    }
}

