/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.notifications;

import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.MonitoringTarget;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GapChangeEvent {
    private String tenantId;
    private MonitoringTarget target;
    private Map<String, Label> labels;

    public GapChangeEvent(String tenantId, MonitoringTarget target, Set<Label> labels) {
        this.tenantId = tenantId;
        this.target = target;
        this.labels = new HashMap<String, Label>();
        labels.forEach(label -> this.labels.put(label.getKey(), (Label)label));
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public MonitoringTarget getTarget() {
        return this.target;
    }

    public Optional<Label> getLabel(String key) {
        return Optional.ofNullable(this.labels.get(key));
    }

    public boolean containsLabel(String key) {
        return this.labels.containsKey(key);
    }

    public String toString() {
        return "GapChangeEvent [tenantId=" + this.tenantId + ", targetId=" + this.target.getId() + ", labels=" + this.labels + "]";
    }
}

