/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.query.api;

import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.Utils;
import com.ca.apm.gaps.query.api.AgentType;
import com.ca.apm.gaps.query.api.HostType;
import com.ca.apm.gaps.query.api.MetricQuery;
import com.ca.apm.gaps.query.api.ResourceData;
import com.ca.apm.gaps.query.api.ResourceQuery;
import com.ca.apm.gaps.query.api.TasGraphQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.web.client.RestTemplate;

public class MonitoringResourceQuery
implements ResourceQuery {
    private TenantInfo tenant;
    private RestTemplate restTemplate;
    private TasGraphQuery graphQuery;
    private List<String> attributesToReport;
    private Map<String, String> attributesToMatch;

    MonitoringResourceQuery(Builder builder) {
        this.graphQuery = new TasGraphQuery(builder.tenant, builder.restTemplate, builder.layer, builder.attributesToMatch);
        this.attributesToMatch = builder.attributesToMatch;
        this.attributesToReport = builder.attributesToReport;
        this.tenant = builder.tenant;
        this.restTemplate = builder.restTemplate;
    }

    @Override
    public Optional<List<ResourceData>> execute() {
        Optional<List<Map<String, String>>> bags = this.graphQuery.execute();
        if (!bags.isPresent()) {
            return Optional.empty();
        }
        ArrayList data = new ArrayList();
        bags.get().forEach(bag -> {
            ResourceData attributes = new ResourceData((Map<String, String>)bag);
            if (!bag.keySet().containsAll(this.attributesToReport)) {
                String agentName = this.attributesToMatch.get("agent");
                if (!Utils.isValid(agentName)) {
                    agentName = (String)bag.get("agent");
                }
                if (Utils.isValid(agentName)) {
                    HashSet<String> metrics = new HashSet<String>(this.attributesToReport);
                    metrics.removeAll(bag.keySet());
                    MetricQuery metricQuery = new MetricQuery(this.restTemplate, this.tenant, agentName, new ArrayList<String>(metrics));
                    Optional<Map<String, Map<String, String>>> metricBags = metricQuery.execute();
                    if (metricBags.isPresent()) {
                        attributes.addAllAttributes(metricBags.get().getOrDefault(agentName, Collections.emptyMap()));
                    }
                }
            }
            data.add(attributes);
        });
        return Optional.of(data);
    }

    public static class Builder {
        private TenantInfo tenant;
        private RestTemplate restTemplate;
        private String layer = "ANY";
        private Map<String, String> attributesToMatch = new HashMap<String, String>();
        private List<String> attributesToReport = new ArrayList<String>();

        public Builder(TenantInfo tenant, RestTemplate restTemplate) {
            this.tenant = tenant;
            this.restTemplate = restTemplate;
        }

        public Builder inLayer(String layer) {
            this.layer = layer;
            return this;
        }

        public Builder hasAttribute(String name, String value) {
            this.attributesToMatch.put(name, value);
            return this;
        }

        public Builder hasAttribute(String name) {
            this.hasAttribute(name, null);
            return this;
        }

        public Builder hasHostName(String host) {
            this.hasAttribute("hostname", host);
            return this;
        }

        public Builder reportAttribute(String attribute) {
            this.attributesToReport.add(attribute);
            return this;
        }

        public Builder reportHostName() {
            this.reportAttribute("hostname");
            return this;
        }

        public Builder reportAgentName() {
            this.reportAttribute("agent");
            return this;
        }

        public Builder findAgents() {
            this.inLayer("APM_INFRASTRUCTURE");
            this.hasAttribute("Type", "AGENT");
            this.hasAttribute("agentIsConnected", "true");
            this.reportAttribute("agent");
            return this;
        }

        public Builder findAgentWithName(String agentName) {
            this.inLayer("APM_INFRASTRUCTURE");
            this.hasAttribute("Type", "AGENT");
            this.hasAttribute("agent", agentName);
            this.hasAttribute("agentIsConnected", "true");
            return this;
        }

        public Builder ofAgentType(AgentType agentType) {
            this.inLayer("APM_INFRASTRUCTURE");
            this.hasAttribute("agentType", agentType.name());
            return this;
        }

        public Builder findHosts() {
            this.inLayer("INFRASTRUCTURE");
            this.hasAttribute("Type", "HOST");
            return this;
        }

        public Builder ofHostType(HostType hostType) {
            this.inLayer("INFRASTRUCTURE");
            return this;
        }

        public MonitoringResourceQuery build() {
            return new MonitoringResourceQuery(this);
        }
    }
}

