/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.query.api;

import java.util.Map;
import java.util.Optional;

public class ResourceData {
    private final Map<String, String> attributes;

    ResourceData(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void addAllAttributes(Map<String, String> other) {
        other.forEach((key, value) -> this.addAttribute((String)key, (String)value));
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key.toLowerCase(), value);
    }

    public Optional<String> getHostName() {
        return this.getAttributeValue("hostname");
    }

    public Optional<String> getExternalId() {
        return this.getAttributeValue("externalId");
    }

    public Optional<String> getSimpleHostName() {
        String name;
        int index;
        Optional<String> host = this.getHostName();
        if (host.isPresent() && (index = (name = host.get()).indexOf(46)) > 0) {
            return Optional.of(name.substring(0, index));
        }
        return host;
    }

    public Optional<String> getAgentId() {
        return this.getAttributeValue("agent");
    }

    public Optional<String> getAttributeValue(String attribute) {
        return Optional.ofNullable(this.attributes.get(attribute.toLowerCase()));
    }

    public String toString() {
        return "ResourceData [attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceData other = (ResourceData)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }
}

