/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.serializers;

import com.ca.apm.gaps.api.BasicLabel;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.models.MonitoringBundle;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDeserializer
extends TypeAdapter<MonitoringBundle[]> {
    private static final Logger logger = LoggerFactory.getLogger(BundleDeserializer.class);

    public void write(JsonWriter out, MonitoringBundle[] value) throws IOException {
    }

    public MonitoringBundle[] read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<MonitoringBundle> bundles = new ArrayList<MonitoringBundle>();
        in.beginArray();
        while (in.hasNext()) {
            MonitoringBundle bundle = this.readBundle(in);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        in.endArray();
        return bundles.toArray(new MonitoringBundle[bundles.size()]);
    }

    private MonitoringBundle readBundle(JsonReader in) throws IOException {
        MonitoringBundle bundle = new MonitoringBundle();
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals("id")) {
                bundle.setId(in.nextString());
                continue;
            }
            if (name.equals("name")) {
                bundle.setName(in.nextString());
                continue;
            }
            if (name.equals("description")) {
                bundle.setDescription(in.nextString());
                continue;
            }
            if (name.equals("version")) {
                bundle.setVersion(in.nextString());
                continue;
            }
            if (name.equals("docUrls")) {
                ArrayList<String> urls = new ArrayList<String>();
                in.beginArray();
                while (in.hasNext()) {
                    urls.add(in.nextString());
                }
                in.endArray();
                bundle.setDocUrls(urls.toArray(new String[urls.size()]));
                continue;
            }
            if (name.equals("monitors")) {
                bundle.setMonitors(this.readLabels(in));
                continue;
            }
            if (name.equals("labels")) {
                bundle.setLabels(this.readLabels(in));
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return bundle;
    }

    private Label[] readLabels(JsonReader in) throws IOException {
        ArrayList<Label> labels = new ArrayList<Label>();
        in.beginArray();
        while (in.hasNext()) {
            labels.add(this.readLabel(in));
        }
        in.endArray();
        return labels.toArray(new Label[labels.size()]);
    }

    private Label readLabel(JsonReader in) throws IOException {
        String key = null;
        String value = null;
        in.beginObject();
        while (in.hasNext()) {
            key = in.nextName();
            value = in.nextString();
        }
        in.endObject();
        return new BasicLabel(key, value);
    }
}

